/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CommandLine.java 9961 2012-03-26 08:27:33Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.shelbie.command;

import org.ow2.jasmine.deployme.api.ICommandLine;

/**
 * Represent the command line arguments
 * 
 * @author Remy Bresson
 */
public class CommandLine implements ICommandLine {

    /**
     * Verbose?
     */
    protected boolean verbose;

    /**
     * Toplogy file path
     */
    protected String topologyFile;

    /**
     * Server name
     */
    protected String serverName;

    /**
     * Domain name
     */
    protected String domainName;

    /**
     * Host name
     */
    protected String machineName;

    /**
     * Cluster name
     */
    protected String clusterName;

    /**
     * Default constructor
     */
    public CommandLine() {
        this.verbose = false;
        this.topologyFile = null;
        this.serverName = null;
        this.domainName = null;
        this.machineName = null;
    }

    /**
     * {@inheritDoc}
     */
    public boolean getVerbose() {
        return this.verbose;
    }

    /**
     * {@inheritDoc}
     */
    public String getTopologyFile() {
        return this.topologyFile;
    }

    /**
     * {@inheritDoc}
     */
    public String getServerName() {
        return this.serverName;
    }

    /**
     * {@inheritDoc}
     */
    public String getDomainName() {
        return this.domainName;
    }

    /**
     * {@inheritDoc}
     */
    public String getMachineName() {
        return this.machineName;
    }

    /**
     * {@inheritDoc}
     */
    public String getClusterName() {
        return this.clusterName;
    }

    /**
     * {@inheritDoc}
     */
    public void addValue(final String argName, final String argValue) {
        if (argName.equals(COMMAND_OPTION_VERBOSE)) {
            this.verbose = true;
        } else if (argName.equals(COMMAND_OPTION_SERVER_NAME)) {
            this.serverName = argValue;
        } else if (argName.equals(COMMAND_OPTION_DOMAIN_NAME)) {
            this.domainName = argValue;
        } else if (argName.equals(COMMAND_OPTION_TOPOLOGY_FILE)) {
            this.topologyFile = argValue;
        } else if (argName.equals(COMMAND_OPTION_MACHINE_NAME)) {
            this.machineName = argValue;
        } else if (argName.equals(COMMAND_OPTION_CLUSTER_NAME)) {
            this.clusterName = argValue;
        } else {
            throw new IllegalArgumentException("'" + argName + "' is not a valid JASMINe Deploy ME option.");
        }
    }

    /**
     * {@inheritDoc}
     */
    public void checkCommandLine() throws IllegalArgumentException {
        if (this.topologyFile == null) {
            throw new IllegalArgumentException(ERROR_TOPOLOGY_NOT_SET);
        }

        if (this.domainName != null) {
            if (this.serverName != null) {
                if (this.clusterName != null) {
                    throw new IllegalArgumentException(ERROR_CLUSTER_SERVER);
                } else { // cluster == null
                    if (this.machineName != null) {
                        throw new IllegalArgumentException(ERROR_MACHINE_DOMAIN_SERVER_CLUSTER);
                    } else {
                        // OK : usage domain.server
                    }
                }
            } else { // server == null
                if (this.clusterName != null) {
                    if (this.machineName != null) {
                        throw new IllegalArgumentException(ERROR_MACHINE_DOMAIN_SERVER_CLUSTER);
                    } else {
                        // OK : usage domain.cluster
                    }
                } else {
                    if (this.machineName != null) {
                        throw new IllegalArgumentException(ERROR_MACHINE_DOMAIN_SERVER_CLUSTER);
                    } else {
                        throw new IllegalArgumentException(ERROR_SERVER_CLUSTER_DOMAIN);
                    }
                }
            }
        } else { // domain == null
            if (this.serverName != null) {
                throw new IllegalArgumentException(ERROR_DOMAIN_SERVER_CLUSTER);
            } else { // server == null
                if (this.clusterName != null) {
                    throw new IllegalArgumentException(ERROR_DOMAIN_SERVER_CLUSTER);
                } else {
                    if (this.machineName != null) {
                        // OK : usage machine
                    } else {
                        throw new IllegalArgumentException(ERROR_NO_OPTIONS);
                    }
                }
            }
        }
    }

    /**
     * @param verbose The verbosity to set
     */
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    /**
     * @param topologyFile The topology file to set
     */
    public void setTopologyFile(final String topologyFile) {
        this.topologyFile = topologyFile;
    }

    /**
     * @param serverName The server name to set
     */
    public void setServerName(final String serverName) {
        this.serverName = serverName;
    }

    /**
     * @param domainName The domain name to set
     */
    public void setDomainName(final String domainName) {
        this.domainName = domainName;
    }

    /**
     * @param machineName The machine name to set
     */
    public void setMachineName(final String machineName) {
        this.machineName = machineName;
    }

    /**
     * @param clusterName The cluster name to set
     */
    public void setClusterName(final String clusterName) {
        this.clusterName = clusterName;
    }
}
