/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.shelbie.command;

import org.ow2.jasmine.deployme.api.ICommandLine;

public class CommandLine
implements ICommandLine {
    protected boolean verbose = false;
    protected String topologyFile = null;
    protected String serverName = null;
    protected String domainName = null;
    protected String machineName = null;
    protected String clusterName;

    public boolean getVerbose() {
        return this.verbose;
    }

    public String getTopologyFile() {
        return this.topologyFile;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void addValue(String argName, String argValue) {
        if (argName.equals("verbose")) {
            this.verbose = true;
        } else if (argName.equals("serverName")) {
            this.serverName = argValue;
        } else if (argName.equals("domainName")) {
            this.domainName = argValue;
        } else if (argName.equals("topologyFile")) {
            this.topologyFile = argValue;
        } else if (argName.equals("machineName")) {
            this.machineName = argValue;
        } else if (argName.equals("clusterName")) {
            this.clusterName = argValue;
        } else {
            throw new IllegalArgumentException("'" + argName + "' is not a valid JASMINe Deploy ME option.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkCommandLine() throws IllegalArgumentException {
        if (this.topologyFile == null) {
            throw new IllegalArgumentException("The 'topologyFile' option is mandatory");
        }
        if (this.domainName != null) {
            if (this.serverName != null) {
                if (this.clusterName != null) {
                    throw new IllegalArgumentException("Only one of the 'clusterName' and 'serverName' options must be set");
                }
                if (this.machineName == null) return;
                throw new IllegalArgumentException("The 'machineName' option must not be set when one of the 'clusterName', 'domainName' or 'serverName' options are set");
            }
            if (this.clusterName != null) {
                if (this.machineName == null) return;
                throw new IllegalArgumentException("The 'machineName' option must not be set when one of the 'clusterName', 'domainName' or 'serverName' options are set");
            }
            if (this.machineName == null) throw new IllegalArgumentException("One of the 'serverName' or 'clusterName' options must be set when the 'domainName' option is set");
            throw new IllegalArgumentException("The 'machineName' option must not be set when one of the 'clusterName', 'domainName' or 'serverName' options are set");
        }
        if (this.serverName != null) {
            throw new IllegalArgumentException("The 'clusterName' and 'serverName' options require the 'domainName' to be set");
        }
        if (this.clusterName != null) {
            throw new IllegalArgumentException("The 'clusterName' and 'serverName' options require the 'domainName' to be set");
        }
        if (this.machineName != null) return;
        throw new IllegalArgumentException("No options set. You must set one of the 'machineName', 'domainName', 'clusterName' or 'serverName' options");
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setTopologyFile(String topologyFile) {
        this.topologyFile = topologyFile;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setMachineName(String machineName) {
        this.machineName = machineName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }
}

