/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.shelbie.command;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.ow2.jasmine.deployme.api.IDeployMeService;
import org.ow2.jasmine.shelbie.command.CommandLine;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Command(name="deploy", scope="deployme", description="DeployME Command")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class DeployMeCommand
implements Action,
Pojo {
    private InstanceManager __IM;
    public static final String DASH = "-";
    public static final String TOPOLOGY_FILE_OPTION = "-topologyFile";
    public static final String MACHINE_NAME_OPTION = "-machineName";
    public static final String DOMAIN_NAME_OPTION = "-domainName";
    public static final String SERVER_NAME_OPTION = "-serverName";
    public static final String CLUSTER_NAME_OPTION = "-clusterName";
    public static final String HELP_OPTION = "-help";
    private boolean __Fdeployme;
    @Requires(optional=false)
    private IDeployMeService deployme;
    private boolean __FtopologyFilePath;
    @Option(name="-topologyFile", required=true)
    private String topologyFilePath;
    private boolean __FmachineName;
    @Option(name="-machineName", required=false)
    private String machineName;
    private boolean __FdomainName;
    @Option(name="-domainName", required=false)
    private String domainName;
    private boolean __FserverName;
    @Option(name="-serverName", required=false)
    private String serverName;
    private boolean __FclusterName;
    @Option(name="-clusterName", required=false)
    private String clusterName;
    private boolean __Fhelp;
    @Option(name="-help", required=false)
    private String help;
    private boolean __Farguments;
    @Argument(multiValued=true)
    private List<String> arguments;
    private boolean __Flang;
    @Option(name="-", aliases={"--lang"}, required=false)
    private String lang;
    private static Log logger = LogFactory.getLog(DeployMeCommand.class);
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;
    private boolean __Mhelp;
    private boolean __MsetTopologyFilePath$java_lang_String;
    private boolean __MsetMachineName$java_lang_String;
    private boolean __MsetDomainName$java_lang_String;
    private boolean __MsetDeploymeManager$org_ow2_jasmine_deployme_api_IDeployMeService;
    private boolean __MsetServerName$java_lang_String;
    private boolean __MsetClusterName$java_lang_String;

    IDeployMeService __getdeployme() {
        if (!this.__Fdeployme) {
            return this.deployme;
        }
        return (IDeployMeService)this.__IM.onGet((Object)this, "deployme");
    }

    void __setdeployme(IDeployMeService iDeployMeService) {
        if (!this.__Fdeployme) {
            this.deployme = iDeployMeService;
            return;
        }
        this.__IM.onSet((Object)this, "deployme", (Object)iDeployMeService);
    }

    String __gettopologyFilePath() {
        if (!this.__FtopologyFilePath) {
            return this.topologyFilePath;
        }
        return (String)this.__IM.onGet((Object)this, "topologyFilePath");
    }

    void __settopologyFilePath(String string) {
        if (!this.__FtopologyFilePath) {
            this.topologyFilePath = string;
            return;
        }
        this.__IM.onSet((Object)this, "topologyFilePath", (Object)string);
    }

    String __getmachineName() {
        if (!this.__FmachineName) {
            return this.machineName;
        }
        return (String)this.__IM.onGet((Object)this, "machineName");
    }

    void __setmachineName(String string) {
        if (!this.__FmachineName) {
            this.machineName = string;
            return;
        }
        this.__IM.onSet((Object)this, "machineName", (Object)string);
    }

    String __getdomainName() {
        if (!this.__FdomainName) {
            return this.domainName;
        }
        return (String)this.__IM.onGet((Object)this, "domainName");
    }

    void __setdomainName(String string) {
        if (!this.__FdomainName) {
            this.domainName = string;
            return;
        }
        this.__IM.onSet((Object)this, "domainName", (Object)string);
    }

    String __getserverName() {
        if (!this.__FserverName) {
            return this.serverName;
        }
        return (String)this.__IM.onGet((Object)this, "serverName");
    }

    void __setserverName(String string) {
        if (!this.__FserverName) {
            this.serverName = string;
            return;
        }
        this.__IM.onSet((Object)this, "serverName", (Object)string);
    }

    String __getclusterName() {
        if (!this.__FclusterName) {
            return this.clusterName;
        }
        return (String)this.__IM.onGet((Object)this, "clusterName");
    }

    void __setclusterName(String string) {
        if (!this.__FclusterName) {
            this.clusterName = string;
            return;
        }
        this.__IM.onSet((Object)this, "clusterName", (Object)string);
    }

    String __gethelp() {
        if (!this.__Fhelp) {
            return this.help;
        }
        return (String)this.__IM.onGet((Object)this, "help");
    }

    void __sethelp(String string) {
        if (!this.__Fhelp) {
            this.help = string;
            return;
        }
        this.__IM.onSet((Object)this, "help", (Object)string);
    }

    List __getarguments() {
        if (!this.__Farguments) {
            return this.arguments;
        }
        return (List)this.__IM.onGet((Object)this, "arguments");
    }

    void __setarguments(List list) {
        if (!this.__Farguments) {
            this.arguments = list;
            return;
        }
        this.__IM.onSet((Object)this, "arguments", (Object)list);
    }

    String __getlang() {
        if (!this.__Flang) {
            return this.lang;
        }
        return (String)this.__IM.onGet((Object)this, "lang");
    }

    void __setlang(String string) {
        if (!this.__Flang) {
            this.lang = string;
            return;
        }
        this.__IM.onSet((Object)this, "lang", (Object)string);
    }

    public DeployMeCommand() {
        this(null);
    }

    private DeployMeCommand(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlang("en");
    }

    public Object execute(CommandSession commandSession) throws Exception {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__M_execute(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            object = this.__M_execute(commandSession);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_execute(CommandSession commandSession) throws Exception {
        if (this.help() != null) {
            // empty if block
        }
        CommandLine commandLine = new CommandLine();
        commandLine.addValue("topologyFile", this.__gettopologyFilePath());
        commandLine.addValue("machineName", this.__getmachineName());
        commandLine.addValue("domainName", this.__getdomainName());
        commandLine.addValue("serverName", this.__getserverName());
        commandLine.addValue("clusterName", this.__getclusterName());
        commandLine.checkCommandLine();
        if (commandLine.getVerbose()) {
            Logger.getLogger("").setLevel(Level.ALL);
        }
        URL urlXML = null;
        File topologyFile = new File(commandLine.getTopologyFile());
        if (topologyFile != null && topologyFile.exists()) {
            urlXML = topologyFile.toURI().toURL();
        }
        if (urlXML == null) {
            logger.info((Object)("The " + urlXML + " is not a local file or resource."), new Object[0]);
            logger.info((Object)"JASMINe Deploy ME will download it using Java URLConnections.", new Object[0]);
            urlXML = new URL(commandLine.getTopologyFile());
        }
        if (urlXML == null) {
            throw new IllegalStateException("Cannot find a valid URL for the topology '" + this.__gettopologyFilePath() + "'");
        }
        this.__getdeployme().deploy(urlXML, commandLine.getMachineName(), commandLine.getDomainName(), commandLine.getServerName(), commandLine.getClusterName());
        return null;
    }

    private String help() {
        String string;
        if (!this.__Mhelp) {
            return this.__M_help();
        }
        try {
            this.__IM.onEntry((Object)this, "help", new Object[0]);
            string = this.__M_help();
            this.__IM.onExit((Object)this, "help", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "help", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_help() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n");
        buffer.append("Usage : deployme:deploy -topologyFile=topology_xml (-machineName=host | -domainName=domain [-serverName=server | -clusterName=cluster]) [-verbose]");
        buffer.append("\n\n");
        buffer.append(" -topologyFile=topology_xml : ");
        buffer.append("\n\t");
        buffer.append("This file describes your server infrastructure. You have two ways to create it : ");
        buffer.append("\n\t");
        buffer.append("1. Export a topology file from JASMINe Design. This is the recommended method.");
        buffer.append("\n\t");
        buffer.append("2. Manually create your topology file. Please refer to the JASMINe Deploy ME XSD file and/or the JASMINe Deploy ME samples distribution for details.");
        buffer.append("\n\n");
        buffer.append("-machineName=host : name of a machine in the topology.xml file");
        buffer.append("\n\t");
        buffer.append("Deploy all servers on a given machine");
        buffer.append("\n\n");
        buffer.append("-domainName=domain : A domain name of the topology.xml file.");
        buffer.append("\n");
        buffer.append("-serverName=server : A server name of the topology.xml file.");
        buffer.append("\n\t");
        buffer.append("Deploy the server of the the specified domain.");
        buffer.append("\n");
        buffer.append("-clusterName=cluster : A cluster daemon name of the topology.xml file.");
        buffer.append("\n\t");
        buffer.append("Deploy the cluster daemon of the specified domain.");
        return buffer.toString();
    }

    public void setTopologyFilePath(String string) {
        if (!this.__MsetTopologyFilePath$java_lang_String) {
            this.__M_setTopologyFilePath(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setTopologyFilePath$java_lang_String", new Object[]{string});
            this.__M_setTopologyFilePath(string);
            this.__IM.onExit((Object)this, "setTopologyFilePath$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setTopologyFilePath$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setTopologyFilePath(String topologyFilePath) {
        this.__settopologyFilePath(topologyFilePath);
    }

    public void setMachineName(String string) {
        if (!this.__MsetMachineName$java_lang_String) {
            this.__M_setMachineName(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setMachineName$java_lang_String", new Object[]{string});
            this.__M_setMachineName(string);
            this.__IM.onExit((Object)this, "setMachineName$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setMachineName$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setMachineName(String machineName) {
        this.__setmachineName(machineName);
    }

    public void setDomainName(String string) {
        if (!this.__MsetDomainName$java_lang_String) {
            this.__M_setDomainName(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setDomainName$java_lang_String", new Object[]{string});
            this.__M_setDomainName(string);
            this.__IM.onExit((Object)this, "setDomainName$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setDomainName$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setDomainName(String domainName) {
        this.__setdomainName(domainName);
    }

    public void setDeploymeManager(IDeployMeService iDeployMeService) {
        if (!this.__MsetDeploymeManager$org_ow2_jasmine_deployme_api_IDeployMeService) {
            this.__M_setDeploymeManager(iDeployMeService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setDeploymeManager$org_ow2_jasmine_deployme_api_IDeployMeService", new Object[]{iDeployMeService});
            this.__M_setDeploymeManager(iDeployMeService);
            this.__IM.onExit((Object)this, "setDeploymeManager$org_ow2_jasmine_deployme_api_IDeployMeService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setDeploymeManager$org_ow2_jasmine_deployme_api_IDeployMeService", throwable);
            throw throwable;
        }
    }

    private void __M_setDeploymeManager(IDeployMeService deploymeService) {
        this.__setdeployme(deploymeService);
    }

    public void setServerName(String string) {
        if (!this.__MsetServerName$java_lang_String) {
            this.__M_setServerName(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setServerName$java_lang_String", new Object[]{string});
            this.__M_setServerName(string);
            this.__IM.onExit((Object)this, "setServerName$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setServerName$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setServerName(String serverName) {
        this.__setserverName(serverName);
    }

    public void setClusterName(String string) {
        if (!this.__MsetClusterName$java_lang_String) {
            this.__M_setClusterName(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setClusterName$java_lang_String", new Object[]{string});
            this.__M_setClusterName(string);
            this.__IM.onExit((Object)this, "setClusterName$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setClusterName$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setClusterName(String clusterName) {
        this.__setclusterName(clusterName);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("arguments")) {
                this.__Farguments = true;
            }
            if (set.contains("clusterName")) {
                this.__FclusterName = true;
            }
            if (set.contains("deployme")) {
                this.__Fdeployme = true;
            }
            if (set.contains("domainName")) {
                this.__FdomainName = true;
            }
            if (set.contains("help")) {
                this.__Fhelp = true;
            }
            if (set.contains("lang")) {
                this.__Flang = true;
            }
            if (set.contains("machineName")) {
                this.__FmachineName = true;
            }
            if (set.contains("serverName")) {
                this.__FserverName = true;
            }
            if (set.contains("topologyFilePath")) {
                this.__FtopologyFilePath = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("execute$org_apache_felix_service_command_CommandSession")) {
                this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
            }
            if (set.contains("help")) {
                this.__Mhelp = true;
            }
            if (set.contains("setTopologyFilePath$java_lang_String")) {
                this.__MsetTopologyFilePath$java_lang_String = true;
            }
            if (set.contains("setMachineName$java_lang_String")) {
                this.__MsetMachineName$java_lang_String = true;
            }
            if (set.contains("setDomainName$java_lang_String")) {
                this.__MsetDomainName$java_lang_String = true;
            }
            if (set.contains("setDeploymeManager$org_ow2_jasmine_deployme_api_IDeployMeService")) {
                this.__MsetDeploymeManager$org_ow2_jasmine_deployme_api_IDeployMeService = true;
            }
            if (set.contains("setServerName$java_lang_String")) {
                this.__MsetServerName$java_lang_String = true;
            }
            if (set.contains("setClusterName$java_lang_String")) {
                this.__MsetClusterName$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

