/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2012 Bull S.A.S.
 * Copyright (C) 2012 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AbstractDeploymeModule.java 10000 2012-05-02 14:52:40Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.deployme.module;

import org.ow2.jasmine.deployme.api.modules.IDeploymeModule;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

import java.lang.reflect.Field;
import java.util.Map;

/**
 * Abstract module class
 */
public abstract class AbstractDeploymeModule implements IDeploymeModule {

    /**
     * The logger
     */
   private static final Log logger = LogFactory.getLog(AbstractDeploymeModule.class);

    /**
     * {@inheritDoc}
     */
    public Map<Class, Field> getClassIdField() {
        return null;
    }

    /**
     * @param clazz A {@link Class}
     * @param fieldName The name of a field to retrieve
     * @return the associated {@link Field}
     */
    protected Field getField(Class clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        } catch (NoSuchFieldException e) {
            logger.error("Cannot get declared field " + fieldName + " of class " + clazz.getName(), e);
        }
        return null;
    }
}
