/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ConfigClusterApply.java 9900 2012-02-22 15:21:10Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.deployme.v1.configApply;

import org.ow2.jasmine.deployme.v1.generated.Topology.Domains.Domain;
import org.ow2.jonas.tools.configurator.Jonas;
import org.ow2.jonas.tools.configurator.api.JonasConfigurator;

/**
 * Apply a configuration on a Jonas server
 * 
 * @author Remy Bresson
 */
public class ConfigClusterApply {

    /**
     * The jonas configurator
     */
    private JonasConfigurator jonasConf;

    /**
     * Constructor
     */
    public ConfigClusterApply(final String jonasRoot) {
        Jonas jonas = new Jonas(jonasRoot);
        this.jonasConf = jonas.getJonasConfigurator();
    }

    /**
     * Apply the cluster daemon global parameters
     * 
     * @param domainName Cluster daemon domain name
     * @param cluster The cluster daemon parameters
     */
    public void setClusterConf(final String domainName, final Domain.ClusterDaemons.ClusterDaemon cluster) {
        this.jonasConf.setCDNbInstances(cluster.getServers().getServerName().size());

        // Set JONAS_ROOT first
        if (cluster.getJonasRoot() != null) {
            this.jonasConf.setCDJonasRoot(cluster.getJonasRoot());
        }

        if (cluster.getName() != null) {
            this.jonasConf.setCDClusterName(cluster.getName());
        }
        this.jonasConf.setCDClusterDomain(domainName);
        if (cluster.getClusterDaemonProtocol() != null) {
            this.jonasConf.setCDProtocol(cluster.getClusterDaemonProtocol());
        }
        if (cluster.getClusterDaemonPort() != null) {
            this.jonasConf.setCDPort(cluster.getClusterDaemonPort().toString());
        }
        if (cluster.getJonasBasePrefix() != null) {
            this.jonasConf.setCDDestDirPrefix(cluster.getJonasBasePrefix());
        }
        if (cluster.getInteractionMode() != null) {
            this.jonasConf.setCDInteractionMode(cluster.getInteractionMode().value());
        }
        if (cluster.getJavaHome() != null) {
            this.jonasConf.setCDJavaHome(cluster.getJavaHome());
        }
        if (cluster.getServerNamePrefix() != null) {
            this.jonasConf.setCDServerNamePrefix(cluster.getServerNamePrefix());
        }
        if (cluster.getXparam() != null) {
            this.jonasConf.setCDXparam(cluster.getXparam());
        }

        this.jonasConf.setCDAutoBoot(cluster.isAutoboot());
    }

    /**
     * Apply the configuration
     */
    public void execute() {
        this.jonasConf.executeCDConf();
    }
}
