/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2012 Bull S.A.S.
 * Copyright (C) 2012 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ConfigJonasApply.java 10000 2012-05-02 14:52:40Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.deployme.v2.configApply;

import org.ow2.jasmine.deployme.api.extensions.IDeploymeExtension;
import org.ow2.jasmine.deployme.api.modules.IDeploymeModule;
import org.ow2.jasmine.deployme.api.modules.UnsupportDeploymeModuleException;
import org.ow2.jonas.tools.configurator.Jonas;
import org.ow2.jonas.tools.configurator.api.JonasConfigurator;
import org.ow2.jasmine.deployme.v2.generated.AgentType;
import org.ow2.jasmine.deployme.v2.generated.SimpleContentWithInheritAttribute;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

import java.util.Map;

/**
 * Apply a Deployme 2 configuration on the JOnAS server
 * @author Jeremy Cazaux
 */
public class ConfigJonasApply {

    /**
     * The logger
     */
    private static final Log logger = LogFactory.getLog(ConfigJonasApply.class);

    /**
     * The jonas configurator
     */
    private JonasConfigurator jonasConf;

    /**
     * Cluster mode
     */
    private Boolean clusterMode = false;

    /**
     * Constructor
     */
    public ConfigJonasApply(final String jonasRoot) {
        Jonas jonas = new Jonas(jonasRoot);
        this.jonasConf = jonas.getJonasConfigurator();
    }

    /**
     * Apply the cluster daemon parameters
     *
     * @param domainName Agent domain name
     * @param agent The Agent to configure
     */
    public void setClusterConfiguration(final String domainName, final AgentType agent) {
        this.jonasConf.setCDNbInstances(agent.getManagedServers().getServerName().size());
        final String agentName = agent.getName();
        if (agentName != null) {
            this.jonasConf.setCDClusterName(agentName);
        }
        this.jonasConf.setCDClusterDomain(domainName);

        final String jonasBase = agent.getJonasBase().getValue();
        if (jonasBase != null) {
            this.jonasConf.setCDDestDirPrefix(jonasBase);
        }
        final String interactionMode = agent.getInteractionMode();
        if (interactionMode != null) {
            this.jonasConf.setCDInteractionMode(interactionMode);
        }
        final String javaHome = agent.getJavaHome();
        if (javaHome != null) {
            this.jonasConf.setCDJavaHome(javaHome);
        }
        final String serverNamePrefix = agent.getServerNamePrefix();
        if (serverNamePrefix != null) {
            this.jonasConf.setCDServerNamePrefix(serverNamePrefix);
        }
        final String xparam = agent.getXparam();
        if (xparam != null) {
            this.jonasConf.setCDXparam(xparam);
        }
        this.jonasConf.setCDAutoBoot(agent.isAutoboot());

        SimpleContentWithInheritAttribute jonasScript = agent.getJonasScript();
        if (jonasScript != null) {
            final String jonasScriptPath = jonasScript.getValue();
            if (jonasScriptPath != null) {
                this.jonasConf.setCDJOnASScript(jonasScriptPath);
            }
        }

        this.clusterMode = true;
    }

    //TODO properties

    //TODO jvm properties

    //TODO deployables

    //TODO JONAS_ROOT

    /**
     * Apply extensions configuration
     * @param extensions Map of pair <extension, topology object>
     */
    public void applyExtensionConfiguration(final Map<IDeploymeExtension, Object> extensions) {
        if (extensions != null) {
            for (Map.Entry<IDeploymeExtension, Object> extension: extensions.entrySet()) {
                if (extension != null) {
                    IDeploymeExtension deploymeExtension = extension.getKey();
                    Object topologyObject = extension.getValue();
                    if (deploymeExtension != null && topologyObject != null) {
                        deploymeExtension.applyConfiguration(this.jonasConf, topologyObject);
                    }
                }
            }
        }
    }

    /**
     * Apply module configuration
     * @param modules  Map of pair <module, topology object>
     */
    public void applyModuleConfiguration(final Map<IDeploymeModule, Object> modules) {
        if (modules != null) {
            for (Map.Entry<IDeploymeModule, Object> module: modules.entrySet()) {
                if (module != null) {
                    IDeploymeModule deploymeModule = module.getKey();
                    Object topologyObject = module.getValue();
                    if (deploymeModule != null && topologyObject != null) {
                        try {
                            deploymeModule.applyConfiguration(this.jonasConf, topologyObject);
                        } catch (UnsupportDeploymeModuleException e) {
                            logger.error("Cannot apply configuration of topology object " + topologyObject.getClass().getName(), e);
                        }
                    }
                }
            }
        }
    }

    /**
     * Set the JOnAS Base of a JOnAS instance
     * @param jonasBase
     * @param update
     */
    public void setJOnASBase(final String jonasBase, final boolean update) {
        if (jonasBase != null) {
            this.jonasConf.setJonasBase(jonasBase);
        }
        if (jonasBase != null) {
            this.jonasConf.isJOnASBaseToUpdate(update);
        }
    }

    /**
     * @param serverName The name of the server to set
     */
    public void setJOnASName(final String serverName) {
        if (serverName != null) {
            this.jonasConf.setJonasName(serverName);
        }
    }

    /**
     * @param domainName The name of the domain to set
     */
    public void setDomainName(final String domainName) {
        if (domainName != null) {
            this.jonasConf.setJonasDomain(domainName);
        }
    }

    /**
     * @param services List of services to set
     */
    public void setServices(final String services) {
        if (services != null) {
            this.jonasConf.setServices(services);
        }
    }

    /**
     * Apply the configuration
     */
    public void execute() {
        this.jonasConf.execute();
        if (this.clusterMode) {
            this.jonasConf.executeCDConf();
        }
    }


}
