/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2012 Bull S.A.S.
 * Copyright (C) 2012 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Agent.java 10010 2012-05-04 12:03:59Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.deployme.v2.util;

import org.ow2.jasmine.deployme.api.extensions.IDeploymeExtension;
import org.ow2.jasmine.deployme.api.modules.IDeploymeModule;
import org.ow2.jasmine.deployme.v2.generated.AgentType;
import org.ow2.jasmine.deployme.v2.generated.DomainType;
import org.ow2.jasmine.deployme.v2.generated.DomainsType;
import org.ow2.jasmine.deployme.v2.generated.ConfigurationType;
import org.ow2.jasmine.deployme.v2.generated.JOnASBaseType;
import org.ow2.jasmine.deployme.v2.generated.SimpleContentWithInheritAttribute;

import java.util.List;

/**
 * Represents an agent. An agent is a server with the capability to manage others servers
 * @author Jeremy Cazaux
 */
public class Agent extends AbstractServer {

    /**
     * The server
     */
    private AgentType agent;

    /**
     * JOnAS script global to all domains
     */
    protected SimpleContentWithInheritAttribute domainsJonasScript;

    /**
     * JOnAS script of the domain
     */
    protected SimpleContentWithInheritAttribute domainJonasScript;

    /**
     * Default constructor
     * @param agent The agent
     * @param domain The domain of the agent
     * @param domains Domains of the agent
     */
    public Agent(final AgentType agent, final DomainType domain, final DomainsType domains, final Boolean merge,
                 final List<IDeploymeExtension> availableExtensions,final List<IDeploymeModule> availableModules) {

        super();
        this.availableExtensions = availableExtensions;
        this.availableModules = availableModules;

        if (domain != null) {
            this.domainConfiguration = domain.getAgentsConfiguration();
            this.serversConfiguration = domain.getAgents().getAgentsConfiguration();
            this.domainJonasScript = domain.getJonasScript();
            this.serversProperties = domain.getAgents().getProperties();
            this.domainProperties = domain.getProperties();
        }
        if (domains != null) {
            this.domainsConfiguration = domains.getAgentsConfiguration();
            this.domainsJonasScript = domains.getJonasScript();
            this.domainsProperties = domains.getProperties();
        }
        this.agent = agent;
        this.serversProperties = agent.getProperties();

        this.domainName = domain.getName();
        this.serverName = agent.getName();

        buildModulesAndExtensions(agent.getConfiguration());

        if (merge != null && merge) {
            merge();
        }

        initProperties();

        JOnASBaseType jonasBase = agent.getJonasBase();
        setJonasRoot(agent.getJonasRoot());
        setJonasBase(jonasBase.getValue());
        this.updateJonasBase = jonasBase.isUpdate();

        substituteProperties();
    }

    /**
     * {@inheritDoc}
     */
    protected void merge() {
        super.merge();
        mergeJonasScript();
    }

    /**
     * Merge the optional JOnAS script
     */
    protected void mergeJonasScript() {
        SimpleContentWithInheritAttribute jonasScript = this.agent.getJonasScript();
        Boolean inherit = true;
        if (jonasScript != null && jonasScript.isInherit() != null) {
            inherit = jonasScript.isInherit();
        }
        if (jonasScript == null || jonasScript.getValue() == null) {
            if (inherit && this.domainJonasScript != null) {
                if (this.domainJonasScript.isInherit() != null) {
                    inherit = this.domainJonasScript.isInherit();
                }
                if (jonasScript == null) {
                    jonasScript = this.domainJonasScript;
                } else {
                    jonasScript.setValue(this.domainJonasScript.getValue());
                }
            }
            if (inherit && this.domainsJonasScript != null) {
                if (jonasScript == null) {
                    jonasScript = this.domainsJonasScript;
                } else {
                    jonasScript.setValue(this.domainsJonasScript.getValue());
                }
            }
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected ConfigurationType getServerConfiguration() {
        return this.agent.getConfiguration();
    }

    /**
     * @return the {@link AgentType}
     */
    public AgentType getAgent() {
        return this.agent;
    }
}
