/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2012 Bull S.A.S.
 * Copyright (C) 2012 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Server.java 10006 2012-05-02 22:39:39Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.deployme.v2.util;

import org.ow2.jasmine.deployme.api.extensions.IDeploymeExtension;
import org.ow2.jasmine.deployme.api.modules.IDeploymeModule;
import org.ow2.jasmine.deployme.v2.generated.ConfigurationType;
import org.ow2.jasmine.deployme.v2.generated.PropertiesType;
import org.ow2.jasmine.deployme.v2.generated.PropertyType;
import org.ow2.jasmine.deployme.v2.generated.ServerType;
import org.ow2.jasmine.deployme.v2.generated.DomainType; 
import org.ow2.jasmine.deployme.v2.generated.DomainsType;
import org.ow2.jasmine.deployme.v2.generated.JOnASBaseType;
import org.ow2.jasmine.deployme.v2.generated.ServersType;

import java.util.List;

/**
 * Represent a server.
 * @author Jeremy Cazaux
 */
public class Server extends AbstractServer {

    /**
     * The server
     */
    private ServerType server;

    /**
     * Defaimt constructor
     * @param server The server
     * @param domain The domain of the server
     * @param domains Domains configuration
     */
    public Server(final ServerType server, final DomainType domain, final DomainsType domains, final Boolean merge,
                  final List<IDeploymeExtension> availableExtensions,final List<IDeploymeModule> availableModules) {
        super();
        this.availableExtensions = availableExtensions;
        this.availableModules = availableModules;

        if (domain != null) {
            this.domainConfiguration = domain.getServersConfiguration();
            this.domainProperties = domain.getProperties();
            ServersType servers = domain.getServers();
            if (servers != null) {
                this.serversConfiguration = servers.getServersConfiguration();
                this.serversProperties = servers.getProperties();
            }            
        }
        if (domains != null) {
            this.domainsConfiguration = domains.getServersConfiguration();
            this.domainsProperties = domains.getProperties();
        }
        this.serverProperties = server.getProperties();
        this.server = server;

        this.domainName = domain.getName();
        this.serverName = server.getName();

        buildModulesAndExtensions(server.getConfiguration());

        if (merge != null && merge) {
            merge();
        }

        initProperties();

        JOnASBaseType jonasBase = server.getJonasBase();
        setJonasRoot(server.getJonasRoot());
        setJonasBase(jonasBase.getValue());
        this.updateJonasBase = jonasBase.isUpdate();

        substituteProperties();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected ConfigurationType getServerConfiguration() {
        return this.server.getConfiguration();
    }

    /**
     * @return the {@link ServerType}
     */
    public ServerType getServer() {
        return this.server;
    }
}
