/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jasmine.deployme.api.DeployMEPropertiesManager;
import org.ow2.jasmine.deployme.api.DeploymeVersion;
import org.ow2.jasmine.deployme.api.IDeployMeService;
import org.ow2.jasmine.deployme.api.IDeployme;
import org.ow2.jasmine.deployme.api.IServer;
import org.ow2.jasmine.deployme.api.XmlLoader;
import org.ow2.jasmine.deployme.api.extensions.IDeploymeExtension;
import org.ow2.jasmine.deployme.api.modules.IDeploymeModule;
import org.ow2.jasmine.deployme.v1.DeploymeV1;
import org.ow2.jasmine.deployme.v1.generated.Topology;
import org.ow2.jasmine.deployme.v2.DeploymeV2;
import org.ow2.jasmine.deployme.v2.generated.TopologyType;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DeployMeService
implements IDeployMeService,
Pojo {
    private InstanceManager __IM;
    private boolean __Ftopology;
    protected Object topology;
    private boolean __Fnamespaces;
    protected Map<String, Node> namespaces;
    protected static Log logger = LogFactory.getLog(DeployMeService.class);
    public static final Pattern XMLNS_PATTERN = Pattern.compile("xmlns.*");
    private boolean __FdeploymeVersion;
    private DeploymeVersion deploymeVersion;
    private boolean __Fdeployme;
    private IDeployme deployme;
    private boolean __FavailableExtensions;
    private List<IDeploymeExtension> availableExtensions;
    private boolean __FavailableModules;
    private List<IDeploymeModule> availableModules;
    private boolean __MgetTopology;
    private boolean __Mdeploy$java_net_URL$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __Mdeploy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __Minit$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MinitDeployme;
    private boolean __MgetDeployme;
    private boolean __MloadTopology$java_net_URL;
    private boolean __MloadTopology$java_lang_String;
    private boolean __MinitDeploymeVersion$java_net_URL;
    private boolean __MinitDeploymeVersion$java_lang_String;
    private boolean __MinitDeploymeVersion$java_io_File;
    private boolean __MinitDeploymeVersion$org_w3c_dom_Document;
    private boolean __MgetNamespace$org_w3c_dom_Node;
    private boolean __MbindDeploymeExtension$org_ow2_jasmine_deployme_api_extensions_IDeploymeExtension;
    private boolean __MunbindDeploymeExtension$org_ow2_jasmine_deployme_api_extensions_IDeploymeExtension;
    private boolean __MbindDeploymeModule$org_ow2_jasmine_deployme_api_modules_IDeploymeModule;
    private boolean __MunbindDeploymeModule$org_ow2_jasmine_deployme_api_modules_IDeploymeModule;
    private boolean __MgetInstance;
    private boolean __MgetServer$java_lang_String$java_lang_String;

    Object __gettopology() {
        if (!this.__Ftopology) {
            return this.topology;
        }
        return this.__IM.onGet((Object)this, "topology");
    }

    void __settopology(Object object) {
        if (!this.__Ftopology) {
            this.topology = object;
            return;
        }
        this.__IM.onSet((Object)this, "topology", object);
    }

    Map __getnamespaces() {
        if (!this.__Fnamespaces) {
            return this.namespaces;
        }
        return (Map)this.__IM.onGet((Object)this, "namespaces");
    }

    void __setnamespaces(Map map) {
        if (!this.__Fnamespaces) {
            this.namespaces = map;
            return;
        }
        this.__IM.onSet((Object)this, "namespaces", (Object)map);
    }

    DeploymeVersion __getdeploymeVersion() {
        if (!this.__FdeploymeVersion) {
            return this.deploymeVersion;
        }
        return (DeploymeVersion)this.__IM.onGet((Object)this, "deploymeVersion");
    }

    void __setdeploymeVersion(DeploymeVersion deploymeVersion) {
        if (!this.__FdeploymeVersion) {
            this.deploymeVersion = deploymeVersion;
            return;
        }
        this.__IM.onSet((Object)this, "deploymeVersion", (Object)deploymeVersion);
    }

    IDeployme __getdeployme() {
        if (!this.__Fdeployme) {
            return this.deployme;
        }
        return (IDeployme)this.__IM.onGet((Object)this, "deployme");
    }

    void __setdeployme(IDeployme iDeployme) {
        if (!this.__Fdeployme) {
            this.deployme = iDeployme;
            return;
        }
        this.__IM.onSet((Object)this, "deployme", (Object)iDeployme);
    }

    List __getavailableExtensions() {
        if (!this.__FavailableExtensions) {
            return this.availableExtensions;
        }
        return (List)this.__IM.onGet((Object)this, "availableExtensions");
    }

    void __setavailableExtensions(List list) {
        if (!this.__FavailableExtensions) {
            this.availableExtensions = list;
            return;
        }
        this.__IM.onSet((Object)this, "availableExtensions", (Object)list);
    }

    List __getavailableModules() {
        if (!this.__FavailableModules) {
            return this.availableModules;
        }
        return (List)this.__IM.onGet((Object)this, "availableModules");
    }

    void __setavailableModules(List list) {
        if (!this.__FavailableModules) {
            this.availableModules = list;
            return;
        }
        this.__IM.onSet((Object)this, "availableModules", (Object)list);
    }

    @Deprecated
    public Object getTopology() {
        Object object;
        if (!this.__MgetTopology) {
            return this.__M_getTopology();
        }
        try {
            this.__IM.onEntry((Object)this, "getTopology", new Object[0]);
            object = this.__M_getTopology();
            this.__IM.onExit((Object)this, "getTopology", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTopology", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_getTopology() {
        return this.__gettopology();
    }

    public DeployMeService() {
        this(null);
    }

    private DeployMeService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setnamespaces(new LinkedHashMap());
        this.__setavailableExtensions(new ArrayList());
        this.__setavailableModules(new ArrayList());
    }

    public void deploy(URL uRL, String string, String string2, String string3, String string4) throws SAXException, JAXBException, IOException {
        if (!this.__Mdeploy$java_net_URL$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__M_deploy(uRL, string, string2, string3, string4);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deploy$java_net_URL$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{uRL, string, string2, string3, string4});
            this.__M_deploy(uRL, string, string2, string3, string4);
            this.__IM.onExit((Object)this, "deploy$java_net_URL$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deploy$java_net_URL$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_deploy(URL topologyUrl, String machine, String domain, String server, String cluster) throws SAXException, JAXBException, IOException {
        this.loadTopology(topologyUrl);
        this.init(machine, domain, server, cluster);
    }

    public void deploy(String string, String string2, String string3, String string4, String string5) throws IOException, SAXException, JAXBException {
        if (!this.__Mdeploy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__M_deploy(string, string2, string3, string4, string5);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deploy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3, string4, string5});
            this.__M_deploy(string, string2, string3, string4, string5);
            this.__IM.onExit((Object)this, "deploy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deploy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_deploy(String topologyXml, String machine, String domain, String server, String cluster) throws IOException, SAXException, JAXBException {
        this.loadTopology(topologyXml);
        this.init(machine, domain, server, cluster);
    }

    private void init(String string, String string2, String string3, String string4) {
        if (!this.__Minit$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__M_init(string, string2, string3, string4);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "init$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3, string4});
            this.__M_init(string, string2, string3, string4);
            this.__IM.onExit((Object)this, "init$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "init$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_init(String machine, String domain, String server, String cluster) {
        this.initDeployme();
        this.__getdeployme().applyConfiguration(machine, domain, server, cluster);
    }

    public void initDeployme() {
        if (!this.__MinitDeployme) {
            this.__M_initDeployme();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initDeployme", new Object[0]);
            this.__M_initDeployme();
            this.__IM.onExit((Object)this, "initDeployme", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initDeployme", throwable);
            throw throwable;
        }
    }

    private void __M_initDeployme() {
        if (DeploymeVersion.DEPLOYME_2.equals((Object)this.__getdeploymeVersion())) {
            this.__setdeployme(new DeploymeV2((TopologyType)this.__gettopology(), this.__getavailableExtensions(), this.__getavailableModules()));
        } else {
            this.__setdeployme(new DeploymeV1((Topology)this.__gettopology()));
        }
    }

    public IDeployme getDeployme() {
        IDeployme iDeployme;
        if (!this.__MgetDeployme) {
            return this.__M_getDeployme();
        }
        try {
            this.__IM.onEntry((Object)this, "getDeployme", new Object[0]);
            iDeployme = this.__M_getDeployme();
            this.__IM.onExit((Object)this, "getDeployme", (Object)iDeployme);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDeployme", throwable);
            throw throwable;
        }
        return iDeployme;
    }

    private IDeployme __M_getDeployme() {
        return this.__getdeployme();
    }

    public void loadTopology(URL uRL) throws SAXException, JAXBException, IOException {
        if (!this.__MloadTopology$java_net_URL) {
            this.__M_loadTopology(uRL);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "loadTopology$java_net_URL", new Object[]{uRL});
            this.__M_loadTopology(uRL);
            this.__IM.onExit((Object)this, "loadTopology$java_net_URL", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "loadTopology$java_net_URL", throwable);
            throw throwable;
        }
    }

    private void __M_loadTopology(URL urlTopology) throws SAXException, JAXBException, IOException {
        this.initDeploymeVersion(urlTopology);
        XmlLoader xmlLoader = new XmlLoader(urlTopology, this.__getdeploymeVersion());
        this.__settopology(xmlLoader.getTopology());
    }

    public void loadTopology(String string) throws SAXException, JAXBException, IOException {
        if (!this.__MloadTopology$java_lang_String) {
            this.__M_loadTopology(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "loadTopology$java_lang_String", new Object[]{string});
            this.__M_loadTopology(string);
            this.__IM.onExit((Object)this, "loadTopology$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "loadTopology$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_loadTopology(String topology) throws SAXException, JAXBException, IOException {
        this.initDeploymeVersion(topology);
        XmlLoader xmlLoader = new XmlLoader(topology, this.__getdeploymeVersion());
        this.__settopology(xmlLoader.getTopology());
    }

    private void initDeploymeVersion(URL uRL) {
        if (!this.__MinitDeploymeVersion$java_net_URL) {
            this.__M_initDeploymeVersion(uRL);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initDeploymeVersion$java_net_URL", new Object[]{uRL});
            this.__M_initDeploymeVersion(uRL);
            this.__IM.onExit((Object)this, "initDeploymeVersion$java_net_URL", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initDeploymeVersion$java_net_URL", throwable);
            throw throwable;
        }
    }

    private void __M_initDeploymeVersion(URL topologyURL) {
        try {
            this.initDeploymeVersion(new File(topologyURL.toURI()));
        }
        catch (URISyntaxException e) {
            logger.error((Object)("Cannot get the URI of the URL " + topologyURL.getFile()), new Object[]{e});
        }
    }

    private void initDeploymeVersion(String string) {
        if (!this.__MinitDeploymeVersion$java_lang_String) {
            this.__M_initDeploymeVersion(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initDeploymeVersion$java_lang_String", new Object[]{string});
            this.__M_initDeploymeVersion(string);
            this.__IM.onExit((Object)this, "initDeploymeVersion$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initDeploymeVersion$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_initDeploymeVersion(String topology) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        Document document = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)"Cannot get the instance of the DocumentBuilder", new Object[]{e});
        }
        if (documentBuilder != null) {
            try {
                document = documentBuilder.parse(new InputSource(new StringReader(topology.trim())));
            }
            catch (SAXException e) {
                logger.error((Object)("Cannot parse XML content of " + topology), new Object[]{e});
            }
            catch (IOException e) {
                logger.error((Object)("Cannot parse XML content of " + topology), new Object[]{e});
            }
        }
        this.initDeploymeVersion(document);
    }

    private void initDeploymeVersion(File file) {
        if (!this.__MinitDeploymeVersion$java_io_File) {
            this.__M_initDeploymeVersion(file);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initDeploymeVersion$java_io_File", new Object[]{file});
            this.__M_initDeploymeVersion(file);
            this.__IM.onExit((Object)this, "initDeploymeVersion$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initDeploymeVersion$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __M_initDeploymeVersion(File topologyFile) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        Document document = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)"Cannot get the instance of the DocumentBuilder", new Object[]{e});
        }
        if (documentBuilder != null) {
            try {
                document = documentBuilder.parse(topologyFile);
            }
            catch (SAXException e) {
                logger.error((Object)("Cannot parse XML file " + topologyFile.getAbsolutePath()), new Object[]{e});
            }
            catch (IOException e) {
                logger.error((Object)("Cannot parse XML file " + topologyFile.getAbsolutePath()), new Object[]{e});
            }
        }
        this.initDeploymeVersion(document);
    }

    private void initDeploymeVersion(Document document) {
        if (!this.__MinitDeploymeVersion$org_w3c_dom_Document) {
            this.__M_initDeploymeVersion(document);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initDeploymeVersion$org_w3c_dom_Document", new Object[]{document});
            this.__M_initDeploymeVersion(document);
            this.__IM.onExit((Object)this, "initDeploymeVersion$org_w3c_dom_Document", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initDeploymeVersion$org_w3c_dom_Document", throwable);
            throw throwable;
        }
    }

    private void __M_initDeploymeVersion(Document document) {
        if (document != null) {
            this.getNamespace(document);
        }
        this.__setdeploymeVersion(DeployMEPropertiesManager.getDeploymeVersion(new ArrayList(this.__getnamespaces().keySet())));
    }

    private void getNamespace(Node node) {
        if (!this.__MgetNamespace$org_w3c_dom_Node) {
            this.__M_getNamespace(node);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "getNamespace$org_w3c_dom_Node", new Object[]{node});
            this.__M_getNamespace(node);
            this.__IM.onExit((Object)this, "getNamespace$org_w3c_dom_Node", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getNamespace$org_w3c_dom_Node", throwable);
            throw throwable;
        }
    }

    private void __M_getNamespace(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeType() != 1) continue;
            Element element = (Element)child;
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int y = 0; y < namedNodeMap.getLength(); ++y) {
                Attr attribute = (Attr)Attr.class.cast(namedNodeMap.item(y));
                if (!XMLNS_PATTERN.matcher(attribute.getName()).matches()) continue;
                String namespace = attribute.getValue();
                if (namespace != null && !namespace.isEmpty()) {
                    this.__getnamespaces().put(namespace, child);
                }
                this.getNamespace(child);
            }
        }
    }

    public void bindDeploymeExtension(IDeploymeExtension iDeploymeExtension) {
        if (!this.__MbindDeploymeExtension$org_ow2_jasmine_deployme_api_extensions_IDeploymeExtension) {
            this.__M_bindDeploymeExtension(iDeploymeExtension);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindDeploymeExtension$org_ow2_jasmine_deployme_api_extensions_IDeploymeExtension", new Object[]{iDeploymeExtension});
            this.__M_bindDeploymeExtension(iDeploymeExtension);
            this.__IM.onExit((Object)this, "bindDeploymeExtension$org_ow2_jasmine_deployme_api_extensions_IDeploymeExtension", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindDeploymeExtension$org_ow2_jasmine_deployme_api_extensions_IDeploymeExtension", throwable);
            throw throwable;
        }
    }

    private void __M_bindDeploymeExtension(IDeploymeExtension deploymeExtension) {
        this.__getavailableExtensions().add(deploymeExtension);
    }

    public void unbindDeploymeExtension(IDeploymeExtension iDeploymeExtension) {
        if (!this.__MunbindDeploymeExtension$org_ow2_jasmine_deployme_api_extensions_IDeploymeExtension) {
            this.__M_unbindDeploymeExtension(iDeploymeExtension);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindDeploymeExtension$org_ow2_jasmine_deployme_api_extensions_IDeploymeExtension", new Object[]{iDeploymeExtension});
            this.__M_unbindDeploymeExtension(iDeploymeExtension);
            this.__IM.onExit((Object)this, "unbindDeploymeExtension$org_ow2_jasmine_deployme_api_extensions_IDeploymeExtension", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindDeploymeExtension$org_ow2_jasmine_deployme_api_extensions_IDeploymeExtension", throwable);
            throw throwable;
        }
    }

    private void __M_unbindDeploymeExtension(IDeploymeExtension deploymeExtension) {
        this.__getavailableExtensions().remove(deploymeExtension);
    }

    public void bindDeploymeModule(IDeploymeModule iDeploymeModule) {
        if (!this.__MbindDeploymeModule$org_ow2_jasmine_deployme_api_modules_IDeploymeModule) {
            this.__M_bindDeploymeModule(iDeploymeModule);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindDeploymeModule$org_ow2_jasmine_deployme_api_modules_IDeploymeModule", new Object[]{iDeploymeModule});
            this.__M_bindDeploymeModule(iDeploymeModule);
            this.__IM.onExit((Object)this, "bindDeploymeModule$org_ow2_jasmine_deployme_api_modules_IDeploymeModule", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindDeploymeModule$org_ow2_jasmine_deployme_api_modules_IDeploymeModule", throwable);
            throw throwable;
        }
    }

    private void __M_bindDeploymeModule(IDeploymeModule deploymeModule) {
        this.__getavailableModules().add(deploymeModule);
    }

    public void unbindDeploymeModule(IDeploymeModule iDeploymeModule) {
        if (!this.__MunbindDeploymeModule$org_ow2_jasmine_deployme_api_modules_IDeploymeModule) {
            this.__M_unbindDeploymeModule(iDeploymeModule);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindDeploymeModule$org_ow2_jasmine_deployme_api_modules_IDeploymeModule", new Object[]{iDeploymeModule});
            this.__M_unbindDeploymeModule(iDeploymeModule);
            this.__IM.onExit((Object)this, "unbindDeploymeModule$org_ow2_jasmine_deployme_api_modules_IDeploymeModule", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindDeploymeModule$org_ow2_jasmine_deployme_api_modules_IDeploymeModule", throwable);
            throw throwable;
        }
    }

    private void __M_unbindDeploymeModule(IDeploymeModule deploymeModule) {
        this.__getavailableModules().remove(deploymeModule);
    }

    public IDeployme getInstance() {
        IDeployme iDeployme;
        if (!this.__MgetInstance) {
            return this.__M_getInstance();
        }
        try {
            this.__IM.onEntry((Object)this, "getInstance", new Object[0]);
            iDeployme = this.__M_getInstance();
            this.__IM.onExit((Object)this, "getInstance", (Object)iDeployme);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getInstance", throwable);
            throw throwable;
        }
        return iDeployme;
    }

    private IDeployme __M_getInstance() {
        return this.getDeployme();
    }

    public IServer getServer(String string, String string2) {
        IServer iServer;
        if (!this.__MgetServer$java_lang_String$java_lang_String) {
            return this.__M_getServer(string, string2);
        }
        try {
            this.__IM.onEntry((Object)this, "getServer$java_lang_String$java_lang_String", new Object[]{string, string2});
            iServer = this.__M_getServer(string, string2);
            this.__IM.onExit((Object)this, "getServer$java_lang_String$java_lang_String", (Object)iServer);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServer$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return iServer;
    }

    private IServer __M_getServer(String domainName, String serverName) {
        if (this.__getdeployme() != null && this.__getdeployme() instanceof DeploymeV2) {
            DeploymeV2 deploymeV2 = (DeploymeV2)this.__getdeployme();
            return deploymeV2.getServer(domainName, serverName);
        }
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("availableExtensions")) {
                this.__FavailableExtensions = true;
            }
            if (set.contains("availableModules")) {
                this.__FavailableModules = true;
            }
            if (set.contains("deployme")) {
                this.__Fdeployme = true;
            }
            if (set.contains("deploymeVersion")) {
                this.__FdeploymeVersion = true;
            }
            if (set.contains("namespaces")) {
                this.__Fnamespaces = true;
            }
            if (set.contains("topology")) {
                this.__Ftopology = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getTopology")) {
                this.__MgetTopology = true;
            }
            if (set.contains("deploy$java_net_URL$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__Mdeploy$java_net_URL$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("deploy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__Mdeploy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("init$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__Minit$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("initDeployme")) {
                this.__MinitDeployme = true;
            }
            if (set.contains("getDeployme")) {
                this.__MgetDeployme = true;
            }
            if (set.contains("loadTopology$java_net_URL")) {
                this.__MloadTopology$java_net_URL = true;
            }
            if (set.contains("loadTopology$java_lang_String")) {
                this.__MloadTopology$java_lang_String = true;
            }
            if (set.contains("initDeploymeVersion$java_net_URL")) {
                this.__MinitDeploymeVersion$java_net_URL = true;
            }
            if (set.contains("initDeploymeVersion$java_lang_String")) {
                this.__MinitDeploymeVersion$java_lang_String = true;
            }
            if (set.contains("initDeploymeVersion$java_io_File")) {
                this.__MinitDeploymeVersion$java_io_File = true;
            }
            if (set.contains("initDeploymeVersion$org_w3c_dom_Document")) {
                this.__MinitDeploymeVersion$org_w3c_dom_Document = true;
            }
            if (set.contains("getNamespace$org_w3c_dom_Node")) {
                this.__MgetNamespace$org_w3c_dom_Node = true;
            }
            if (set.contains("bindDeploymeExtension$org_ow2_jasmine_deployme_api_extensions_IDeploymeExtension")) {
                this.__MbindDeploymeExtension$org_ow2_jasmine_deployme_api_extensions_IDeploymeExtension = true;
            }
            if (set.contains("unbindDeploymeExtension$org_ow2_jasmine_deployme_api_extensions_IDeploymeExtension")) {
                this.__MunbindDeploymeExtension$org_ow2_jasmine_deployme_api_extensions_IDeploymeExtension = true;
            }
            if (set.contains("bindDeploymeModule$org_ow2_jasmine_deployme_api_modules_IDeploymeModule")) {
                this.__MbindDeploymeModule$org_ow2_jasmine_deployme_api_modules_IDeploymeModule = true;
            }
            if (set.contains("unbindDeploymeModule$org_ow2_jasmine_deployme_api_modules_IDeploymeModule")) {
                this.__MunbindDeploymeModule$org_ow2_jasmine_deployme_api_modules_IDeploymeModule = true;
            }
            if (set.contains("getInstance")) {
                this.__MgetInstance = true;
            }
            if (set.contains("getServer$java_lang_String$java_lang_String")) {
                this.__MgetServer$java_lang_String$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

