/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme.extension;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ow2.jasmine.deployme.api.DeployMEPropertiesManager;
import org.ow2.jasmine.deployme.api.DeploymeVersion;
import org.ow2.jasmine.deployme.api.extensions.DeploymeExtensionException;
import org.ow2.jasmine.deployme.api.extensions.IDeploymeExtension;
import org.ow2.jasmine.deployme.v2.generated.TopologyType;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeploymeExtension
implements IDeploymeExtension {
    public static final String EOL = "\n";
    protected List<URL> xsdUrls = new ArrayList<URL>();
    protected Class rootClass = TopologyType.class;

    protected AbstractDeploymeExtension() {
    }

    protected List<Source> getXsdSources(List<String> resources) throws DeploymeExtensionException {
        List<URL> urls = this.getXsdURL(resources);
        ArrayList<Source> sources = new ArrayList<Source>();
        for (URL url : urls) {
            sources.add(this.getSource(url));
        }
        return sources;
    }

    protected List<URL> getXsdURL(List<String> resources) throws DeploymeExtensionException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String resource : resources) {
            URL url = this.getXsdURL(resource);
            if (url == null) continue;
            urls.add(url);
        }
        return urls;
    }

    protected URL getXsdURL(String resource) throws DeploymeExtensionException {
        return this.getXsdURL(resource, this.getClass());
    }

    protected URL getXsdURL(String resource, Class clazz) throws DeploymeExtensionException {
        URL url = clazz.getClassLoader().getResource(resource);
        if (url == null && (url = clazz.getResource(resource)) == null) {
            throw new DeploymeExtensionException("Cannot get the URL of the resource " + resource + EOL);
        }
        return url;
    }

    protected Source getSource(URL url) throws DeploymeExtensionException {
        if (url != null) {
            InputStream inputStream = null;
            try {
                inputStream = url.openStream();
            }
            catch (IOException e) {
                throw new DeploymeExtensionException("Cannot get the inpustream of the URL " + url.getPath() + EOL);
            }
            try {
                return new StreamSource(inputStream);
            }
            catch (Exception e) {
                throw new DeploymeExtensionException("Cannot create a new StreamSource for the URL : " + url.getPath() + EOL, (Throwable)e);
            }
        }
        return null;
    }

    protected List<Source> getSources(List<URL> urls) throws DeploymeExtensionException {
        ArrayList<Source> sources = new ArrayList<Source>();
        for (URL url : urls) {
            Source source = this.getSource(url);
            if (source == null) continue;
            sources.add(source);
        }
        return sources;
    }

    protected Object unmarshall(Node node, Class<?> rootClass, List<Source> xsdSources, ClassLoader classLoader) throws DeploymeExtensionException {
        JAXBContext jaxbContext = null;
        try {
            jaxbContext = JAXBContext.newInstance((String)rootClass.getPackage().getName(), (ClassLoader)classLoader);
        }
        catch (JAXBException e) {
            throw new DeploymeExtensionException("Cannot create a new instance of JAXBContext object with rootClass " + rootClass.getPackage().getName(), (Throwable)e);
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            schema = schemaFactory.newSchema(xsdSources.toArray(new Source[xsdSources.size()]));
        }
        catch (SAXException e) {
            throw new DeploymeExtensionException("Cannot create a new instance of Schema object with the given XSD sources", (Throwable)e);
        }
        Unmarshaller unmarshaller = null;
        try {
            unmarshaller = jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new DeploymeExtensionException("Cannot instanciate an Unmarshaller object from the JAXBContext " + jaxbContext, (Throwable)e);
        }
        unmarshaller.setSchema(schema);
        JAXBElement root = null;
        try {
            root = (JAXBElement)unmarshaller.unmarshal(node);
        }
        catch (JAXBException e) {
            throw new DeploymeExtensionException("Cannot unmarshall node " + node.getNodeName() + " of the namespace " + node.getNamespaceURI(), (Throwable)e);
        }
        return root.getValue();
    }

    public String getNamespace() {
        return DeployMEPropertiesManager.getTopologyXMLNS((DeploymeVersion)DeploymeVersion.DEPLOYME_2);
    }

    public Object convert(Node localNode, Class rootClass, ClassLoader classLoader) throws DeploymeExtensionException {
        URL parentXSD = TopologyType.class.getClassLoader().getResource(DeployMEPropertiesManager.getXsdTopologyPath((DeploymeVersion)DeploymeVersion.DEPLOYME_2));
        if (parentXSD == null) {
            throw new DeploymeExtensionException("Cannot get the URL of the topology XSD " + DeployMEPropertiesManager.getXsdTopologyPath((DeploymeVersion)DeploymeVersion.DEPLOYME_2));
        }
        this.xsdUrls.add(parentXSD);
        List<Source> sources = this.getSources(this.xsdUrls);
        return this.unmarshall(localNode, rootClass, sources, classLoader);
    }
}

