/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme.v1;

import java.util.ArrayList;
import java.util.List;
import org.ow2.jasmine.deployme.api.IDeployme;
import org.ow2.jasmine.deployme.v1.ConfiguratorBuilder;
import org.ow2.jasmine.deployme.v1.configApply.Configurator;
import org.ow2.jasmine.deployme.v1.generated.Configuration;
import org.ow2.jasmine.deployme.v1.generated.Topology;
import org.ow2.jasmine.deployme.v1.util.ServerDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymeV1
implements IDeployme {
    private Topology topology;
    protected List<ServerDomain> serversDomains;

    public DeploymeV1(Topology topology) {
        this.topology = topology;
    }

    public Topology getTopology() {
        return this.topology;
    }

    public void applyConfiguration(String machine, String domain, String server, String cluster) {
        boolean clusterMode = cluster != null;
        Topology.Domains.Domain.ClusterDaemons.ClusterDaemon clusterDaemon = null;
        if (clusterMode && (clusterDaemon = this.getClusterDaemonConf(domain, cluster)) == null) {
            throw new IllegalArgumentException("Cannot find the specified cluster daemon '" + cluster + "' on specified domain '" + domain + "'");
        }
        this.serversDomains = this.buildServerDomainList(machine, domain, server, cluster);
        if (clusterMode) {
            clusterDaemon = this.mergeClusterDaemonAndDomainConf(clusterDaemon, this.serversDomains.get(0).getDomain());
            Configurator.setClusterAConfiguration(this.serversDomains.get(0).getDomain().getName(), clusterDaemon);
        }
        int i = 1;
        for (ServerDomain sd : this.serversDomains) {
            Configuration confToApply = new ConfiguratorBuilder(sd).getConfig();
            if (clusterMode) {
                confToApply.getGlobalOptions().setJonasBase(clusterDaemon.getJonasBasePrefix() + i++);
            }
            Configurator.setAConfiguration(confToApply, sd);
        }
    }

    public Topology.Domains.Domain.ClusterDaemons.ClusterDaemon getClusterDaemonConf(String domain, String clusterName) {
        Topology.Domains.Domain.ClusterDaemons.ClusterDaemon workingCluster = null;
        for (Topology.Domains.Domain d : this.topology.getDomains().getDomain()) {
            if (!d.getName().equals(domain)) continue;
            for (Topology.Domains.Domain.ClusterDaemons.ClusterDaemon cd : d.getClusterDaemons().getClusterDaemon()) {
                if (!cd.getName().equals(clusterName)) continue;
                workingCluster = cd;
            }
        }
        return workingCluster;
    }

    public List<ServerDomain> buildServerDomainList(String machine, String domain, String server, String clusterName) {
        List<ServerDomain> ret;
        if (machine != null) {
            ret = this.buildServerListWithHostname(machine);
            if (ret == null || ret.size() < 1) {
                throw new IllegalArgumentException("The machine named '" + machine + "' does not appear in the topology file!");
            }
        } else if (clusterName == null) {
            ret = this.buildServerListWithServer(domain, server);
            if (ret == null || ret.size() < 1) {
                throw new IllegalArgumentException("The server named '" + domain + "." + server + "' does not appear in the topology file!");
            }
        } else {
            ret = this.buildServerListWithCluster(domain, clusterName);
            if (ret == null || ret.size() < 1) {
                throw new IllegalArgumentException("The cluster daemon named '" + domain + "." + clusterName + "' does not appear in the topology file!");
            }
        }
        return ret;
    }

    protected List<ServerDomain> buildServerListWithCluster(String domain, String cluster) {
        ArrayList<ServerDomain> ret = new ArrayList<ServerDomain>();
        Topology.Domains.Domain.ClusterDaemons.ClusterDaemon workingCluster = null;
        Topology.Domains.Domain workingDomain = null;
        ArrayList<Topology.Domains.Domain.Servers.Server> servers = new ArrayList<Topology.Domains.Domain.Servers.Server>();
        for (Topology.Domains.Domain d : this.topology.getDomains().getDomain()) {
            if (d.getName().equals(domain)) {
                workingDomain = d;
                for (Topology.Domains.Domain.ClusterDaemons.ClusterDaemon cd : d.getClusterDaemons().getClusterDaemon()) {
                    if (!cd.getName().equals(cluster)) continue;
                    workingCluster = cd;
                    for (String serverName : cd.getServers().getServerName()) {
                        boolean found = false;
                        for (Topology.Domains.Domain.Servers.Server s : workingDomain.getServers().getServer()) {
                            if (!s.getName().equals(serverName)) continue;
                            if (servers.contains(s)) {
                                throw new IllegalArgumentException("Server '" + serverName + "' appears twice in the cluster daemon '" + cluster + "' server list!");
                            }
                            servers.add(s);
                            found = true;
                            break;
                        }
                        if (found) continue;
                        throw new IllegalArgumentException("Server '" + serverName + "' in the cluster daemon '" + cluster + "' server list does not appear in the topology!");
                    }
                }
            }
            if (workingCluster == null) continue;
            break;
        }
        for (Topology.Domains.Domain.Servers.Server s : servers) {
            ret.add(new ServerDomain(s, workingDomain));
        }
        return ret;
    }

    private List<ServerDomain> buildServerListWithServer(String domain, String server) {
        ArrayList<ServerDomain> ret = new ArrayList<ServerDomain>();
        for (Topology.Domains.Domain d : this.topology.getDomains().getDomain()) {
            if (!d.getName().equals(domain)) continue;
            for (Topology.Domains.Domain.Servers.Server s : d.getServers().getServer()) {
                if (!s.getName().equals(server)) continue;
                ret.add(new ServerDomain(s, d));
                break;
            }
            if (ret.isEmpty()) continue;
            break;
        }
        return ret;
    }

    private List<ServerDomain> buildServerListWithHostname(String machine) {
        ArrayList<ServerDomain> ret = new ArrayList<ServerDomain>();
        for (Topology.Domains.Domain d : this.topology.getDomains().getDomain()) {
            for (Topology.Domains.Domain.Servers.Server s : d.getServers().getServer()) {
                if (!s.getMachine().equals(machine)) continue;
                ret.add(new ServerDomain(s, d));
            }
        }
        return ret;
    }

    public Topology.Domains.Domain.ClusterDaemons.ClusterDaemon mergeClusterDaemonAndDomainConf(Topology.Domains.Domain.ClusterDaemons.ClusterDaemon cd, Topology.Domains.Domain domain) {
        if (cd.getJonasRoot() == null) {
            cd.setJonasRoot(domain.getConfiguration().getGlobalOptions().getJonasRoot());
        }
        if (cd.getJavaHome() == null) {
            cd.setJavaHome(domain.getConfiguration().getGlobalOptions().getJavaHome());
        }
        return cd;
    }
}

