/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme.v2;

import java.util.ArrayList;
import java.util.List;
import org.ow2.jasmine.deployme.api.IDeployme;
import org.ow2.jasmine.deployme.api.extensions.IDeploymeExtension;
import org.ow2.jasmine.deployme.api.modules.IDeploymeModule;
import org.ow2.jasmine.deployme.v2.configApply.Configurator;
import org.ow2.jasmine.deployme.v2.generated.AgentType;
import org.ow2.jasmine.deployme.v2.generated.AgentsType;
import org.ow2.jasmine.deployme.v2.generated.DomainType;
import org.ow2.jasmine.deployme.v2.generated.DomainsType;
import org.ow2.jasmine.deployme.v2.generated.ServerNameType;
import org.ow2.jasmine.deployme.v2.generated.ServerType;
import org.ow2.jasmine.deployme.v2.generated.TopologyType;
import org.ow2.jasmine.deployme.v2.util.Agent;
import org.ow2.jasmine.deployme.v2.util.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymeV2
implements IDeployme {
    private TopologyType topology;
    private List<IDeploymeExtension> availableExtensions;
    private List<IDeploymeModule> availableModules;
    private List<Server> servers;
    private Agent agent;

    public DeploymeV2(TopologyType topology, List<IDeploymeExtension> deploymeExtensions, List<IDeploymeModule> deploymeModules) {
        this.topology = topology;
        this.availableExtensions = deploymeExtensions;
        this.availableModules = deploymeModules;
    }

    public void applyConfiguration(String machine, String domainName, String serverName, String clusterName) {
        this.servers = this.buildServerList(machine, domainName, serverName, clusterName);
        Boolean clusterMode = clusterName != null;
        if (clusterMode.booleanValue()) {
            this.agent = this.getAgent(domainName, clusterName);
            Configurator.setAConfiguration(this.agent);
        }
        int i = 1;
        for (Server server : this.servers) {
            if (clusterMode.booleanValue()) {
                server.setJonasBase(this.agent.getJonasBase() + i++);
            }
            Configurator.setAConfiguration(server);
        }
    }

    public List<Server> buildServerList(String machine, String domainName, String serverName, String clusterName) {
        List<Server> servers;
        if (machine != null) {
            servers = this.buildServerListWithHostname(machine);
            if (servers == null || servers.size() < 1) {
                throw new IllegalArgumentException("The machine named '" + machine + "' does not appear in the topology file!");
            }
        } else if (clusterName == null) {
            servers = this.buildServerListWithServer(domainName, serverName);
            if (servers == null || servers.size() < 1) {
                throw new IllegalArgumentException("The server named '" + domainName + "." + serverName + "' does not appear in the topology file!");
            }
        } else {
            servers = this.buildServerListManagedByAgent(domainName, clusterName);
            if (servers == null || servers.size() < 1) {
                throw new IllegalArgumentException("The cluster daemon named '" + domainName + "." + clusterName + "' does not appear in the topology file!");
            }
        }
        return servers;
    }

    protected List<Server> buildServerListWithHostname(String machine) {
        ArrayList<Server> servers = new ArrayList<Server>();
        DomainsType domains = this.topology.getDomains();
        for (DomainType domain : domains.getDomain()) {
            for (ServerType server : domain.getServers().getServer()) {
                if (!server.getMachine().equals(machine)) continue;
                servers.add(new Server(server, domain, domains, true, this.availableExtensions, this.availableModules));
            }
        }
        return servers;
    }

    protected List<Server> buildServerListWithServer(String domainName, String serverName) {
        ArrayList<Server> servers = new ArrayList<Server>();
        DomainsType domains = this.topology.getDomains();
        block0: for (DomainType domain : domains.getDomain()) {
            if (!domain.getName().equals(domainName)) continue;
            for (ServerType server : domain.getServers().getServer()) {
                if (!server.getName().equals(serverName)) continue;
                servers.add(new Server(server, domain, domains, true, this.availableExtensions, this.availableModules));
                continue block0;
            }
        }
        return servers;
    }

    protected Agent getAgent(String domainName, String clusterName) {
        DomainsType domains = this.topology.getDomains();
        for (DomainType domain : domains.getDomain()) {
            if (!domain.getName().equals(domainName)) continue;
            for (AgentType agent : domain.getAgents().getAgent()) {
                if (!agent.getName().equals(clusterName)) continue;
                return new Agent(agent, domain, domains, true, this.availableExtensions, this.availableModules);
            }
        }
        return null;
    }

    protected List<Server> buildServerListManagedByAgent(String domainName, String clusterName) {
        ArrayList<Server> servers = new ArrayList<Server>();
        DomainsType domains = this.topology.getDomains();
        for (DomainType domain : domains.getDomain()) {
            AgentsType agents;
            if (!domain.getName().equals(domainName) || (agents = domain.getAgents()) == null) continue;
            for (AgentType agent : agents.getAgent()) {
                if (!agent.getName().equals(clusterName)) continue;
                for (ServerNameType serverName : agent.getManagedServers().getServerName()) {
                    boolean found = false;
                    for (ServerType server : domain.getServers().getServer()) {
                        if (!server.getName().equals(serverName.getName())) continue;
                        if (servers.contains(server)) {
                            throw new IllegalArgumentException("Server '" + serverName.getName() + "' appears twice in the cluster daemon '" + clusterName + "' server list!");
                        }
                        servers.add(new Server(server, domain, domains, true, this.availableExtensions, this.availableModules));
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new IllegalArgumentException("Server '" + serverName.getName() + "' in the cluster daemon '" + clusterName + "' server list does not appear in the topology!");
                }
            }
        }
        return servers;
    }

    public Server getServer(String domainName, String serverName) {
        for (Server server : this.servers) {
            if (!server.getServerName().equals(serverName) || !server.getDomainName().equals(domainName)) continue;
            return server;
        }
        return null;
    }
}

