/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme.v2.configApply;

import java.util.Map;
import org.ow2.jasmine.deployme.api.extensions.IDeploymeExtension;
import org.ow2.jasmine.deployme.api.modules.IDeploymeModule;
import org.ow2.jasmine.deployme.api.modules.UnsupportDeploymeModuleException;
import org.ow2.jasmine.deployme.v2.generated.AgentType;
import org.ow2.jasmine.deployme.v2.generated.SimpleContentWithInheritAttribute;
import org.ow2.jonas.tools.configurator.Jonas;
import org.ow2.jonas.tools.configurator.api.JonasConfigurator;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigJonasApply {
    private static final Log logger = LogFactory.getLog(ConfigJonasApply.class);
    private JonasConfigurator jonasConf;
    private Boolean clusterMode = false;

    public ConfigJonasApply(String jonasRoot) {
        Jonas jonas = new Jonas(jonasRoot);
        this.jonasConf = jonas.getJonasConfigurator();
    }

    public void setClusterConfiguration(String domainName, AgentType agent) {
        String jonasScriptPath;
        String xparam;
        String serverNamePrefix;
        String javaHome;
        String interactionMode;
        this.jonasConf.setCDNbInstances(agent.getManagedServers().getServerName().size());
        String agentName = agent.getName();
        if (agentName != null) {
            this.jonasConf.setCDClusterName(agentName);
        }
        this.jonasConf.setCDClusterDomain(domainName);
        String jonasBase = agent.getJonasBase().getValue();
        if (jonasBase != null) {
            this.jonasConf.setCDDestDirPrefix(jonasBase);
        }
        if ((interactionMode = agent.getInteractionMode()) != null) {
            this.jonasConf.setCDInteractionMode(interactionMode);
        }
        if ((javaHome = agent.getJavaHome()) != null) {
            this.jonasConf.setCDJavaHome(javaHome);
        }
        if ((serverNamePrefix = agent.getServerNamePrefix()) != null) {
            this.jonasConf.setCDServerNamePrefix(serverNamePrefix);
        }
        if ((xparam = agent.getXparam()) != null) {
            this.jonasConf.setCDXparam(xparam);
        }
        this.jonasConf.setCDAutoBoot(agent.isAutoboot());
        SimpleContentWithInheritAttribute jonasScript = agent.getJonasScript();
        if (jonasScript != null && (jonasScriptPath = jonasScript.getValue()) != null) {
            this.jonasConf.setCDJOnASScript(jonasScriptPath);
        }
        this.clusterMode = true;
    }

    public void applyExtensionConfiguration(Map<IDeploymeExtension, Object> extensions) {
        if (extensions != null) {
            for (Map.Entry<IDeploymeExtension, Object> extension : extensions.entrySet()) {
                if (extension == null) continue;
                IDeploymeExtension deploymeExtension = extension.getKey();
                Object topologyObject = extension.getValue();
                if (deploymeExtension == null || topologyObject == null) continue;
                deploymeExtension.applyConfiguration(this.jonasConf, topologyObject);
            }
        }
    }

    public void applyModuleConfiguration(Map<IDeploymeModule, Object> modules) {
        if (modules != null) {
            for (Map.Entry<IDeploymeModule, Object> module : modules.entrySet()) {
                if (module == null) continue;
                IDeploymeModule deploymeModule = module.getKey();
                Object topologyObject = module.getValue();
                if (deploymeModule == null || topologyObject == null) continue;
                try {
                    deploymeModule.applyConfiguration(this.jonasConf, topologyObject);
                }
                catch (UnsupportDeploymeModuleException e) {
                    logger.error((Object)("Cannot apply configuration of topology object " + topologyObject.getClass().getName()), new Object[]{e});
                }
            }
        }
    }

    public void setJOnASBase(String jonasBase, boolean update) {
        if (jonasBase != null) {
            this.jonasConf.setJonasBase(jonasBase);
        }
        if (jonasBase != null) {
            this.jonasConf.isJOnASBaseToUpdate(Boolean.valueOf(update));
        }
    }

    public void setJOnASName(String serverName) {
        if (serverName != null) {
            this.jonasConf.setJonasName(serverName);
        }
    }

    public void setDomainName(String domainName) {
        if (domainName != null) {
            this.jonasConf.setJonasDomain(domainName);
        }
    }

    public void setServices(String services) {
        if (services != null) {
            this.jonasConf.setServices(services);
        }
    }

    public void execute() {
        this.jonasConf.execute();
        if (this.clusterMode.booleanValue()) {
            this.jonasConf.executeCDConf();
        }
    }
}

