/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme.v2.configApply;

import java.util.Map;
import org.ow2.jasmine.deployme.api.extensions.IDeploymeExtension;
import org.ow2.jasmine.deployme.api.modules.IDeploymeModule;
import org.ow2.jasmine.deployme.v2.configApply.ConfigJonasApply;
import org.ow2.jasmine.deployme.v2.util.Agent;
import org.ow2.jasmine.deployme.v2.util.Server;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class Configurator {
    protected static Log logger = LogFactory.getLog(Configurator.class);

    public static void setAConfiguration(Server server) {
        String domainName = server.getDomainName();
        String serverName = server.getServerName();
        String jonasRoot = server.getJonasRoot();
        String jonasBase = server.getJonasBase();
        if (jonasRoot == null) {
            throw new IllegalArgumentException("The topology file doesn't define any JONAS_ROOT for the server " + server);
        }
        ConfigJonasApply configJonasApply = new ConfigJonasApply(jonasRoot);
        logger.info((Object)("Starting configuration set up for server " + server + " in directory " + jonasBase), new Object[0]);
        if (jonasBase != null && jonasRoot.equals(jonasBase)) {
            throw new IllegalArgumentException("JONAS_BASE must be different from JONAS_ROOT for server " + server);
        }
        configJonasApply.setJOnASBase(jonasBase, server.isJonasBaseToUpdate());
        configJonasApply.setServices(Configurator.getJOnASServices(server));
        configJonasApply.setDomainName(domainName);
        configJonasApply.setJOnASName(serverName);
        configJonasApply.applyModuleConfiguration(server.getModules());
        configJonasApply.applyExtensionConfiguration(server.getExtensions());
        configJonasApply.execute();
        logger.info((Object)("Server " + server + " configured successfully"), new Object[0]);
    }

    public static void setAConfiguration(Agent agent) {
        String domainName = agent.getDomainName();
        String serverName = agent.getServerName();
        String jonasRoot = agent.getJonasRoot();
        String jonasBase = agent.getJonasBase();
        if (jonasRoot == null) {
            throw new IllegalArgumentException("The topology file doesn't define any JONAS_ROOT for the agent " + agent);
        }
        ConfigJonasApply configJonasApply = new ConfigJonasApply(jonasRoot);
        logger.info((Object)("Starting configuration set up for the agent " + agent + " in directory " + jonasBase), new Object[0]);
        if (jonasBase != null && jonasRoot.equals(jonasBase)) {
            throw new IllegalArgumentException("JONAS_BASE must be different from JONAS_ROOT for the agent " + agent);
        }
        configJonasApply.setJOnASBase(jonasBase, agent.isJonasBaseToUpdate());
        configJonasApply.setServices(Configurator.getJOnASServices(agent));
        configJonasApply.setDomainName(domainName);
        configJonasApply.setJOnASName(serverName);
        configJonasApply.setClusterConfiguration(domainName, agent.getAgent());
        configJonasApply.applyModuleConfiguration(agent.getModules());
        configJonasApply.applyExtensionConfiguration(agent.getExtensions());
        configJonasApply.execute();
        logger.info((Object)("Agent " + agent + " configured successfully"), new Object[0]);
    }

    private static String getJOnASServices(Server server) {
        String servicesAsString;
        Map<IDeploymeExtension, Object> extensions;
        StringBuilder stringBuilder = new StringBuilder();
        Map<IDeploymeModule, Object> modules = server.getModules();
        if (modules != null) {
            for (IDeploymeModule module : modules.keySet()) {
                String service;
                if (module == null || (service = module.getJOnASService()) == null || stringBuilder.toString().contains(service)) continue;
                stringBuilder.append(service + ",");
            }
        }
        if ((extensions = server.getExtensions()) != null) {
            for (IDeploymeExtension extension : extensions.keySet()) {
                String service;
                if (extension == null || (service = extension.getJOnASService()) == null || stringBuilder.toString().contains(service)) continue;
                stringBuilder.append(service + ",");
            }
        }
        if ((servicesAsString = stringBuilder.toString()).length() > 0) {
            return servicesAsString.substring(0, servicesAsString.length() - 1);
        }
        return servicesAsString.toString();
    }

    private static String getJOnASServices(Agent agent) {
        Map<IDeploymeExtension, Object> extensions;
        StringBuilder stringBuilder = new StringBuilder();
        Map<IDeploymeModule, Object> modules = agent.getModules();
        if (modules != null) {
            for (IDeploymeModule module : modules.keySet()) {
                String service;
                if (module == null || (service = module.getJOnASService()) == null || stringBuilder.toString().contains(service)) continue;
                stringBuilder.append(service + ",");
            }
        }
        if ((extensions = agent.getExtensions()) != null) {
            for (IDeploymeExtension extension : extensions.keySet()) {
                String service;
                if (extension == null || (service = extension.getJOnASService()) == null || stringBuilder.toString().contains(service)) continue;
                stringBuilder.append(service + ",");
            }
        }
        String servicesAsString = stringBuilder.toString();
        if (stringBuilder.length() > 0) {
            return servicesAsString.substring(0, servicesAsString.length() - 1);
        }
        return servicesAsString.toString();
    }
}

