/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme.v2.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;
import org.ow2.jasmine.deployme.api.IServer;
import org.ow2.jasmine.deployme.api.extensions.DeploymeExtensionException;
import org.ow2.jasmine.deployme.api.extensions.IDeploymeExtension;
import org.ow2.jasmine.deployme.api.modules.IDeploymeModule;
import org.ow2.jasmine.deployme.v2.generated.ConfigurationType;
import org.ow2.jasmine.deployme.v2.generated.PropertiesType;
import org.ow2.jasmine.deployme.v2.generated.PropertyType;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.merge.object.MergeObject;
import org.ow2.util.substitution.IPropertyResolver;
import org.ow2.util.substitution.engine.DefaultSubstitutionEngine;
import org.ow2.util.substitution.resolver.PropertiesResolver;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServer
implements IServer {
    protected ConfigurationType serversConfiguration;
    protected ConfigurationType domainConfiguration;
    protected ConfigurationType domainsConfiguration;
    protected PropertiesType serverProperties;
    protected PropertiesType serversProperties;
    protected PropertiesType domainProperties;
    protected PropertiesType domainsProperties;
    protected String jonasRoot;
    protected String jonasBase;
    protected Boolean updateJonasBase;
    protected String serverName;
    protected String domainName;
    protected Map<IDeploymeExtension, Object> extensions = new HashMap<IDeploymeExtension, Object>();
    protected List<IDeploymeExtension> availableExtensions;
    private Map<IDeploymeModule, Object> modules = new HashMap<IDeploymeModule, Object>();
    protected List<IDeploymeModule> availableModules;
    protected static Log logger = LogFactory.getLog(AbstractServer.class);
    private static final Pattern pattern = Pattern.compile("java.lang.+");
    protected DefaultSubstitutionEngine engine;

    protected void merge() {
        this.mergeConfiguration();
    }

    protected void mergeConfiguration() {
        ConfigurationType configuration = this.getServerConfiguration();
        Boolean inherit = true;
        if (configuration != null && configuration.isInherit() != null) {
            inherit = configuration.isInherit();
        }
        if (inherit.booleanValue()) {
            if (this.serversConfiguration != null) {
                this.mergeConfiguration(configuration, this.serversConfiguration);
                if (this.serversConfiguration.isInherit() != null) {
                    inherit = this.serversConfiguration.isInherit();
                }
            }
            if (inherit.booleanValue() && this.domainConfiguration != null) {
                this.mergeConfiguration(configuration, this.domainConfiguration);
                if (this.domainConfiguration.isInherit() != null) {
                    inherit = this.domainConfiguration.isInherit();
                }
            }
            if (inherit.booleanValue() && this.domainsConfiguration != null) {
                this.mergeConfiguration(configuration, this.domainsConfiguration);
            }
        }
    }

    protected void initProperties() {
        boolean inherit = true;
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)System.getProperties());
        properties.putAll(System.getenv());
        if (this.serverProperties != null) {
            this.addProperties(properties, this.serverProperties.getProperty());
            inherit = this.serverProperties.isInherit();
        }
        if (inherit && this.serversProperties != null) {
            this.addProperties(properties, this.serversProperties.getProperty());
            inherit = this.serversProperties.isInherit();
        }
        if (inherit && this.domainProperties != null) {
            this.addProperties(properties, this.domainProperties.getProperty());
            inherit = this.domainProperties.isInherit();
        }
        if (inherit && this.domainsProperties != null) {
            this.addProperties(properties, this.domainsProperties.getProperty());
            inherit = this.domainsProperties.isInherit();
        }
        this.engine = new DefaultSubstitutionEngine();
        this.engine.setResolver((IPropertyResolver)new PropertiesResolver(properties));
    }

    private void addProperties(Properties properties, List<PropertyType> propertiesType) {
        if (propertiesType != null) {
            for (PropertyType property : propertiesType) {
                String key = property.getName();
                String value = property.getValue();
                if (key == null || value == null || properties.contains(key)) continue;
                properties.put(key, value);
            }
        }
    }

    protected void substituteProperties() {
        if (this.modules != null) {
            for (Object object : this.modules.values()) {
                if (object == null) continue;
                this.substituteProperties(object);
            }
        }
        if (this.extensions != null) {
            for (Object object : this.extensions.values()) {
                if (object == null) continue;
                this.substituteProperties(object);
            }
        }
    }

    private void substituteProperties(Object object) {
        List fields;
        if (object != null && (fields = MergeObject.getAllField(object.getClass())) != null) {
            for (Field field : fields) {
                int modifier = field.getModifiers();
                if (Modifier.isFinal(modifier) || Modifier.isStatic(modifier)) continue;
                Object value = MergeObject.getValue((Field)field, (Object)object);
                if (value instanceof String) {
                    String initialValue = String.valueOf(value);
                    String substitutedString = this.engine.substitute(initialValue);
                    if (substitutedString == null || initialValue.equals(substitutedString)) continue;
                    MergeObject.setValue((Field)field, (Object)object, (Object)substitutedString);
                    continue;
                }
                boolean javaLangClass = pattern.matcher(field.getType().getName()).matches();
                if (value == null || value.getClass().isPrimitive() || javaLangClass) continue;
                this.substituteProperties(value);
            }
        }
    }

    protected void buildModulesAndExtensions(ConfigurationType configuration) {
        List objects;
        if (configuration != null && (objects = configuration.getAny()) != null) {
            for (Object object : objects) {
                if (object instanceof Node) {
                    this.buildExtension((Node)object);
                    continue;
                }
                if (!(object instanceof JAXBElement)) continue;
                this.buildModule(((JAXBElement)JAXBElement.class.cast(object)).getValue());
            }
        }
    }

    private void buildExtension(Node node) {
        if (node != null) {
            String namespace = node.getNamespaceURI();
            IDeploymeExtension extension = this.getAvailableExtension(namespace);
            if (extension != null) {
                try {
                    Object object = extension.convert(node);
                    if (object != null) {
                        this.extensions.put(extension, object);
                    }
                }
                catch (DeploymeExtensionException e) {
                    logger.error((Object)("Cannot get extension object of namespace " + namespace), new Object[]{e});
                }
            } else {
                logger.error((Object)("Cannot find a DeployME extension associated to the node " + node.getNodeName() + " with namespace " + namespace), new Object[0]);
            }
        }
    }

    private void buildModule(Object object) {
        IDeploymeModule module = this.getAvailableModule(object);
        if (module != null) {
            this.modules.put(module, object);
        } else {
            logger.error((Object)("Cannot find a DeployME module associated to the object " + object.getClass().getName()), new Object[0]);
        }
    }

    private IDeploymeModule getAvailableModule(Object object) {
        if (object != null) {
            for (IDeploymeModule module : this.availableModules) {
                if (!module.isSupport(object)) continue;
                return module;
            }
        }
        return null;
    }

    private Map.Entry<IDeploymeModule, Object> getModule(Object object) {
        if (object != null) {
            for (Map.Entry<IDeploymeModule, Object> module : this.modules.entrySet()) {
                IDeploymeModule deploymeModule = module.getKey();
                if (deploymeModule == null || !deploymeModule.isSupport(object)) continue;
                return module;
            }
        }
        return null;
    }

    private Map.Entry<IDeploymeExtension, Object> getExtension(String namespace) {
        for (Map.Entry<IDeploymeExtension, Object> extension : this.extensions.entrySet()) {
            String ns;
            IDeploymeExtension deploymeExtension = extension.getKey();
            if (deploymeExtension == null || (ns = deploymeExtension.getNamespace()) == null || !ns.equals(namespace)) continue;
            return extension;
        }
        return null;
    }

    private IDeploymeExtension getAvailableExtension(String namespace) {
        for (IDeploymeExtension extension : this.availableExtensions) {
            String ns = extension.getNamespace();
            if (ns == null || !ns.equals(namespace)) continue;
            return extension;
        }
        return null;
    }

    protected abstract ConfigurationType getServerConfiguration();

    protected void mergeConfiguration(ConfigurationType localConfiguration, ConfigurationType configuration) {
        if (localConfiguration == null) {
            localConfiguration = configuration;
        } else {
            List objects = configuration.getAny();
            if (objects != null) {
                for (Object object : objects) {
                    if (object instanceof Node) {
                        Node node = (Node)object;
                        String namespace = node.getNamespaceURI();
                        Map.Entry<IDeploymeExtension, Object> extension = this.getExtension(namespace);
                        if (extension != null) {
                            IDeploymeExtension deploymeExtension = extension.getKey();
                            Object localTopologyObject = extension.getValue();
                            try {
                                Object globalTopologyObject = deploymeExtension.convert(node);
                                MergeObject.mergeObject((Object)localTopologyObject, (Object)globalTopologyObject);
                            }
                            catch (DeploymeExtensionException e) {
                                logger.error((Object)("Cannot convert node " + node.getNodeName() + " to a Topology object."), new Object[]{e});
                            }
                            continue;
                        }
                        this.buildExtension(node);
                        continue;
                    }
                    if (!(object instanceof JAXBElement)) continue;
                    Object globalTopologyObject = ((JAXBElement)JAXBElement.class.cast(object)).getValue();
                    Map.Entry<IDeploymeModule, Object> module = this.getModule(globalTopologyObject);
                    if (module != null) {
                        Object localTopologyObject = module.getValue();
                        IDeploymeModule deploymeModule = module.getKey();
                        Map classIdField = null;
                        if (deploymeModule != null) {
                            classIdField = deploymeModule.getClassIdField();
                        }
                        MergeObject.mergeObject((Object)localTopologyObject, (Object)globalTopologyObject, (Map)classIdField);
                        continue;
                    }
                    this.buildModule(globalTopologyObject);
                }
            }
        }
    }

    public String getJonasRoot() {
        return this.jonasRoot;
    }

    public String getJonasBase() {
        return this.jonasBase;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public Boolean isJonasBaseToUpdate() {
        return this.updateJonasBase;
    }

    public String toString() {
        return this.domainName + "." + this.serverName;
    }

    public void setJonasBase(String jonasBase) {
        this.jonasBase = this.engine.substitute(jonasBase);
    }

    public void setJonasRoot(String jonasRoot) {
        this.jonasRoot = this.engine.substitute(jonasRoot);
    }

    public Map<IDeploymeExtension, Object> getExtensions() {
        return this.extensions;
    }

    public Map<IDeploymeModule, Object> getModules() {
        return this.modules;
    }
}

