/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme.v2.util;

import java.util.List;
import org.ow2.jasmine.deployme.api.extensions.IDeploymeExtension;
import org.ow2.jasmine.deployme.api.modules.IDeploymeModule;
import org.ow2.jasmine.deployme.v2.generated.AgentType;
import org.ow2.jasmine.deployme.v2.generated.ConfigurationType;
import org.ow2.jasmine.deployme.v2.generated.DomainType;
import org.ow2.jasmine.deployme.v2.generated.DomainsType;
import org.ow2.jasmine.deployme.v2.generated.JOnASBaseType;
import org.ow2.jasmine.deployme.v2.generated.SimpleContentWithInheritAttribute;
import org.ow2.jasmine.deployme.v2.util.AbstractServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Agent
extends AbstractServer {
    private AgentType agent;
    protected SimpleContentWithInheritAttribute domainsJonasScript;
    protected SimpleContentWithInheritAttribute domainJonasScript;

    public Agent(AgentType agent, DomainType domain, DomainsType domains, Boolean merge, List<IDeploymeExtension> availableExtensions, List<IDeploymeModule> availableModules) {
        this.availableExtensions = availableExtensions;
        this.availableModules = availableModules;
        if (domain != null) {
            this.domainConfiguration = domain.getAgentsConfiguration();
            this.serversConfiguration = domain.getAgents().getAgentsConfiguration();
            this.domainJonasScript = domain.getJonasScript();
            this.serversProperties = domain.getAgents().getProperties();
            this.domainProperties = domain.getProperties();
        }
        if (domains != null) {
            this.domainsConfiguration = domains.getAgentsConfiguration();
            this.domainsJonasScript = domains.getJonasScript();
            this.domainsProperties = domains.getProperties();
        }
        this.agent = agent;
        this.serversProperties = agent.getProperties();
        this.domainName = domain.getName();
        this.serverName = agent.getName();
        this.buildModulesAndExtensions(agent.getConfiguration());
        if (merge != null && merge.booleanValue()) {
            this.merge();
        }
        this.initProperties();
        JOnASBaseType jonasBase = agent.getJonasBase();
        this.setJonasRoot(agent.getJonasRoot());
        this.setJonasBase(jonasBase.getValue());
        this.updateJonasBase = jonasBase.isUpdate();
        this.substituteProperties();
    }

    @Override
    protected void merge() {
        super.merge();
        this.mergeJonasScript();
    }

    protected void mergeJonasScript() {
        SimpleContentWithInheritAttribute jonasScript = this.agent.getJonasScript();
        Boolean inherit = true;
        if (jonasScript != null && jonasScript.isInherit() != null) {
            inherit = jonasScript.isInherit();
        }
        if (jonasScript == null || jonasScript.getValue() == null) {
            if (inherit.booleanValue() && this.domainJonasScript != null) {
                if (this.domainJonasScript.isInherit() != null) {
                    inherit = this.domainJonasScript.isInherit();
                }
                if (jonasScript == null) {
                    jonasScript = this.domainJonasScript;
                } else {
                    jonasScript.setValue(this.domainJonasScript.getValue());
                }
            }
            if (inherit.booleanValue() && this.domainsJonasScript != null) {
                if (jonasScript == null) {
                    jonasScript = this.domainsJonasScript;
                } else {
                    jonasScript.setValue(this.domainsJonasScript.getValue());
                }
            }
        }
    }

    @Override
    protected ConfigurationType getServerConfiguration() {
        return this.agent.getConfiguration();
    }

    public AgentType getAgent() {
        return this.agent;
    }
}

