/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme.v2.util;

import java.util.List;
import org.ow2.jasmine.deployme.api.extensions.IDeploymeExtension;
import org.ow2.jasmine.deployme.api.modules.IDeploymeModule;
import org.ow2.jasmine.deployme.v2.generated.ConfigurationType;
import org.ow2.jasmine.deployme.v2.generated.DomainType;
import org.ow2.jasmine.deployme.v2.generated.DomainsType;
import org.ow2.jasmine.deployme.v2.generated.JOnASBaseType;
import org.ow2.jasmine.deployme.v2.generated.ServerType;
import org.ow2.jasmine.deployme.v2.generated.ServersType;
import org.ow2.jasmine.deployme.v2.util.AbstractServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
extends AbstractServer {
    private ServerType server;

    public Server(ServerType server, DomainType domain, DomainsType domains, Boolean merge, List<IDeploymeExtension> availableExtensions, List<IDeploymeModule> availableModules) {
        this.availableExtensions = availableExtensions;
        this.availableModules = availableModules;
        if (domain != null) {
            this.domainConfiguration = domain.getServersConfiguration();
            this.domainProperties = domain.getProperties();
            ServersType servers = domain.getServers();
            if (servers != null) {
                this.serversConfiguration = servers.getServersConfiguration();
                this.serversProperties = servers.getProperties();
            }
        }
        if (domains != null) {
            this.domainsConfiguration = domains.getServersConfiguration();
            this.domainsProperties = domains.getProperties();
        }
        this.serverProperties = server.getProperties();
        this.server = server;
        this.domainName = domain.getName();
        this.serverName = server.getName();
        this.buildModulesAndExtensions(server.getConfiguration());
        if (merge != null && merge.booleanValue()) {
            this.merge();
        }
        this.initProperties();
        JOnASBaseType jonasBase = server.getJonasBase();
        this.setJonasRoot(server.getJonasRoot());
        this.setJonasBase(jonasBase.getValue());
        this.updateJonasBase = jonasBase.isUpdate();
        this.substituteProperties();
    }

    @Override
    protected ConfigurationType getServerConfiguration() {
        return this.server.getConfiguration();
    }

    public ServerType getServer() {
        return this.server;
    }
}

