/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme;

import java.io.File;
import java.net.URL;
import org.ow2.jasmine.deployme.DeployMe;
import org.ow2.jasmine.deployme.utils.CommandLine;

public class CommandLineParser {
    public static void main(String[] args) {
        try {
            CommandLine command = CommandLineParser.parseCommandLine(args);
            File topologyFile = new File(command.getTopologyFile());
            URL urlXML = topologyFile.isFile() ? topologyFile.toURI().toURL() : CommandLineParser.class.getClassLoader().getResource(command.getTopologyFile());
            if (urlXML == null) {
                throw new IllegalArgumentException("Unable to find topology file : " + command.getTopologyFile());
            }
            new DeployMe(urlXML, command.getHostName(), command.getDomainName(), command.getServerName(), command.getClusterName());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            if (e.getMessage() == null) {
                e.printStackTrace();
            }
            System.exit(-1);
        }
    }

    protected static CommandLine parseCommandLine(String[] args) {
        CommandLine ret = new CommandLine();
        for (String tmp : args) {
            String argEntry = CommandLineParser.checkArgEntry(tmp);
            String[] argsSeparated = argEntry.split("=");
            if (argsSeparated.length != 2) {
                throw new IllegalArgumentException(argEntry + " isn't reconize, argument must contain one and only one '='");
            }
            ret.addValue(argsSeparated[0], argsSeparated[1]);
        }
        ret.checkCommandLine();
        return ret;
    }

    protected static String checkArgEntry(String argEntry) {
        if (argEntry.charAt(0) != '-') {
            throw new IllegalArgumentException(argEntry + " isn't reconize, argument must start with '-'");
        }
        return argEntry.substring(1);
    }
}

