/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.ow2.jasmine.deployme.ConfiguratorBuilder;
import org.ow2.jasmine.deployme.configApply.Configurator;
import org.ow2.jasmine.deployme.generated.Configuration;
import org.ow2.jasmine.deployme.generated.Topology;
import org.ow2.jasmine.deployme.loadXml.XmlLoader;
import org.ow2.jasmine.deployme.utils.DeployMEPropertiesManager;
import org.ow2.jasmine.deployme.utils.ServerDomain;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployMe {
    protected Topology topology;
    protected List<ServerDomain> serversDomains;

    protected DeployMe() {
    }

    public DeployMe(URL topologyUrl, String hostname, String domain, String server, String cluster) throws SAXException, JAXBException {
        this.loadTopology(topologyUrl, DeployMEPropertiesManager.getXsdTopologyURL());
        boolean clusterMode = cluster != null;
        Topology.Domains.Domain.ClusterDaemons.ClusterDaemon clusterDaemon = null;
        if (clusterMode && (clusterDaemon = this.getClusterDaemonConf(domain, cluster)) == null) {
            throw new IllegalArgumentException("Unable to find cluster daemon : " + domain + "." + cluster);
        }
        this.serversDomains = this.buildServerDomainList(hostname, domain, server, cluster);
        if (clusterMode) {
            clusterDaemon = this.mergeClusterDaemonAndDomainConf(clusterDaemon, this.serversDomains.get(0).getDomain());
            Configurator.setClusterAConfiguration(this.serversDomains.get(0).getDomain().getName(), clusterDaemon);
        }
        int i = 1;
        for (ServerDomain sd : this.serversDomains) {
            Configuration confToApply = new ConfiguratorBuilder(sd).getConfig();
            if (clusterMode) {
                confToApply.getGlobalJonas().setJonasBase(clusterDaemon.getJonasBasePrefix() + i++);
            }
            Configurator.setAConfiguration(confToApply, sd);
        }
    }

    protected void loadTopology(URL urlTopology, URL schemaUrl) throws SAXException, JAXBException {
        XmlLoader xmlLoader = new XmlLoader(urlTopology, schemaUrl);
        this.topology = xmlLoader.getTopology();
    }

    protected Topology.Domains.Domain.ClusterDaemons.ClusterDaemon getClusterDaemonConf(String domain, String clusterName) {
        Topology.Domains.Domain.ClusterDaemons.ClusterDaemon workingCluster = null;
        for (Topology.Domains.Domain d : this.topology.getDomains().getDomain()) {
            if (d.getName().compareTo(domain) != 0) continue;
            for (Topology.Domains.Domain.ClusterDaemons.ClusterDaemon cd : d.getClusterDaemons().getClusterDaemon()) {
                if (cd.getClusterDaemonName().compareTo(clusterName) != 0) continue;
                workingCluster = cd;
            }
        }
        return workingCluster;
    }

    protected List<ServerDomain> buildServerDomainList(String hostname, String domain, String server, String clusterName) {
        List<ServerDomain> ret = hostname != null ? this.buildServerListWithHostname(hostname) : (clusterName == null ? this.buildServerListWithServer(domain, server) : this.buildServerListWithCluster(domain, clusterName));
        return ret;
    }

    private List<ServerDomain> buildServerListWithCluster(String domain, String cluster) {
        ArrayList<ServerDomain> ret = new ArrayList<ServerDomain>();
        Topology.Domains.Domain.ClusterDaemons.ClusterDaemon workingCluster = null;
        Topology.Domains.Domain workingDomain = null;
        ArrayList<Topology.Domains.Domain.Servers.Server> servers = new ArrayList<Topology.Domains.Domain.Servers.Server>();
        for (Topology.Domains.Domain d : this.topology.getDomains().getDomain()) {
            if (d.getName().compareTo(domain) == 0) {
                workingDomain = d;
                for (Topology.Domains.Domain.ClusterDaemons.ClusterDaemon cd : d.getClusterDaemons().getClusterDaemon()) {
                    if (cd.getClusterDaemonName().compareTo(cluster) != 0) continue;
                    workingCluster = cd;
                    for (String serverName : cd.getServers().getServerName()) {
                        boolean found = false;
                        for (Topology.Domains.Domain.Servers.Server s : workingDomain.getServers().getServer()) {
                            if (s.getName().compareTo(serverName) != 0) continue;
                            if (servers.contains(s)) {
                                throw new IllegalArgumentException("Server '" + serverName + "' appears twice in the cluster daemon '" + cluster + "' server list!");
                            }
                            servers.add(s);
                            found = true;
                            break;
                        }
                        if (found) continue;
                        throw new IllegalArgumentException("Server '" + serverName + "' in the cluster daemon '" + cluster + "' server list does not appear in the topology!");
                    }
                }
            }
            if (workingCluster == null) continue;
            break;
        }
        for (Topology.Domains.Domain.Servers.Server s : servers) {
            ret.add(new ServerDomain(s, workingDomain));
        }
        return ret;
    }

    private List<ServerDomain> buildServerListWithServer(String domain, String server) {
        ArrayList<ServerDomain> ret = new ArrayList<ServerDomain>();
        for (Topology.Domains.Domain d : this.topology.getDomains().getDomain()) {
            if (d.getName().compareTo(domain) != 0) continue;
            for (Topology.Domains.Domain.Servers.Server s : d.getServers().getServer()) {
                if (s.getName().compareTo(server) != 0) continue;
                ret.add(new ServerDomain(s, d));
                break;
            }
            if (ret.isEmpty()) continue;
            break;
        }
        return ret;
    }

    private List<ServerDomain> buildServerListWithHostname(String hostname) {
        ArrayList<ServerDomain> ret = new ArrayList<ServerDomain>();
        for (Topology.Domains.Domain d : this.topology.getDomains().getDomain()) {
            for (Topology.Domains.Domain.Servers.Server s : d.getServers().getServer()) {
                if (s.getMachine().compareTo(hostname) != 0) continue;
                ret.add(new ServerDomain(s, d));
            }
        }
        return ret;
    }

    protected Topology.Domains.Domain.ClusterDaemons.ClusterDaemon mergeClusterDaemonAndDomainConf(Topology.Domains.Domain.ClusterDaemons.ClusterDaemon cd, Topology.Domains.Domain domain) {
        if (cd.getJonasRoot() == null) {
            cd.setJonasRoot(domain.getConfiguration().getGlobalJonas().getJonasRoot());
        }
        if (cd.getJavaHome() == null) {
            cd.setJavaHome(domain.getConfiguration().getGlobalJonas().getJdk());
        }
        return cd;
    }
}

