/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CommandLineParser.java 2682 2008-10-24 13:05:43Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.deployme;

import java.io.File;
import java.net.URL;

import org.ow2.jasmine.deployme.utils.CommandLine;

/**
 * Parse the command line and call DeployMe main class
 * 
 * @author Remy Bresson
 */
public class CommandLineParser {

    /**
     * Main
     * 
     * @param args command line
     */
    public static void main(final String[] args) {
        try {
            CommandLine command = parseCommandLine(args);

            URL urlXML;
            File topologyFile = new File(command.getTopologyFile());

            if (topologyFile.isFile()) {
                urlXML = topologyFile.toURI().toURL();
            } else {
                urlXML = CommandLineParser.class.getClassLoader().getResource(command.getTopologyFile());
            }

            if (urlXML == null) {
                throw new IllegalArgumentException("Unable to find topology file : " + command.getTopologyFile());
            }

            new DeployMe(urlXML, command.getHostName(), command.getDomainName(), command.getServerName(), command
                .getClusterName());
        } catch (Exception e) {
            System.out.println(e.getMessage());
            if (e.getMessage() == null) {
                e.printStackTrace();
            }
            System.exit(-1);
        }
    }

    /**
     * Parse the command line
     * 
     * @param args command line
     * @return A object who represent parameters to use with deployMe
     */
    protected static CommandLine parseCommandLine(final String[] args) {
        CommandLine ret = new CommandLine();

        for (String tmp : args) {
            String argEntry = checkArgEntry(tmp);

            String[] argsSeparated = argEntry.split("=");
            if (argsSeparated.length != 2) {
                throw new IllegalArgumentException(argEntry + " isn't reconize, argument must contain one and only one '='");
            }

            ret.addValue(argsSeparated[0], argsSeparated[1]);
        }

        ret.checkCommandLine();

        return ret;
    }

    /**
     * Check if the arg begin with '-' and remove '-'
     * 
     * @param argEntry the argument to check
     * @return argEntry without '-'
     * @throws IllegalArgumentException when argEntry doesn't begin with '-'
     */
    protected static String checkArgEntry(final String argEntry) {
        if (argEntry.charAt(0) != '-') {
            throw new IllegalArgumentException(argEntry + " isn't reconize, argument must start with '-'");
        }

        return argEntry.substring(1);
    }

}
