/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ConfiguratorBuilder.java 2730 2008-11-07 14:32:05Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.deployme;

import org.ow2.jasmine.deployme.generated.Configuration;
import org.ow2.jasmine.deployme.generated.WebConf;
import org.ow2.jasmine.deployme.generated.Configuration.ActiveServices.Db;
import org.ow2.jasmine.deployme.generated.Configuration.ActiveServices.Discovery;
import org.ow2.jasmine.deployme.generated.Configuration.ActiveServices.Ha;
import org.ow2.jasmine.deployme.generated.Configuration.ActiveServices.Mail;
import org.ow2.jasmine.deployme.generated.Configuration.ActiveServices.Web;
import org.ow2.jasmine.deployme.generated.Configuration.ActiveServices.Ws;
import org.ow2.jasmine.deployme.utils.ServerDomain;

/**
 * This class is used to build a config from a server and its domain Server
 * parameter are prioritaty to domain parameters
 * 
 * @author Remy Bresson
 */
public class ConfiguratorBuilder {

    /**
     * The resulting configuration
     */
    protected Configuration config;

    /**
     * Build the configuration
     */
    public ConfiguratorBuilder(final ServerDomain sd) {
        Configuration config_domain = sd.getDomain().getConfiguration();
        Configuration config_server = sd.getServer().getConfiguration();

        this.config = new Configuration();

        this.setAConfig(config_domain);
        this.setAConfig(config_server);
    }

    /**
     * Get the configuration
     * 
     * @return the config
     */
    public Configuration getConfig() {
        return this.config;
    }

    /**
     * Set a configuration from the config<br>
     * TODO: Read existing parameter in ConfiguratorBuilder.config will be
     * replaced
     * 
     * @param confToRead The configuration to assign
     */
    private void setAConfig(final Configuration confToRead) {
        if (confToRead != null) {
            this.setGlobalJonas(confToRead);
            this.setProtocol(confToRead);
            this.setServices(confToRead);
            this.setSecurityManager(confToRead);
            this.setEjbClustering(confToRead);
            this.setJms(confToRead);
            this.setJdbc(confToRead);
        }
    }

    /**
     * Set the global jonas parameters
     * 
     * @param confToRead The configuration to assign
     */
    private void setGlobalJonas(final Configuration confToRead) {
        if (this.config.getGlobalJonas() == null) {
            this.config.setGlobalJonas(new Configuration.GlobalJonas());
        }

        if (confToRead.getGlobalJonas() != null) {
            if (confToRead.getGlobalJonas().getJdk() != null) {
                this.config.getGlobalJonas().setJdk(confToRead.getGlobalJonas().getJdk());
            }
            if (confToRead.getGlobalJonas().getJonasBase() != null) {
                this.config.getGlobalJonas().setJonasBase(confToRead.getGlobalJonas().getJonasBase());
            }
            if (confToRead.getGlobalJonas().getJonasName() != null) {
                this.config.getGlobalJonas().setJonasName(confToRead.getGlobalJonas().getJonasName());
            }
            if (confToRead.getGlobalJonas().getJavaOpts() != null) {
                this.config.getGlobalJonas().setJavaOpts(confToRead.getGlobalJonas().getJavaOpts());
            }
            if (confToRead.getGlobalJonas().getJonasRoot() != null) {
                this.config.getGlobalJonas().setJonasRoot(confToRead.getGlobalJonas().getJonasRoot());
            }
            if (confToRead.getGlobalJonas().getJonasVersion() != null) {
                this.config.getGlobalJonas().setJonasVersion(confToRead.getGlobalJonas().getJonasVersion());
            }
            if (confToRead.getGlobalJonas().getHost() != null) {
                this.config.getGlobalJonas().setHost(confToRead.getGlobalJonas().getHost());
            }
        }
    }

    /**
     * Set the protocol configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setProtocol(final Configuration confToRead) {
        if (this.config.getProtocols() == null) {
            this.config.setProtocols(new Configuration.Protocols());
        }

        if (confToRead.getProtocols() != null) {
            if (confToRead.getProtocols().isJndiLocalCallOptimization() != null) {
                this.config.getProtocols()
                    .setJndiLocalCallOptimization(confToRead.getProtocols().isJndiLocalCallOptimization());
            }
            if (confToRead.getProtocols().getIiopPort() != null) {
                this.config.getProtocols().setIiopPort(confToRead.getProtocols().getIiopPort());
            }
            if (confToRead.getProtocols().getIrmiPort() != null) {
                this.config.getProtocols().setIrmiPort(confToRead.getProtocols().getIrmiPort());
            }
            if (confToRead.getProtocols().getJrmpPort() != null) {
                this.config.getProtocols().setJrmpPort(confToRead.getProtocols().getJrmpPort());
            }
            if (confToRead.getProtocols().getCmiPort() != null) {
                this.config.getProtocols().setCmiPort(confToRead.getProtocols().getCmiPort());
            }
            if (confToRead.getProtocols().getProtocolsList() != null) {
                this.config.getProtocols().setProtocolsList(confToRead.getProtocols().getProtocolsList());
            }
        }
    }

    /**
     * Set the services configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setServices(final Configuration confToRead) {
        if (this.config.getActiveServices() == null) {
            this.config.setActiveServices(new Configuration.ActiveServices());
        }

        if (confToRead.getActiveServices() != null) {
            if (confToRead.getActiveServices().getNames() != null) {
                this.config.getActiveServices().setNames(confToRead.getActiveServices().getNames());
            }
            if (confToRead.getActiveServices().getWeb() != null) {
                this.setWebService(confToRead.getActiveServices().getWeb());
            }
            if (confToRead.getActiveServices().getDb() != null) {
                this.setDbService(confToRead.getActiveServices().getDb());
            }
            if (confToRead.getActiveServices().getDiscovery() != null) {
                this.setDiscoveryService(confToRead.getActiveServices().getDiscovery());
            }
            if (confToRead.getActiveServices().getMail() != null) {
                this.setMailService(confToRead.getActiveServices().getMail());
            }
            if (confToRead.getActiveServices().getWs() != null) {
                this.setWsService(confToRead.getActiveServices().getWs());
            }
            if (confToRead.getActiveServices().getHa() != null) {
                this.setHaService(confToRead.getActiveServices().getHa());
            }
        }
    }

    /**
     * Set the web configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setWebService(final Web confToRead) {
        if (this.config.getActiveServices().getWeb() == null) {
            this.config.getActiveServices().setWeb(new Configuration.ActiveServices.Web());
        }
        if (confToRead.isAjpActivated() != null) {
            this.config.getActiveServices().getWeb().setAjpActivated(confToRead.isAjpActivated());
        }
        if (confToRead.isHttpReplicationActivated() != null) {
            this.config.getActiveServices().getWeb().setHttpReplicationActivated(confToRead.isHttpReplicationActivated());
        }
        if (confToRead.isHttpsActivated() != null) {
            this.config.getActiveServices().getWeb().setHttpsActivated(confToRead.isHttpsActivated());
        }
        if (confToRead.getJvmRoute() != null) {
            this.config.getActiveServices().getWeb().setJvmRoute(confToRead.getJvmRoute());
        }

        if (this.config.getActiveServices().getWeb().getAjpConf() == null) {
            this.config.getActiveServices().getWeb().setAjpConf(new Configuration.ActiveServices.Web.AjpConf());
        }
        if (this.config.getActiveServices().getWeb().getAjpConf().getWebConf() == null) {
            this.config.getActiveServices().getWeb().getAjpConf().setWebConf(new WebConf());
        }
        if (confToRead.getAjpConf() != null) {
            if (confToRead.getAjpConf().getWebConf() != null) {
                this.buildWebConf(confToRead.getAjpConf().getWebConf(), this.config.getActiveServices().getWeb().getAjpConf()
                    .getWebConf());
            }
        }

        if (this.config.getActiveServices().getWeb().getHttpsConf() == null) {
            this.config.getActiveServices().getWeb().setHttpsConf(new Configuration.ActiveServices.Web.HttpsConf());
        }
        if (this.config.getActiveServices().getWeb().getHttpsConf().getWebConf() == null) {
            this.config.getActiveServices().getWeb().getHttpsConf().setWebConf(new WebConf());
        }
        if (confToRead.getHttpsConf() != null) {
            if (confToRead.getHttpsConf().getWebConf() != null) {
                this.buildWebConf(confToRead.getHttpsConf().getWebConf(), this.config.getActiveServices().getWeb()
                    .getHttpsConf().getWebConf());
            }
        }

        if (this.config.getActiveServices().getWeb().getHttpConf() == null) {
            this.config.getActiveServices().getWeb().setHttpConf(new Configuration.ActiveServices.Web.HttpConf());
        }
        if (this.config.getActiveServices().getWeb().getHttpConf().getWebConf() == null) {
            this.config.getActiveServices().getWeb().getHttpConf().setWebConf(new WebConf());
        }

        if (confToRead.getHttpConf() != null) {
            if (confToRead.getHttpConf().getWebConf() != null) {
                this.buildWebConf(confToRead.getHttpConf().getWebConf(), this.config.getActiveServices().getWeb().getHttpConf()
                    .getWebConf());
            }
        }

        if (this.config.getActiveServices().getWeb().getHttpReplicationConf() == null) {
            this.config.getActiveServices().getWeb().setHttpReplicationConf(
                new Configuration.ActiveServices.Web.HttpReplicationConf());
        }

        if (confToRead.getHttpReplicationConf() != null) {
            if (confToRead.getHttpReplicationConf().getClusterName() != null) {
                this.config.getActiveServices().getWeb().getHttpReplicationConf().setClusterName(
                    confToRead.getHttpReplicationConf().getClusterName());
            }
            if (confToRead.getHttpReplicationConf().getListenport() != null) {
                this.config.getActiveServices().getWeb().getHttpReplicationConf().setListenport(
                    confToRead.getHttpReplicationConf().getListenport());
            }
            if (confToRead.getHttpReplicationConf().getMcastaddre() != null) {
                this.config.getActiveServices().getWeb().getHttpReplicationConf().setMcastaddre(
                    confToRead.getHttpReplicationConf().getMcastaddre());
            }
            if (confToRead.getHttpReplicationConf().getMcastport() != null) {
                this.config.getActiveServices().getWeb().getHttpReplicationConf().setMcastport(
                    confToRead.getHttpReplicationConf().getMcastport());
            }
        }
    }

    /**
     * Set the database configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setDbService(final Db confToRead) {
        if (this.config.getActiveServices().getDb() == null) {
            this.config.getActiveServices().setDb(new Configuration.ActiveServices.Db());
        }

        if (confToRead.getPort() != null) {
            this.config.getActiveServices().getDb().setPort(confToRead.getPort());
        }
    }

    /**
     * Set the discovery service configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setDiscoveryService(final Discovery confToRead) {
        if (this.config.getActiveServices().getDiscovery() == null) {
            this.config.getActiveServices().setDiscovery(new Configuration.ActiveServices.Discovery());
        }

        if (confToRead.getGreetingPort() != null) {
            this.config.getActiveServices().getDiscovery().setGreetingPort(confToRead.getGreetingPort());
        }
        if (confToRead.isMasterActivation() != null) {
            this.config.getActiveServices().getDiscovery().setMasterActivation(confToRead.isMasterActivation());
        }
        if (confToRead.getMulticastAddress() != null) {
            this.config.getActiveServices().getDiscovery().setMulticastAddress(confToRead.getMulticastAddress());
        }
        if (confToRead.getMulticastPort() != null) {
            this.config.getActiveServices().getDiscovery().setMulticastPort(confToRead.getMulticastPort());
        }
        if (confToRead.getSourcePort() != null) {
            this.config.getActiveServices().getDiscovery().setSourcePort(confToRead.getSourcePort());
        }
        if (confToRead.getTtl() != null) {
            this.config.getActiveServices().getDiscovery().setTtl(confToRead.getTtl());
        }
    }

    /**
     * Set the mail service configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setMailService(final Mail confToRead) {
        if (this.config.getActiveServices().getMail() == null) {
            this.config.getActiveServices().setMail(new Configuration.ActiveServices.Mail());
        }

        if (confToRead.getFactoryName() != null) {
            this.config.getActiveServices().getMail().setFactoryName(confToRead.getFactoryName());
        }
        if (confToRead.getFactoryType() != null) {
            this.config.getActiveServices().getMail().setFactoryType(confToRead.getFactoryType());
        }
    }

    /**
     * Set the webservice service configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setWsService(final Ws confToRead) {
        if (this.config.getActiveServices().getWs() == null) {
            this.config.getActiveServices().setWs(new Configuration.ActiveServices.Ws());
        }

        if (confToRead.getWsdlFileDir() != null) {
            this.config.getActiveServices().getWs().setWsdlFileDir(confToRead.getWsdlFileDir());
        }
        if (confToRead.getWsdlFilename() != null) {
            this.config.getActiveServices().getWs().setWsdlFilename(confToRead.getWsdlFilename());
        }
    }

    /**
     * Set the ha service configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setHaService(final Ha confToRead) {
        if (this.config.getActiveServices().getHa() == null) {
            this.config.getActiveServices().setHa(new Configuration.ActiveServices.Ha());
        }

        if (confToRead.isHaActivated() != null) {
            this.config.getActiveServices().getHa().setHaActivated(confToRead.isHaActivated());
        }
        if (confToRead.getMulticastAddr() != null) {
            this.config.getActiveServices().getHa().setMulticastAddr(confToRead.getMulticastAddr());
        }
        if (confToRead.getMulticastPort() != null) {
            this.config.getActiveServices().getHa().setMulticastPort(confToRead.getMulticastPort());
        }
    }

    /**
     * Set the webconf configuration (http, https, ajp)
     * 
     * @param config The webconf to set
     * @param webConfToRead The web configuration to assign
     */
    private void buildWebConf(final WebConf webConfToRead, final WebConf config) {
        if (webConfToRead.getMaxSpareThreads() != null) {
            config.setMaxSpareThreads(webConfToRead.getMaxSpareThreads());
        }
        if (webConfToRead.getMaxThreads() != null) {
            config.setMaxThreads(webConfToRead.getMaxThreads());
        }
        if (webConfToRead.getMinSpareThreads() != null) {
            config.setMinSpareThreads(webConfToRead.getMinSpareThreads());
        }
        if (webConfToRead.getPort() != null) {
            config.setPort(webConfToRead.getPort());
        }
    }

    /**
     * Set the security manager configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setSecurityManager(final Configuration confToRead) {

        if (this.config.getSecurityManager() == null) {
            this.config.setSecurityManager(new Configuration.SecurityManager());
        }

        if (confToRead.getSecurityManager() != null) {

            if (confToRead.getSecurityManager().isActivation() != null) {
                this.config.getSecurityManager().setActivation(confToRead.getSecurityManager().isActivation());
            }
        }
    }

    /**
     * Set the ejb clustering configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setEjbClustering(final Configuration confToRead) {

        if (this.config.getEjbClustering() == null) {
            this.config.setEjbClustering(new Configuration.EjbClustering());
        }

        if (confToRead.getEjbClustering() != null) {
            if (confToRead.getEjbClustering().isEjbClusteringActivated() != null) {
                this.config.getEjbClustering().setEjbClusteringActivated(
                    confToRead.getEjbClustering().isEjbClusteringActivated());
            }
            if (confToRead.getEjbClustering().getMulticastAddr() != null) {
                this.config.getEjbClustering().setMulticastAddr(confToRead.getEjbClustering().getMulticastAddr());
            }
            if (confToRead.getEjbClustering().getMulticastPort() != null) {
                this.config.getEjbClustering().setMulticastPort(confToRead.getEjbClustering().getMulticastPort());
            }
        }
    }

    /**
     * Set the jms configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setJms(final Configuration confToRead) {

        if (this.config.getJms() == null) {
            this.config.setJms(new Configuration.Jms());
        }

        if (confToRead.getJms() != null) {
            if (confToRead.getJms().getPort() != null) {
                this.config.getJms().setPort(confToRead.getJms().getPort());
            }
            if (confToRead.getJms().getQueue() != null) {
                this.config.getJms().setQueue(confToRead.getJms().getQueue());
            }
            if (confToRead.getJms().getTopic() != null) {
                this.config.getJms().setTopic(confToRead.getJms().getTopic());
            }
        }
    }

    /**
     * Set the jdbc configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setJdbc(final Configuration confToRead) {

        if (this.config.getJdbc() == null) {
            this.config.setJdbc(new Configuration.Jdbc());
        }

        if (confToRead.getJdbc() != null) {

            if (confToRead.getJdbc().getDrivers() != null) {
                this.config.getJdbc().setDrivers(confToRead.getJdbc().getDrivers());
            }
            if (confToRead.getJdbc().getDsClass() != null) {
                this.config.getJdbc().setDsClass(confToRead.getJdbc().getDsClass());
            }
            if (confToRead.getJdbc().getRaName() != null) {
                this.config.getJdbc().setRaName(confToRead.getJdbc().getRaName());
            }
            if (confToRead.getJdbc().getJdbcCheckLevel() != null) {
                this.config.getJdbc().setJdbcCheckLevel(confToRead.getJdbc().getJdbcCheckLevel());
            }
            if (confToRead.getJdbc().getJdbcTestStatment() != null) {
                this.config.getJdbc().setJdbcTestStatment(confToRead.getJdbc().getJdbcTestStatment());
            }
            if (confToRead.getJdbc().getJndiname() != null) {
                this.config.getJdbc().setJndiname(confToRead.getJdbc().getJndiname());
            }
            if (confToRead.getJdbc().getMappername() != null) {
                this.config.getJdbc().setMappername(confToRead.getJdbc().getMappername());
            }
            if (confToRead.getJdbc().getPassword() != null) {
                this.config.getJdbc().setPassword(confToRead.getJdbc().getPassword());
            }
            if (confToRead.getJdbc().getRarlink() != null) {
                this.config.getJdbc().setRarlink(confToRead.getJdbc().getRarlink());
            }
            if (confToRead.getJdbc().getUrl() != null) {
                this.config.getJdbc().setUrl(confToRead.getJdbc().getUrl());
            }
            if (confToRead.getJdbc().getUser() != null) {
                this.config.getJdbc().setUser(confToRead.getJdbc().getUser());
            }

            if (this.config.getJdbc().getPoolParameters() == null) {
                this.config.getJdbc().setPoolParameters(new Configuration.Jdbc.PoolParameters());
            }
            this.config.getJdbc().getPoolParameters().setPoolInit(confToRead.getJdbc().getPoolParameters().getPoolInit());
            this.config.getJdbc().getPoolParameters().setPoolMax(confToRead.getJdbc().getPoolParameters().getPoolMax());
            this.config.getJdbc().getPoolParameters().setPoolMaxAgeMinutes(
                confToRead.getJdbc().getPoolParameters().getPoolMaxAgeMinutes());
            this.config.getJdbc().getPoolParameters().setPoolMaxOpentime(
                confToRead.getJdbc().getPoolParameters().getPoolMaxOpentime());
            this.config.getJdbc().getPoolParameters().setPoolMaxWaiters(
                confToRead.getJdbc().getPoolParameters().getPoolMaxWaiters());
            this.config.getJdbc().getPoolParameters().setPoolMaxWaittime(
                confToRead.getJdbc().getPoolParameters().getPoolMaxWaittime());
            this.config.getJdbc().getPoolParameters().setPoolMin(confToRead.getJdbc().getPoolParameters().getPoolMin());
            this.config.getJdbc().getPoolParameters().setPoolSamplingPeriod(
                confToRead.getJdbc().getPoolParameters().getPoolSamplingPeriod());
            this.config.getJdbc().getPoolParameters().setPstmtMax(confToRead.getJdbc().getPoolParameters().getPstmtMax());
        }
    }
}
