/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CommandLine.java 2672 2008-10-23 15:42:43Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.deployme.utils;

/**
 * Represent the command line arguments
 * 
 * @author Remy Bresson
 */
public class CommandLine {

    /**
     * key word to define server name on the command line. Use associated with
     * addValue()
     */
    public static String commandLineServerName = "serverName";

    /**
     * key word to define domain name on the command line. Use associated with
     * addValue()
     */
    public static String commandLineDomainName = "domainName";

    /**
     * key word to define host name on the command line. Use associated with
     * addValue()
     */
    public static String commandLineHostName = "hostName";

    /**
     * key word to define cluster name on the command line. Use associated with
     * addValue()
     */
    public static String commandLineClusterName = "clusterName";

    /**
     * key word to define topology file name on the command line. Use associated
     * with addValue()
     */
    public static String commandLinetopologyFileName = "topologyFile";

    /**
     * Toplogy file path
     */
    protected String topologyFile;

    /**
     * Server name
     */
    protected String serverName;

    /**
     * Domain name
     */
    protected String domainName;

    /**
     * Host name
     */
    protected String hostName;

    /**
     * Cluster name
     */
    protected String clusterName;

    /**
     * Default constructor
     */
    public CommandLine() {
        this.topologyFile = null;
        this.serverName = null;
        this.domainName = null;
        this.hostName = null;
    }

    /**
     * return the topologyFile
     * 
     * @return the topologyFile
     */
    public String getTopologyFile() {
        return this.topologyFile;
    }

    /**
     * return the serverName
     * 
     * @return the serverName
     */
    public String getServerName() {
        return this.serverName;
    }

    /**
     * return the domainName
     * 
     * @return the domainName
     */
    public String getDomainName() {
        return this.domainName;
    }

    /**
     * return the hostName
     * 
     * @return the hostName
     */
    public String getHostName() {
        return this.hostName;
    }

    /**
     * @return the clusterName
     */
    public String getClusterName() {
        return this.clusterName;
    }

    /**
     * Record a value of the command line.
     * 
     * @param argName Name of the value to record
     * @param argValue Value to record
     */
    public void addValue(final String argName, final String argValue) {
        if (argName.compareTo(CommandLine.commandLineServerName) == 0) {
            this.serverName = argValue;
        } else if (argName.compareTo(CommandLine.commandLineDomainName) == 0) {
            this.domainName = argValue;
        } else if (argName.compareTo(CommandLine.commandLinetopologyFileName) == 0) {
            this.topologyFile = argValue;
        } else if (argName.compareTo(CommandLine.commandLineHostName) == 0) {
            this.hostName = argValue;
        } else if (argName.compareTo(CommandLine.commandLineClusterName) == 0) {
            this.clusterName = argValue;
        } else {
            throw new IllegalArgumentException(argName + " isn't reconize");
        }
    }

    /**
     * Check if the command line contains all what we need
     */
    public void checkCommandLine() {
        if (this.topologyFile == null) {
            throw new IllegalArgumentException("topologyFile not set!");
        }

        if (this.domainName != null) {
            if (this.serverName != null) {
                if (this.clusterName != null) {
                    throw new IllegalArgumentException("domainName and serverName are set, clusterName must not be set");
                } else {
                    if (this.hostName != null) {
                        throw new IllegalArgumentException("domainName and serverName are set, hostName must not be set");
                    } else {
                        // OK : usage domain.server
                    }
                }
            } else { // server == null
                if (this.clusterName != null) {
                    if (this.hostName != null) {
                        throw new IllegalArgumentException("domainName and clusterName are set, hostName must not be set");
                    } else {
                        // OK : usage domain.cluster
                    }
                } else {
                    if (this.hostName != null) {
                        throw new IllegalArgumentException("domainName is set, hostName must not be set");
                    } else {
                        throw new IllegalArgumentException("domainName is set, serverName or clusterName must also be set");
                    }
                }
            }
        } else { // domain == null
            if (this.serverName != null) {
                throw new IllegalArgumentException("serverName is set, domainName must also be set");
            } else { // server == null
                if (this.clusterName != null) {
                    throw new IllegalArgumentException("clusterName is set, domainName must also be set");
                } else {
                    if (this.hostName != null) {
                        // OK : utilisation hostame
                    } else {
                        throw new IllegalArgumentException(
                            "no options set. set domainName, clusterName, serverName or hostName");
                    }
                }
            }
        }
    }
}
