/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme.utils;

public class CommandLine {
    public static String ERROR_TOPOLOGY_NOT_SET = "You must set the 'topologyFile' option in order to use Deploy ME";
    public static String ERROR_CLUSTER_DOMAIN_SERVER = "The 'clusterName' option must not be set when the 'domainName' and 'serverName' options are set";
    public static String ERROR_MACHINE_DOMAIN_SERVER = "The 'machineName' option must not be set when the 'domainName' and 'serverName' options are set";
    public static String ERROR_MACHINE_DOMAIN_CLUSTER = "The 'machineName' option must not be set when the 'domainName' and 'clusterName' options are set";
    public static String ERROR_MACHINE_DOMAIN = "The 'machineName' option must not be set when the 'domainName' option is set";
    public static String ERROR_SERVER_CLUSTER_DOMAIN = "The 'serverName' or 'clusterName' options must be set when the 'domainName' option is set";
    public static String ERROR_DOMAIN_SERVER = "The 'domainName' option must be set when the 'serverName' option is set";
    public static String ERROR_DOMAIN_CLUSTER = "The 'domainName' option must be set when the 'clusterName' option is set";
    public static String ERROR_NO_OPTIONS = "No options set. You must set one of the 'machineName', 'domainName', 'clusterName' or 'serverName' options in order to use Deploy ME";
    public static String commandLineServerName = "serverName";
    public static String commandLineDomainName = "domainName";
    public static String commandLineMachineName = "machineName";
    public static String commandLineClusterName = "clusterName";
    public static String commandLinetopologyFileName = "topologyFile";
    protected String topologyFile = null;
    protected String serverName = null;
    protected String domainName = null;
    protected String machineName = null;
    protected String clusterName;

    public String getTopologyFile() {
        return this.topologyFile;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void addValue(String argName, String argValue) {
        if (argName.compareTo(commandLineServerName) == 0) {
            this.serverName = argValue;
        } else if (argName.compareTo(commandLineDomainName) == 0) {
            this.domainName = argValue;
        } else if (argName.compareTo(commandLinetopologyFileName) == 0) {
            this.topologyFile = argValue;
        } else if (argName.compareTo(commandLineMachineName) == 0) {
            this.machineName = argValue;
        } else if (argName.compareTo(commandLineClusterName) == 0) {
            this.clusterName = argValue;
        } else {
            throw new IllegalArgumentException("'" + argName + "' is not a valid JASMINe Deploy ME option.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void checkCommandLine() {
        block12: {
            block13: {
                if (this.domainName == null) break block13;
                if (this.serverName != null) {
                    if (this.clusterName != null) {
                        throw new IllegalArgumentException(ERROR_CLUSTER_DOMAIN_SERVER);
                    }
                    if (this.machineName != null) {
                        throw new IllegalArgumentException(ERROR_MACHINE_DOMAIN_SERVER);
                    }
                    break block12;
                } else if (this.clusterName != null) {
                    if (this.machineName != null) {
                        throw new IllegalArgumentException(ERROR_MACHINE_DOMAIN_CLUSTER);
                    }
                    break block12;
                } else {
                    if (this.machineName != null) {
                        throw new IllegalArgumentException(ERROR_MACHINE_DOMAIN);
                    }
                    throw new IllegalArgumentException(ERROR_SERVER_CLUSTER_DOMAIN);
                }
            }
            if (this.serverName != null) {
                throw new IllegalArgumentException(ERROR_DOMAIN_SERVER);
            }
            if (this.clusterName != null) {
                throw new IllegalArgumentException(ERROR_DOMAIN_CLUSTER);
            }
            if (this.machineName == null && this.topologyFile == null) {
                throw new IllegalArgumentException(ERROR_NO_OPTIONS);
            }
        }
        if (this.topologyFile == null) {
            throw new IllegalArgumentException(ERROR_TOPOLOGY_NOT_SET);
        }
    }
}

