/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ConfigJonasApply.java 2730 2008-11-07 14:32:05Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.deployme.configApply;

import org.ow2.jasmine.deployme.generated.Configuration.ActiveServices;
import org.ow2.jasmine.deployme.generated.Configuration.EjbClustering;
import org.ow2.jasmine.deployme.generated.Configuration.GlobalJonas;
import org.ow2.jasmine.deployme.generated.Configuration.Jdbc;
import org.ow2.jasmine.deployme.generated.Configuration.Jms;
import org.ow2.jasmine.deployme.generated.Configuration.Protocols;
import org.ow2.jasmine.deployme.generated.Configuration.SecurityManager;
import org.ow2.jasmine.deployme.generated.Configuration.ActiveServices.Web;
import org.ow2.jasmine.deployme.generated.Configuration.ActiveServices.Web.AjpConf;
import org.ow2.jasmine.deployme.generated.Configuration.ActiveServices.Web.HttpConf;
import org.ow2.jasmine.deployme.generated.Configuration.ActiveServices.Web.HttpReplicationConf;
import org.ow2.jasmine.deployme.generated.Configuration.ActiveServices.Web.HttpsConf;
import org.ow2.jasmine.deployme.generated.Configuration.Jdbc.PoolParameters;
import org.ow2.jonas.tools.configurator.Jonas;
import org.ow2.jonas.tools.configurator.api.JonasConfigurator;

/**
 * Apply a configuration on a Jonas server
 * 
 * @author Remy Bresson
 */
public class ConfigJonasApply {

    /**
     * The jonas configurator
     */
    private JonasConfigurator jonasConf;

    /**
     * Constructor
     */
    public ConfigJonasApply(final String jonasRoot) {
        Jonas jonas = new Jonas(jonasRoot);
        this.jonasConf = jonas.getJonasConfigurator();
    }

    /**
     * Apply the jonas global parameters
     * 
     * @param domainName Domain name.
     * @param globalJonas The global parameters
     */
    public void setGlobalJonas(final String domainName, final GlobalJonas globalJonas) {
        if (globalJonas.getJdk() != null) {
            this.jonasConf.setJdk(globalJonas.getJdk());
        }
        if (globalJonas.getJavaOpts() != null) {
            this.jonasConf.setJavaOpts(globalJonas.getJavaOpts());
        }
        if (globalJonas.getJonasBase() != null) {
            this.jonasConf.setJonasBase(globalJonas.getJonasBase());
        }
        if (globalJonas.getJonasVersion() != null) {
            this.jonasConf.setJonasVersion(globalJonas.getJonasVersion());
        }
        if (globalJonas.getJonasName() != null) {
            this.jonasConf.setJonasName(globalJonas.getJonasName());
        }
        this.jonasConf.setJonasDomain(domainName);
        this.jonasConf.setDiscoveryDomainName(domainName);
        if (globalJonas.getHost() != null) {
            this.jonasConf.setHost(globalJonas.getHost());
        }
    }

    /**
     * Apply the protocols parameters
     * 
     * @param protocols The protocols parameters
     */
    public void setProtocols(final Protocols protocols) {
        if (protocols.getIrmiPort() != null) {
            this.jonasConf.setProtocolsIrmiPort(protocols.getIrmiPort().toString());
        }
        if (protocols.getIiopPort() != null) {
            this.jonasConf.setProtocolsIiopPort(protocols.getIiopPort().toString());
        }
        if (protocols.getJrmpPort() != null) {
            this.jonasConf.setProtocolsJrmpPort(protocols.getJrmpPort().toString());
        }
        if (protocols.getCmiPort() != null) {
            this.jonasConf.setProtocolsCmiPort(protocols.getCmiPort().toString());
        }
        if (protocols.getProtocolsList() != null) {
            this.jonasConf.setProtocolsList(protocols.getProtocolsList());
        }

        if (protocols.isJndiLocalCallOptimization() != null) {
            this.jonasConf.setProtocolsLocalCallOptimized(protocols.isJndiLocalCallOptimization());
        }
    }

    /**
     * Apply the services parameters
     * 
     * @param activeServices The services parameters
     */
    public void setActiveServices(final ActiveServices activeServices) {
        if (activeServices.getNames() != null) {
            this.jonasConf.setServices(activeServices.getNames());
        }
        if (activeServices.getWeb() != null) {
            this.setServiceWeb(activeServices.getWeb());
        }
        if (activeServices.getDb() != null) {
            this.setServiceDb(activeServices.getDb());
        }
        if (activeServices.getDiscovery() != null) {
            this.setServiceDiscovery(activeServices.getDiscovery());
        }
        if (activeServices.getMail() != null) {
            this.setServiceMail(activeServices.getMail());
        }
        if (activeServices.getWs() != null) {
            this.setServiceWs(activeServices.getWs());
        }
        if (activeServices.getHa() != null) {
            this.setServiceHa(activeServices.getHa());
        }
    }

    /**
     * Apply the security manager parameters
     * 
     * @param securityManager The security manager parameters
     */
    public void setSecurityManager(final SecurityManager securityManager) {
        if (securityManager.isActivation() != null) {
            this.jonasConf.setSecurityManagerActivation(securityManager.isActivation());
        }
    }

    /**
     * Apply the ejb clustering parameters
     * 
     * @param ejbClustering The ejb clustering parameters
     */
    public void setEjbClusteringConfiguration(final EjbClustering ejbClustering) {
        if (ejbClustering.isEjbClusteringActivated() != null) {
            this.jonasConf.setEjbClusteringActivated(ejbClustering.isEjbClusteringActivated());
        }
        if (ejbClustering.getMulticastAddr() != null) {
            this.jonasConf.setEjbClusteringMulticastAddr(ejbClustering.getMulticastAddr());
        }
        if (ejbClustering.getMulticastPort() != null) {
            this.jonasConf.setEjbClusteringMulticastPort(ejbClustering.getMulticastPort().toString());
        }
    }

    /**
     * Apply the jms parameters
     * 
     * @param jms The jms parameters
     */
    public void setJmsConfiguration(final Jms jms) {
        if (jms.getPort() != null) {
            this.jonasConf.setJmsPort(jms.getPort().toString());
        }
        if (jms.getQueue() != null) {
            this.jonasConf.setJmsQueue(jms.getQueue());
        }
        if (jms.getTopic() != null) {
            this.jonasConf.setJmsTopic(jms.getTopic());
        }
    }

    /**
     * Apply the jdbc parameters
     * 
     * @param jdbc The jdbc parameters
     */
    public void setJdbcConfiguration(final Jdbc jdbc) {
        if (jdbc.getDrivers() != null) {
            this.jonasConf.setJdbcDrivers(jdbc.getDrivers());
        }
        if (jdbc.getDsClass() != null) {
            this.jonasConf.setJdbcDsClass(jdbc.getDsClass());
        }
        if (jdbc.getRaName() != null) {
            this.jonasConf.setJdbcRaName(jdbc.getRaName());
        }
        if (jdbc.getJdbcCheckLevel() != null) {
            this.jonasConf.setJdbcCheckLevel(jdbc.getJdbcCheckLevel());
        }
        if (jdbc.getJdbcTestStatment() != null) {
            this.jonasConf.setJdbcTestStatement(jdbc.getJdbcTestStatment());
        }
        if (jdbc.getJndiname() != null) {
            this.jonasConf.setJdbcJndiname(jdbc.getJndiname());
        }
        if (jdbc.getMappername() != null) {
            this.jonasConf.setJdbcMappername(jdbc.getMappername());
        }
        if (jdbc.getPassword() != null) {
            this.jonasConf.setJdbcPassword(jdbc.getPassword());
        }
        if (jdbc.getRarlink() != null) {
            this.jonasConf.setJdbcRarlink(jdbc.getRarlink());
        }
        if (jdbc.getUrl() != null) {
            this.jonasConf.setJdbcUrl(jdbc.getUrl());
        }
        if (jdbc.getUser() != null) {
            this.jonasConf.setJdbcUser(jdbc.getUser());
        }
        if (jdbc.getPoolParameters() != null) {

            this.setJdbcPoolParameters(jdbc.getPoolParameters());
        }
    }

    /**
     * Apply the jdbc pool parameters
     * 
     * @param params The pool parameters
     */
    protected void setJdbcPoolParameters(final PoolParameters params) {
        if (params.getPoolInit() != null) {
            this.jonasConf.setJdbcPoolInit(params.getPoolInit().toString());
        }
        if (params.getPoolMax() != null) {
            this.jonasConf.setJdbcPoolMax(params.getPoolMax().toString());
        }
        if (params.getPoolMaxAgeMinutes() != null) {
            this.jonasConf.setJdbcPoolMaxAgeMinutes(params.getPoolMaxAgeMinutes().toString());
        }
        if (params.getPoolMaxOpentime() != null) {
            this.jonasConf.setJdbcPoolMaxOpentime(params.getPoolMaxOpentime().toString());
        }
        if (params.getPoolMaxWaiters() != null) {
            this.jonasConf.setJdbcPoolMaxWaiters(params.getPoolMaxWaiters().toString());
        }
        if (params.getPoolMaxWaittime() != null) {
            this.jonasConf.setJdbcPoolMaxWaittime(params.getPoolMaxWaittime().toString());
        }
        if (params.getPoolMin() != null) {
            this.jonasConf.setJdbcPoolMin(params.getPoolMin().toString());
        }
        if (params.getPoolSamplingPeriod() != null) {
            this.jonasConf.setJdbcPoolSamplingPeriod(params.getPoolSamplingPeriod().toString());
        }
        if (params.getPstmtMax() != null) {
            this.jonasConf.setJdbcPoolPstmtMax(params.getPstmtMax().toString());
        }
    }

    /**
     * Apply the ha service parameters
     * 
     * @param ha The ha service parameters
     */
    public void setServiceHa(final ActiveServices.Ha ha) {
        if (ha.isHaActivated() != null) {
            this.jonasConf.setHaActivated(ha.isHaActivated());
        }
        if (ha.getMulticastAddr() != null) {
            this.jonasConf.setHaMulticastAddr(ha.getMulticastAddr());
        }
        if (ha.getMulticastPort() != null) {
            this.jonasConf.setHaMulticastPort(ha.getMulticastPort().toString());
        }
    }

    /**
     * Apply the webservice service parameters
     * 
     * @param ws The webservice service parameters
     */
    public void setServiceWs(final ActiveServices.Ws ws) {
        if (ws.getWsdlFileDir() != null) {
            this.jonasConf.setWSDLFileDir(ws.getWsdlFileDir());
        }
        if (ws.getWsdlFilename() != null) {
            this.jonasConf.setWSDLFileName(ws.getWsdlFilename());
        }
    }

    /**
     * Apply the mail service parameters
     * 
     * @param mail The mail service parameters
     */
    public void setServiceMail(final ActiveServices.Mail mail) {
        if (mail.getFactoryName() != null) {
            this.jonasConf.setMailFactoryName(mail.getFactoryName());
        }
        if (mail.getFactoryType() != null) {
            this.jonasConf.setMailFactoryType(mail.getFactoryType());
        }
    }

    /**
     * Apply the discovery service parameters
     * 
     * @param discovery The discovery service parameters
     */
    public void setServiceDiscovery(final ActiveServices.Discovery discovery) {
        if (discovery.isMasterActivation() != null) {
            this.jonasConf.setDiscoveryMasterActivated(discovery.isMasterActivation());
        }
        if (discovery.getGreetingPort() != null) {
            this.jonasConf.setDiscoveryGreetingPort(discovery.getGreetingPort().toString());
        }
        if (discovery.getMulticastAddress() != null) {
            this.jonasConf.setDiscoveryMulticastAddress(discovery.getMulticastAddress());
        }
        if (discovery.getMulticastPort() != null) {
            this.jonasConf.setDiscoveryMulticastPort(discovery.getMulticastPort().toString());
        }
        if (discovery.getSourcePort() != null) {
            this.jonasConf.setDiscoverySourcePort(discovery.getSourcePort().toString());
        }
        if (discovery.getTtl() != null) {
            this.jonasConf.setDiscoveryTtl(discovery.getTtl());
        }
    }

    /**
     * Apply the db service parameters
     * 
     * @param db The db service parameters
     */
    public void setServiceDb(final ActiveServices.Db db) {
        if (db.getPort() != null) {
            this.jonasConf.setDbPort(db.getPort().toString());
        }
    }

    /**
     * Apply the web parameters
     * 
     * @param web The web parameters
     */
    protected void setServiceWeb(final Web web) {
        if (web.isAjpActivated() != null) {
            this.jonasConf.setAjpConnectorActivation(web.isAjpActivated());
        }
        if (web.isHttpReplicationActivated() != null) {
            this.jonasConf.setHttpSessionReplicationActivation(web.isHttpReplicationActivated());
        }
        if (web.isHttpsActivated() != null) {
            this.jonasConf.setHttpsConnectorActivation(web.isHttpsActivated());
        }
        if (web.getJvmRoute() != null) {
            this.jonasConf.setJvmRoute(web.getJvmRoute());
        }
        if (web.getAjpConf() != null) {

            this.setAjpConf(web.getAjpConf());
        }
        if (web.getHttpConf() != null) {
            this.setHttpConf(web.getHttpConf());
        }
        if (web.getHttpReplicationConf() != null) {
            this.setHttpReplicationConf(web.getHttpReplicationConf());
        }
        if (web.getHttpsConf() != null) {
            this.setHttpsConf(web.getHttpsConf());
        }
    }

    /**
     * Apply the ajp parameters
     * 
     * @param ajpConf The ajp parameters
     */
    protected void setAjpConf(final AjpConf ajpConf) {
        if (ajpConf.getWebConf().getMaxSpareThreads() != null) {
            this.jonasConf.setAjpMaxSpareThreads(ajpConf.getWebConf().getMaxSpareThreads().toString());
        }
        if (ajpConf.getWebConf().getMaxThreads() != null) {
            this.jonasConf.setAjpMaxThreads(ajpConf.getWebConf().getMaxThreads().toString());
        }
        if (ajpConf.getWebConf().getMinSpareThreads() != null) {
            this.jonasConf.setAjpMinSpareThreads(ajpConf.getWebConf().getMinSpareThreads().toString());
        }
        if (ajpConf.getWebConf().getPort() != null) {
            this.jonasConf.setAjpPort(ajpConf.getWebConf().getPort().toString());
        }
    }

    /**
     * Apply the http parameters
     * 
     * @param httpConf The http parameters
     */
    protected void setHttpConf(final HttpConf httpConf) {
        if (httpConf.getWebConf().getMaxSpareThreads() != null) {
            this.jonasConf.setHttpMaxSpareThreads(httpConf.getWebConf().getMaxSpareThreads().toString());
        }
        if (httpConf.getWebConf().getMaxThreads() != null) {
            this.jonasConf.setHttpMaxThreads(httpConf.getWebConf().getMaxThreads().toString());
        }
        if (httpConf.getWebConf().getMinSpareThreads() != null) {
            this.jonasConf.setHttpMinSpareThreads(httpConf.getWebConf().getMinSpareThreads().toString());
        }
        if (httpConf.getWebConf().getPort() != null) {
            this.jonasConf.setHttpPort(httpConf.getWebConf().getPort().toString());
        }
    }

    /**
     * Apply the http replication parameters
     * 
     * @param httpReplicationConf The http replication parameters
     */
    protected void setHttpReplicationConf(final HttpReplicationConf httpReplicationConf) {
        if (httpReplicationConf.getClusterName() != null) {
            this.jonasConf.setHttpReplicationClusterName(httpReplicationConf.getClusterName());
        }
        if (httpReplicationConf.getListenport() != null) {
            this.jonasConf.setHttpReplicationListenPort(httpReplicationConf.getListenport().toString());
        }
        if (httpReplicationConf.getMcastaddre() != null) {
            this.jonasConf.setHttpReplicationMCastAddr(httpReplicationConf.getMcastaddre());
        }
        if (httpReplicationConf.getMcastport() != null) {
            this.jonasConf.setHttpReplicationMCastPort(httpReplicationConf.getMcastport().toString());
        }
    }

    /**
     * Apply the https parameters
     * 
     * @param httpsConf The https parameters
     */
    protected void setHttpsConf(final HttpsConf httpsConf) {
        if (httpsConf.getWebConf().getMaxSpareThreads() != null) {
            this.jonasConf.setHttpsMaxSpareThreads(httpsConf.getWebConf().getMaxSpareThreads().toString());
        }
        if (httpsConf.getWebConf().getMaxThreads() != null) {
            this.jonasConf.setHttpsMaxThreads(httpsConf.getWebConf().getMaxThreads().toString());
        }
        if (httpsConf.getWebConf().getMinSpareThreads() != null) {
            this.jonasConf.setHttpsMinSpareThreads(httpsConf.getWebConf().getMinSpareThreads().toString());
        }
        if (httpsConf.getWebConf().getPort() != null) {
            this.jonasConf.setHttpsPort(httpsConf.getWebConf().getPort().toString());
        }
    }

    /**
     * Apply the configuration
     */
    public void execute() {
        this.jonasConf.execute();
    }

}
