/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme;

import java.io.File;
import java.net.URL;
import org.ow2.jasmine.deployme.DeployMe;
import org.ow2.jasmine.deployme.utils.CommandLine;

public class CommandLineParser {
    public static void main(String[] args) {
        try {
            if (args == null || args.length < 1) {
                throw new IllegalArgumentException("You have launched JASMINe Deploy ME without any arguments.\n\nTo use JASMINe Deploy ME, you must first create a topology file that describes\nyour server infrastructure. Please refer to the JASMINe Deploy ME XSD file for\ndetails or use JASMINe Mapping utility to create a topology file based on a\nJASMINe Design file.\n\nOnce you have specified the topologyFile option, you can deploy:\n\n    - All servers on a given machine. For that, use the machineName option.\n    - A cluster daemon. For that, use the domainName and clusterName options.\n    - A server. For that, use the domainName and serverName options.");
            }
            CommandLine command = CommandLineParser.parseCommandLine(args);
            File topologyFile = new File(command.getTopologyFile());
            URL urlXML = topologyFile.isFile() ? topologyFile.toURI().toURL() : CommandLineParser.class.getClassLoader().getResource(command.getTopologyFile());
            if (urlXML == null) {
                throw new IllegalArgumentException("Cannot find the specified topology file: '" + command.getTopologyFile() + "'");
            }
            new DeployMe(urlXML, command.getMachineName(), command.getDomainName(), command.getServerName(), command.getClusterName());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            if (e.getMessage() == null) {
                e.printStackTrace();
            }
            System.exit(-1);
        }
    }

    protected static CommandLine parseCommandLine(String[] args) {
        CommandLine ret = new CommandLine();
        for (String tmp : args) {
            String argEntry = CommandLineParser.checkArgEntry(tmp);
            String[] argsSeparated = argEntry.split("=");
            if (argsSeparated.length != 2) {
                throw new IllegalArgumentException("The argument '" + argEntry + "' doesn't have a valid syntax, an argument must contain one and only one '='");
            }
            ret.addValue(argsSeparated[0], argsSeparated[1]);
        }
        ret.checkCommandLine();
        return ret;
    }

    protected static String checkArgEntry(String argEntry) {
        if (argEntry.charAt(0) != '-') {
            throw new IllegalArgumentException("The argument '" + argEntry + "' doesn't have a valid syntax, an argument must start with '-'");
        }
        return argEntry.substring(1);
    }
}

