/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme.configApply;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.ow2.jasmine.deployme.configApply.ConfigClusterApply;
import org.ow2.jasmine.deployme.configApply.ConfigJonasApply;
import org.ow2.jasmine.deployme.generated.Configuration;
import org.ow2.jasmine.deployme.generated.Topology;
import org.ow2.jasmine.deployme.utils.ServerDomain;

public class Configurator {
    protected static Logger logger = Logger.getLogger(Configurator.class);

    public static void rmdir(File directory) {
        if (directory != null) {
            if (directory.isDirectory()) {
                for (File element : directory.listFiles()) {
                    if (element.isDirectory()) {
                        Configurator.rmdir(element);
                        continue;
                    }
                    element.delete();
                }
            }
            directory.delete();
        }
    }

    public static void setClusterAConfiguration(String domainName, Topology.Domains.Domain.ClusterDaemons.ClusterDaemon cluster, String jonasRoot) {
        logger.info("Starting configuration set up for cluster " + cluster.getName() + " in directory " + cluster.getJonasBasePrefix());
        if (cluster.getJonasBasePrefix() != null) {
            Configurator.rmdir(new File(cluster.getJonasBasePrefix()));
        }
        cluster.setJonasRoot(jonasRoot);
        ConfigClusterApply apply = new ConfigClusterApply(jonasRoot);
        apply.setClusterConf(domainName, cluster);
        apply.execute();
        Configurator.createScripts(cluster.getJavaHome(), null, cluster.getJonasRoot(), cluster.getJonasBasePrefix(), domainName, cluster.getName());
        logger.info("Cluster " + cluster.getName() + " configured successfully");
    }

    public static void setClusterAConfiguration(String domainName, Topology.Domains.Domain.ClusterDaemons.ClusterDaemon cluster) {
        if (cluster.getJonasRoot() == null) {
            throw new IllegalArgumentException("The topology file doesn't define any JONAS_ROOT");
        }
        Configurator.setClusterAConfiguration(domainName, cluster, cluster.getJonasRoot());
    }

    public static void setAConfiguration(Configuration config, ServerDomain sd, String jonasRoot) {
        logger.info("Starting configuration set up for server " + sd + " in directory " + config.getGlobalJonas().getJonasBase());
        if (config.getGlobalJonas() != null) {
            config.getGlobalJonas().setJonasRoot(jonasRoot);
            if (config.getGlobalJonas().getJonasBase() != null) {
                Configurator.rmdir(new File(config.getGlobalJonas().getJonasBase()));
            }
        }
        ConfigJonasApply apply = new ConfigJonasApply(jonasRoot);
        apply.setGlobalJonas(sd.getServer().getName(), sd.getDomain().getName(), config.getGlobalJonas());
        apply.setProtocols(config.getProtocols());
        apply.setActiveServices(config.getActiveServices());
        apply.setSecurityManager(config.getSecurityManager());
        apply.setEjbClusteringConfiguration(config.getEjbClustering());
        apply.setJmsConfiguration(config.getJms());
        apply.setJdbcConfiguration(config.getJdbc());
        apply.execute();
        Configurator.createScripts(config.getGlobalJonas().getJdk(), config.getGlobalJonas().getJavaOpts(), config.getGlobalJonas().getJonasRoot(), config.getGlobalJonas().getJonasBase(), sd.getDomain().getName(), sd.getServer().getName());
        logger.info("Server " + sd + " configured successfully");
    }

    public static void setAConfiguration(Configuration config, ServerDomain sd) {
        if (config.getGlobalJonas() == null || config.getGlobalJonas().getJonasRoot() == null) {
            throw new IllegalArgumentException("The topology file doesn't define any JONAS_ROOT");
        }
        Configurator.setAConfiguration(config, sd, config.getGlobalJonas().getJonasRoot());
    }

    private static void createScripts(String javaHome, String javaOpts, String jonasRoot, String jonasBase, String jonasDomain, String jonasName) {
        if (javaOpts == null) {
            javaOpts = "";
        }
        if (jonasName == null) {
            jonasName = "jonas";
        }
        if (jonasDomain == null) {
            jonasDomain = "jonas";
        }
        try {
            File f = new File(jonasBase, "setenv.bat");
            FileWriter fw = new FileWriter(f, false);
            if (javaHome != null) {
                fw.write("SET JAVA_HOME=" + javaHome + "\r\n");
            }
            fw.write("SET JAVA_OPTS=" + javaOpts + "\r\n\r\n");
            fw.write("SET JONAS_ROOT=" + jonasRoot + "\r\n");
            fw.write("SET JONAS_BASE=" + jonasBase + "\r\n");
            fw.write("SET JONAS_OPTS=%JONAS_OPTS% -Djonas.name=" + jonasName + " -Ddomain.name=" + jonasDomain + "\r\n");
            fw.write("SET PATH=" + jonasRoot + "\\bin;" + jonasRoot + "\\bin\\nt;%PATH%\r\n");
            fw.close();
            f = new File(jonasBase, "setenv");
            fw = new FileWriter(f, false);
            fw.write("#!/bin/sh\n");
            if (javaHome != null) {
                fw.write("JAVA_HOME=" + javaHome + "\n");
                fw.write("export JAVA_HOME\n");
            }
            fw.write("JAVA_OPTS=" + javaOpts + "\n");
            fw.write("export JAVA_OPTS\n\n");
            fw.write("JONAS_ROOT=" + jonasRoot + "\n");
            fw.write("export JONAS_ROOT\n");
            fw.write("JONAS_BASE=" + jonasBase + "\n");
            fw.write("export JONAS_BASE\n");
            fw.write("JONAS_OPTS=$JONAS_OPTS -Djonas.name=" + jonasName + " -Ddomain.name=" + jonasDomain + "\n");
            fw.write("export JONAS_OPTS\n");
            fw.write("PATH=" + jonasRoot + "/bin:" + jonasRoot + "/bin/unix:$PATH\n");
            fw.write("export PATH\n");
            fw.close();
            try {
                Runtime.getRuntime().exec("chmod a+x " + f.getAbsolutePath());
            }
            catch (IOException ignored) {}
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot write the scripts", e);
        }
    }
}

