/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: XmlLoader.java 2514 2008-10-02 14:46:27Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.deployme.loadXml;

import java.net.URL;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

import org.ow2.jasmine.deployme.generated.Topology;
import org.xml.sax.SAXException;

/**
 * Load the xml topology
 *
 * @author Remy Bresson
 */
public class XmlLoader {

    /**
     * The loaded topology
     */
    Topology topology;

    /**
     * Constructor. Loas the topology
     *
     * @param topologyUrl path to the xml topology file
     * @param schemaUrl path to the xml topology schema
     * @throws SAXException
     * @throws JAXBException
     */
    public XmlLoader(final URL topologyUrl, final URL schemaUrl) throws SAXException, JAXBException {
        loadTopology(topologyUrl, schemaUrl);
    }

    /**
     * Load the topology
     *
     * @param urlXML topologyUrl path to the xml topology file
     * @param schemaUrl schemaUrl path to the xml topology schema
     * @throws SAXException
     * @throws JAXBException
     */
    private void loadTopology(final URL urlXML, final URL schemaUrl) throws SAXException, JAXBException {
        JAXBContext jc;

        jc = JAXBContext.newInstance("org.ow2.jasmine.deployme.generated");

        Unmarshaller unMarshaller;

        unMarshaller = jc.createUnmarshaller();

        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");

        Schema schema = null;
        schema = schemaFactory.newSchema(schemaUrl);

        unMarshaller.setSchema(schema);

        topology = (Topology) unMarshaller.unmarshal(urlXML);
    }

    /**
     * Return the loaded topology
     *
     * @return the topology
     */
    public Topology getTopology() {
        return topology;
    }

}
