/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme.configApply;

import org.ow2.jasmine.deployme.generated.Configuration;
import org.ow2.jonas.tools.configurator.Jonas;
import org.ow2.jonas.tools.configurator.api.JonasConfigurator;

public class ConfigJonasApply {
    private JonasConfigurator jonasConf;

    public ConfigJonasApply(String jonasRoot) {
        Jonas jonas = new Jonas(jonasRoot);
        this.jonasConf = jonas.getJonasConfigurator();
    }

    public void setGlobalJonas(String serverName, String domainName, Configuration.GlobalJonas globalJonas) {
        if (globalJonas.getJdk() != null) {
            this.jonasConf.setJdk(globalJonas.getJdk());
        }
        if (globalJonas.getJavaOpts() != null) {
            this.jonasConf.setJavaOpts(globalJonas.getJavaOpts());
        }
        if (globalJonas.getJonasBase() != null) {
            this.jonasConf.setJonasBase(globalJonas.getJonasBase());
        }
        if (globalJonas.getJonasVersion() != null) {
            this.jonasConf.setJonasVersion(globalJonas.getJonasVersion());
        }
        this.jonasConf.setJonasName(serverName);
        this.jonasConf.setJonasDomain(domainName);
        this.jonasConf.setDiscoveryDomainName(domainName);
        if (globalJonas.getHost() != null) {
            this.jonasConf.setHost(globalJonas.getHost());
        }
    }

    public void setProtocols(Configuration.Protocols protocols) {
        if (protocols.getIrmiPort() != null) {
            this.jonasConf.setProtocolsIrmiPort(protocols.getIrmiPort().toString());
        }
        if (protocols.getIiopPort() != null) {
            this.jonasConf.setProtocolsIiopPort(protocols.getIiopPort().toString());
        }
        if (protocols.getJrmpPort() != null) {
            this.jonasConf.setProtocolsJrmpPort(protocols.getJrmpPort().toString());
        }
        if (protocols.getCmiPort() != null) {
            this.jonasConf.setProtocolsCmiPort(protocols.getCmiPort().toString());
        }
        if (protocols.getProtocolsList() != null) {
            this.jonasConf.setProtocolsList(protocols.getProtocolsList());
        }
        if (protocols.isJndiLocalCallOptimization() != null) {
            this.jonasConf.setProtocolsLocalCallOptimized(protocols.isJndiLocalCallOptimization());
        }
    }

    public void setActiveServices(Configuration.ActiveServices activeServices) {
        if (activeServices.getNames() != null) {
            this.jonasConf.setServices(activeServices.getNames());
        }
        if (activeServices.getWeb() != null) {
            this.setServiceWeb(activeServices.getWeb());
        }
        if (activeServices.getDb() != null) {
            this.setServiceDb(activeServices.getDb());
        }
        if (activeServices.getDiscovery() != null) {
            this.setServiceDiscovery(activeServices.getDiscovery());
        }
        if (activeServices.getMail() != null) {
            this.setServiceMail(activeServices.getMail());
        }
        if (activeServices.getWs() != null) {
            this.setServiceWs(activeServices.getWs());
        }
        if (activeServices.getHa() != null) {
            this.setServiceHa(activeServices.getHa());
        }
    }

    public void setSecurityManager(Configuration.SecurityManager securityManager) {
        if (securityManager.isActivation() != null) {
            this.jonasConf.setSecurityManagerActivation(securityManager.isActivation());
        }
    }

    public void setEjbClusteringConfiguration(Configuration.EjbClustering ejbClustering) {
        if (ejbClustering.isEjbClusteringActivated() != null) {
            this.jonasConf.setEjbClusteringActivated(ejbClustering.isEjbClusteringActivated());
        }
        if (ejbClustering.getMulticastAddr() != null) {
            this.jonasConf.setEjbClusteringMulticastAddr(ejbClustering.getMulticastAddr());
        }
        if (ejbClustering.getMulticastPort() != null) {
            this.jonasConf.setEjbClusteringMulticastPort(ejbClustering.getMulticastPort().toString());
        }
    }

    public void setJmsConfiguration(Configuration.Jms jms) {
        if (jms.getPort() != null) {
            this.jonasConf.setJmsPort(jms.getPort().toString());
        }
        if (jms.getQueue() != null) {
            this.jonasConf.setJmsQueue(jms.getQueue());
        }
        if (jms.getTopic() != null) {
            this.jonasConf.setJmsTopic(jms.getTopic());
        }
    }

    public void setJdbcConfiguration(Configuration.Jdbc jdbc) {
        if (jdbc.getDrivers() != null) {
            this.jonasConf.setJdbcDrivers(jdbc.getDrivers());
        }
        if (jdbc.getDsClass() != null) {
            this.jonasConf.setJdbcDsClass(jdbc.getDsClass());
        }
        if (jdbc.getRaName() != null) {
            this.jonasConf.setJdbcRaName(jdbc.getRaName());
        }
        if (jdbc.getJdbcCheckLevel() != null) {
            this.jonasConf.setJdbcCheckLevel(jdbc.getJdbcCheckLevel());
        }
        if (jdbc.getJdbcTestStatment() != null) {
            this.jonasConf.setJdbcTestStatement(jdbc.getJdbcTestStatment());
        }
        if (jdbc.getJndiname() != null) {
            this.jonasConf.setJdbcJndiname(jdbc.getJndiname());
        }
        if (jdbc.getMappername() != null) {
            this.jonasConf.setJdbcMappername(jdbc.getMappername());
        }
        if (jdbc.getPassword() != null) {
            this.jonasConf.setJdbcPassword(jdbc.getPassword());
        }
        if (jdbc.getRarlink() != null) {
            this.jonasConf.setJdbcRarlink(jdbc.getRarlink());
        }
        if (jdbc.getUrl() != null) {
            this.jonasConf.setJdbcUrl(jdbc.getUrl());
        }
        if (jdbc.getUser() != null) {
            this.jonasConf.setJdbcUser(jdbc.getUser());
        }
        if (jdbc.getPoolParameters() != null) {
            this.setJdbcPoolParameters(jdbc.getPoolParameters());
        }
    }

    protected void setJdbcPoolParameters(Configuration.Jdbc.PoolParameters params) {
        if (params.getPoolInit() != null) {
            this.jonasConf.setJdbcPoolInit(params.getPoolInit().toString());
        }
        if (params.getPoolMax() != null) {
            this.jonasConf.setJdbcPoolMax(params.getPoolMax().toString());
        }
        if (params.getPoolMaxAgeMinutes() != null) {
            this.jonasConf.setJdbcPoolMaxAgeMinutes(params.getPoolMaxAgeMinutes().toString());
        }
        if (params.getPoolMaxOpentime() != null) {
            this.jonasConf.setJdbcPoolMaxOpentime(params.getPoolMaxOpentime().toString());
        }
        if (params.getPoolMaxWaiters() != null) {
            this.jonasConf.setJdbcPoolMaxWaiters(params.getPoolMaxWaiters().toString());
        }
        if (params.getPoolMaxWaittime() != null) {
            this.jonasConf.setJdbcPoolMaxWaittime(params.getPoolMaxWaittime().toString());
        }
        if (params.getPoolMin() != null) {
            this.jonasConf.setJdbcPoolMin(params.getPoolMin().toString());
        }
        if (params.getPoolSamplingPeriod() != null) {
            this.jonasConf.setJdbcPoolSamplingPeriod(params.getPoolSamplingPeriod().toString());
        }
        if (params.getPstmtMax() != null) {
            this.jonasConf.setJdbcPoolPstmtMax(params.getPstmtMax().toString());
        }
    }

    public void setServiceHa(Configuration.ActiveServices.Ha ha) {
        if (ha.isHaActivated() != null) {
            this.jonasConf.setHaActivated(ha.isHaActivated());
        }
        if (ha.getMulticastAddr() != null) {
            this.jonasConf.setHaMulticastAddr(ha.getMulticastAddr());
        }
        if (ha.getMulticastPort() != null) {
            this.jonasConf.setHaMulticastPort(ha.getMulticastPort().toString());
        }
    }

    public void setServiceWs(Configuration.ActiveServices.Ws ws) {
        if (ws.getWsdlFileDir() != null) {
            this.jonasConf.setWSDLFileDir(ws.getWsdlFileDir());
        }
        if (ws.getWsdlFilename() != null) {
            this.jonasConf.setWSDLFileName(ws.getWsdlFilename());
        }
    }

    public void setServiceMail(Configuration.ActiveServices.Mail mail) {
        if (mail.getFactoryName() != null) {
            this.jonasConf.setMailFactoryName(mail.getFactoryName());
        }
        if (mail.getFactoryType() != null) {
            this.jonasConf.setMailFactoryType(mail.getFactoryType());
        }
    }

    public void setServiceDiscovery(Configuration.ActiveServices.Discovery discovery) {
        if (discovery.isMasterActivation() != null) {
            this.jonasConf.setDiscoveryMasterActivated(discovery.isMasterActivation());
        }
        if (discovery.getGreetingPort() != null) {
            this.jonasConf.setDiscoveryGreetingPort(discovery.getGreetingPort().toString());
        }
        if (discovery.getMulticastAddress() != null) {
            this.jonasConf.setDiscoveryMulticastAddress(discovery.getMulticastAddress());
        }
        if (discovery.getMulticastPort() != null) {
            this.jonasConf.setDiscoveryMulticastPort(discovery.getMulticastPort().toString());
        }
        if (discovery.getSourcePort() != null) {
            this.jonasConf.setDiscoverySourcePort(discovery.getSourcePort().toString());
        }
        if (discovery.getTtl() != null) {
            this.jonasConf.setDiscoveryTtl(discovery.getTtl());
        }
    }

    public void setServiceDb(Configuration.ActiveServices.Db db) {
        if (db.getPort() != null) {
            this.jonasConf.setDbPort(db.getPort().toString());
        }
    }

    protected void setServiceWeb(Configuration.ActiveServices.Web web) {
        if (web.isAjpActivated() != null) {
            this.jonasConf.setAjpConnectorActivation(web.isAjpActivated());
        }
        if (web.isHttpReplicationActivated() != null) {
            this.jonasConf.setHttpSessionReplicationActivation(web.isHttpReplicationActivated());
        }
        if (web.isHttpsActivated() != null) {
            this.jonasConf.setHttpsConnectorActivation(web.isHttpsActivated());
        }
        if (web.getJvmRoute() != null) {
            this.jonasConf.setJvmRoute(web.getJvmRoute());
        }
        if (web.getAjpConf() != null) {
            this.setAjpConf(web.getAjpConf());
        }
        if (web.getHttpConf() != null) {
            this.setHttpConf(web.getHttpConf());
        }
        if (web.getHttpReplicationConf() != null) {
            this.setHttpReplicationConf(web.getHttpReplicationConf());
        }
        if (web.getHttpsConf() != null) {
            this.setHttpsConf(web.getHttpsConf());
        }
    }

    protected void setAjpConf(Configuration.ActiveServices.Web.AjpConf ajpConf) {
        if (ajpConf.getWebConf().getMaxSpareThreads() != null) {
            this.jonasConf.setAjpMaxSpareThreads(ajpConf.getWebConf().getMaxSpareThreads().toString());
        }
        if (ajpConf.getWebConf().getMaxThreads() != null) {
            this.jonasConf.setAjpMaxThreads(ajpConf.getWebConf().getMaxThreads().toString());
        }
        if (ajpConf.getWebConf().getMinSpareThreads() != null) {
            this.jonasConf.setAjpMinSpareThreads(ajpConf.getWebConf().getMinSpareThreads().toString());
        }
        if (ajpConf.getWebConf().getPort() != null) {
            this.jonasConf.setAjpPort(ajpConf.getWebConf().getPort().toString());
        }
    }

    protected void setHttpConf(Configuration.ActiveServices.Web.HttpConf httpConf) {
        if (httpConf.getWebConf().getMaxSpareThreads() != null) {
            this.jonasConf.setHttpMaxSpareThreads(httpConf.getWebConf().getMaxSpareThreads().toString());
        }
        if (httpConf.getWebConf().getMaxThreads() != null) {
            this.jonasConf.setHttpMaxThreads(httpConf.getWebConf().getMaxThreads().toString());
        }
        if (httpConf.getWebConf().getMinSpareThreads() != null) {
            this.jonasConf.setHttpMinSpareThreads(httpConf.getWebConf().getMinSpareThreads().toString());
        }
        if (httpConf.getWebConf().getPort() != null) {
            this.jonasConf.setHttpPort(httpConf.getWebConf().getPort().toString());
        }
    }

    protected void setHttpReplicationConf(Configuration.ActiveServices.Web.HttpReplicationConf httpReplicationConf) {
        if (httpReplicationConf.getClusterName() != null) {
            this.jonasConf.setHttpReplicationClusterName(httpReplicationConf.getClusterName());
        }
        if (httpReplicationConf.getListenport() != null) {
            this.jonasConf.setHttpReplicationListenPort(httpReplicationConf.getListenport().toString());
        }
        if (httpReplicationConf.getMcastaddre() != null) {
            this.jonasConf.setHttpReplicationMCastAddr(httpReplicationConf.getMcastaddre());
        }
        if (httpReplicationConf.getMcastport() != null) {
            this.jonasConf.setHttpReplicationMCastPort(httpReplicationConf.getMcastport().toString());
        }
    }

    protected void setHttpsConf(Configuration.ActiveServices.Web.HttpsConf httpsConf) {
        if (httpsConf.getWebConf().getMaxSpareThreads() != null) {
            this.jonasConf.setHttpsMaxSpareThreads(httpsConf.getWebConf().getMaxSpareThreads().toString());
        }
        if (httpsConf.getWebConf().getMaxThreads() != null) {
            this.jonasConf.setHttpsMaxThreads(httpsConf.getWebConf().getMaxThreads().toString());
        }
        if (httpsConf.getWebConf().getMinSpareThreads() != null) {
            this.jonasConf.setHttpsMinSpareThreads(httpsConf.getWebConf().getMinSpareThreads().toString());
        }
        if (httpsConf.getWebConf().getPort() != null) {
            this.jonasConf.setHttpsPort(httpsConf.getWebConf().getPort().toString());
        }
    }

    public void execute() {
        this.jonasConf.execute();
    }
}

