/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DeployMEPropertiesManager.java 5189 2009-09-08 16:13:22Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.deployme.utils;

import java.net.URL;
import java.util.ResourceBundle;

/**
 * Reads and manages the properties files
 * 
 * @author Remy Bresson
 */
public class DeployMEPropertiesManager {

    /**
     * The associated resource bundle to the properties file
     */
    private static ResourceBundle properties;

    /**
     * Properties file path (in properties path format)
     */
    private static String DEPLOYME_PROPERTIES_NAME = "properties.deployme";

    /**
     * Key for the xsd topology path in the properties file
     */
    private static String KEY_XSD_TOPOLOGY = "xsdTopology";

    /**
     * Key for the topology XML namespace in the properties file
     */
    private static String KEY_XMLNS_TOPOLOGY = "xmlnsTopology";

    /**
     * Key for the topology XML namespace in the properties file
     */
    private static String KEY_SCHEMA_LOCATION_TOPOLOGY = "schemaLocationTopology";

    static {
        properties = ResourceBundle.getBundle(DeployMEPropertiesManager.DEPLOYME_PROPERTIES_NAME);
    }

    /**
     * Return the topology schema path
     * 
     * @return the topology schema path
     */
    public static URL getXsdTopologyURL() {
        String pathXsd = properties.getString(DeployMEPropertiesManager.KEY_XSD_TOPOLOGY);

        return DeployMEPropertiesManager.class.getClassLoader().getResource(pathXsd);
    }

    /**
     * Return the topology XML namespace
     * 
     * @return the topology XML namespace
     */
    public static String getTopologyXMLNS() {
        return properties.getString(DeployMEPropertiesManager.KEY_XMLNS_TOPOLOGY);
    }

    /**
     * Return the topology schema location
     * 
     * @return the topology schema location
     */
    public static String getTopologySchemaLocation() {
        return properties.getString(DeployMEPropertiesManager.KEY_SCHEMA_LOCATION_TOPOLOGY);
    }

}
