/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme.loadXml;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ow2.jasmine.deployme.generated.Topology;
import org.xml.sax.SAXException;

public class XmlLoader {
    Topology topology;

    public XmlLoader(URL topologyUrl, URL schemaUrl, String xmlns, String schemaLocation) throws SAXException, JAXBException, IOException {
        this.loadTopology(topologyUrl, schemaUrl, xmlns, schemaLocation);
    }

    private void loadTopology(URL urlXML, URL schemaUrl, String xmlns, String schemaLocation) throws SAXException, JAXBException, IOException {
        int xmlnsIndex;
        int topologyEnd;
        JAXBContext jc = JAXBContext.newInstance((String)Topology.class.getPackage().getName());
        Unmarshaller unMarshaller = jc.createUnmarshaller();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        schema = schemaFactory.newSchema(schemaUrl);
        unMarshaller.setSchema(schema);
        String xml = XmlLoader.readURL(urlXML);
        int topologyStart = xml.indexOf("<topology");
        if (topologyStart != -1 && (topologyEnd = xml.indexOf(">", topologyStart)) != -1 && (xmlnsIndex = xml.indexOf("xmlns", topologyStart)) == -1) {
            xml = xml.substring(0, topologyStart) + "<topology xmlns=\"" + xmlns + "\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"" + xmlns + " " + schemaLocation + "\"" + xml.substring(topologyStart + 9);
        }
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xml.getBytes());
        this.topology = (Topology)unMarshaller.unmarshal((InputStream)xmlInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readURL(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        try {
            String inputLine;
            StringBuilder sb = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(inputLine);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            in.close();
        }
    }

    public Topology getTopology() {
        return this.topology;
    }
}

