/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme;

import org.ow2.jasmine.deployme.generated.Configuration;
import org.ow2.jasmine.deployme.generated.WebConf;
import org.ow2.jasmine.deployme.utils.ServerDomain;

public class ConfiguratorBuilder {
    protected Configuration config;

    public ConfiguratorBuilder(ServerDomain sd) {
        Configuration config_domain = sd.getDomain().getConfiguration();
        Configuration config_server = sd.getServer().getConfiguration();
        this.config = new Configuration();
        this.setAConfig(config_domain);
        this.setAConfig(config_server);
    }

    public Configuration getConfig() {
        return this.config;
    }

    private void setAConfig(Configuration confToRead) {
        if (confToRead != null) {
            this.setGlobalOptions(confToRead);
            this.setServiceDb(confToRead);
            this.setServiceDiscovery(confToRead);
            this.setServiceHa(confToRead);
            this.setServiceMail(confToRead);
            this.setServiceWeb(confToRead);
            this.setServiceWsdlPublisher(confToRead);
            this.setSecurityManager(confToRead);
            this.setEjbClustering(confToRead);
            this.setJms(confToRead);
            this.setJdbc(confToRead);
        }
    }

    private void setGlobalOptions(Configuration confToRead) {
        if (this.config.getGlobalOptions() == null) {
            this.config.setGlobalOptions(new Configuration.GlobalOptions());
        }
        if (confToRead.getGlobalOptions() != null) {
            if (confToRead.getGlobalOptions().getJdk() != null) {
                this.config.getGlobalOptions().setJdk(confToRead.getGlobalOptions().getJdk());
            }
            if (confToRead.getGlobalOptions().getJonasBase() != null) {
                this.config.getGlobalOptions().setJonasBase(confToRead.getGlobalOptions().getJonasBase());
            }
            if (confToRead.getGlobalOptions().getJavaOpts() != null) {
                this.config.getGlobalOptions().setJavaOpts(confToRead.getGlobalOptions().getJavaOpts());
            }
            if (confToRead.getGlobalOptions().getJonasRoot() != null) {
                this.config.getGlobalOptions().setJonasRoot(confToRead.getGlobalOptions().getJonasRoot());
            }
            if (confToRead.getGlobalOptions().getJonasServices() != null) {
                this.config.getGlobalOptions().setJonasServices(confToRead.getGlobalOptions().getJonasServices());
            }
            if (confToRead.getGlobalOptions().isJonasDevelopment() != null) {
                this.config.getGlobalOptions().setJonasDevelopment(confToRead.getGlobalOptions().isJonasDevelopment());
            }
            if (confToRead.getGlobalOptions().getHost() != null) {
                this.config.getGlobalOptions().setHost(confToRead.getGlobalOptions().getHost());
            }
            if (confToRead.getGlobalOptions().isJndiLocalCallOptimization() != null) {
                this.config.getGlobalOptions().setJndiLocalCallOptimization(confToRead.getGlobalOptions().isJndiLocalCallOptimization());
            }
            if (confToRead.getGlobalOptions().getIiopPort() != null) {
                this.config.getGlobalOptions().setIiopPort(confToRead.getGlobalOptions().getIiopPort());
            }
            if (confToRead.getGlobalOptions().getIrmiPort() != null) {
                this.config.getGlobalOptions().setIrmiPort(confToRead.getGlobalOptions().getIrmiPort());
            }
            if (confToRead.getGlobalOptions().getJrmpPort() != null) {
                this.config.getGlobalOptions().setJrmpPort(confToRead.getGlobalOptions().getJrmpPort());
            }
            if (confToRead.getGlobalOptions().getCmiPort() != null) {
                this.config.getGlobalOptions().setCmiPort(confToRead.getGlobalOptions().getCmiPort());
            }
            if (confToRead.getGlobalOptions().getProtocolsList() != null) {
                this.config.getGlobalOptions().setProtocolsList(confToRead.getGlobalOptions().getProtocolsList());
            }
        }
    }

    private void setServiceWeb(Configuration confToRead) {
        if (this.config.getWeb() == null) {
            this.config.setWeb(new Configuration.Web());
        }
        if (confToRead.getWeb() != null) {
            if (confToRead.getWeb().isAjpActivated() != null) {
                this.config.getWeb().setAjpActivated(confToRead.getWeb().isAjpActivated());
            }
            if (confToRead.getWeb().isHttpReplicationActivated() != null) {
                this.config.getWeb().setHttpReplicationActivated(confToRead.getWeb().isHttpReplicationActivated());
            }
            if (confToRead.getWeb().isHttpsActivated() != null) {
                this.config.getWeb().setHttpsActivated(confToRead.getWeb().isHttpsActivated());
            }
            if (confToRead.getWeb().getJvmRoute() != null) {
                this.config.getWeb().setJvmRoute(confToRead.getWeb().getJvmRoute());
            }
            if (this.config.getWeb().getAjpConf() == null) {
                this.config.getWeb().setAjpConf(new Configuration.Web.AjpConf());
            }
            if (this.config.getWeb().getAjpConf().getWebConf() == null) {
                this.config.getWeb().getAjpConf().setWebConf(new WebConf());
            }
            if (confToRead.getWeb().getAjpConf() != null && confToRead.getWeb().getAjpConf().getWebConf() != null) {
                this.buildWebConf(confToRead.getWeb().getAjpConf().getWebConf(), this.config.getWeb().getAjpConf().getWebConf());
            }
            if (this.config.getWeb().getHttpsConf() == null) {
                this.config.getWeb().setHttpsConf(new Configuration.Web.HttpsConf());
            }
            if (this.config.getWeb().getHttpsConf().getWebConf() == null) {
                this.config.getWeb().getHttpsConf().setWebConf(new WebConf());
            }
            if (confToRead.getWeb().getHttpsConf() != null && confToRead.getWeb().getHttpsConf().getWebConf() != null) {
                this.buildWebConf(confToRead.getWeb().getHttpsConf().getWebConf(), this.config.getWeb().getHttpsConf().getWebConf());
            }
            if (this.config.getWeb().getHttpConf() == null) {
                this.config.getWeb().setHttpConf(new Configuration.Web.HttpConf());
            }
            if (this.config.getWeb().getHttpConf().getWebConf() == null) {
                this.config.getWeb().getHttpConf().setWebConf(new WebConf());
            }
            if (confToRead.getWeb().getHttpConf() != null && confToRead.getWeb().getHttpConf().getWebConf() != null) {
                this.buildWebConf(confToRead.getWeb().getHttpConf().getWebConf(), this.config.getWeb().getHttpConf().getWebConf());
            }
            if (this.config.getWeb().getHttpReplicationConf() == null) {
                this.config.getWeb().setHttpReplicationConf(new Configuration.Web.HttpReplicationConf());
            }
            if (confToRead.getWeb().getHttpReplicationConf() != null) {
                if (confToRead.getWeb().getHttpReplicationConf().getClusterName() != null) {
                    this.config.getWeb().getHttpReplicationConf().setClusterName(confToRead.getWeb().getHttpReplicationConf().getClusterName());
                }
                if (confToRead.getWeb().getHttpReplicationConf().getListenPort() != null) {
                    this.config.getWeb().getHttpReplicationConf().setListenPort(confToRead.getWeb().getHttpReplicationConf().getListenPort());
                }
                if (confToRead.getWeb().getHttpReplicationConf().getMulticastAddress() != null) {
                    this.config.getWeb().getHttpReplicationConf().setMulticastAddress(confToRead.getWeb().getHttpReplicationConf().getMulticastAddress());
                }
                if (confToRead.getWeb().getHttpReplicationConf().getMulticastPort() != null) {
                    this.config.getWeb().getHttpReplicationConf().setMulticastPort(confToRead.getWeb().getHttpReplicationConf().getMulticastPort());
                }
            }
        }
    }

    private void setServiceDb(Configuration confToRead) {
        if (this.config.getDb() == null) {
            this.config.setDb(new Configuration.Db());
        }
        if (confToRead.getDb() != null && confToRead.getDb().getPort() != null) {
            this.config.getDb().setPort(confToRead.getDb().getPort());
        }
    }

    private void setServiceDiscovery(Configuration confToRead) {
        if (this.config.getDiscovery() == null) {
            this.config.setDiscovery(new Configuration.Discovery());
        }
        if (confToRead.getDiscovery() != null) {
            if (confToRead.getDiscovery().getGreetingPort() != null) {
                this.config.getDiscovery().setGreetingPort(confToRead.getDiscovery().getGreetingPort());
            }
            if (confToRead.getDiscovery().isMasterActivation() != null) {
                this.config.getDiscovery().setMasterActivation(confToRead.getDiscovery().isMasterActivation());
            }
            if (confToRead.getDiscovery().getMulticastAddress() != null) {
                this.config.getDiscovery().setMulticastAddress(confToRead.getDiscovery().getMulticastAddress());
            }
            if (confToRead.getDiscovery().getMulticastPort() != null) {
                this.config.getDiscovery().setMulticastPort(confToRead.getDiscovery().getMulticastPort());
            }
            if (confToRead.getDiscovery().getSourcePort() != null) {
                this.config.getDiscovery().setSourcePort(confToRead.getDiscovery().getSourcePort());
            }
            if (confToRead.getDiscovery().getTtl() != null) {
                this.config.getDiscovery().setTtl(confToRead.getDiscovery().getTtl());
            }
        }
    }

    private void setServiceMail(Configuration confToRead) {
        if (this.config.getMail() == null) {
            this.config.setMail(new Configuration.Mail());
        }
        if (confToRead.getMail() != null) {
            if (confToRead.getMail().getFactoryName() != null) {
                this.config.getMail().setFactoryName(confToRead.getMail().getFactoryName());
            }
            if (confToRead.getMail().getFactoryType() != null) {
                this.config.getMail().setFactoryType(confToRead.getMail().getFactoryType());
            }
        }
    }

    private void setServiceWsdlPublisher(Configuration confToRead) {
        if (this.config.getWsdlPublisher() == null) {
            this.config.setWsdlPublisher(new Configuration.WsdlPublisher());
        }
        if (confToRead.getWsdlPublisher() != null) {
            if (confToRead.getWsdlPublisher().getWsdlFileDir() != null) {
                this.config.getWsdlPublisher().setWsdlFileDir(confToRead.getWsdlPublisher().getWsdlFileDir());
            }
            if (confToRead.getWsdlPublisher().getWsdlFilename() != null) {
                this.config.getWsdlPublisher().setWsdlFilename(confToRead.getWsdlPublisher().getWsdlFilename());
            }
        }
    }

    private void setServiceHa(Configuration confToRead) {
        if (this.config.getHa() == null) {
            this.config.setHa(new Configuration.Ha());
        }
        if (confToRead.getHa() != null) {
            if (confToRead.getHa().isHaActivated() != null) {
                this.config.getHa().setHaActivated(confToRead.getHa().isHaActivated());
            }
            if (confToRead.getHa().getMulticastAddress() != null) {
                this.config.getHa().setMulticastAddress(confToRead.getHa().getMulticastAddress());
            }
            if (confToRead.getHa().getMulticastPort() != null) {
                this.config.getHa().setMulticastPort(confToRead.getHa().getMulticastPort());
            }
        }
    }

    private void buildWebConf(WebConf webConfToRead, WebConf config) {
        if (webConfToRead.getMaxSpareThreads() != null) {
            config.setMaxSpareThreads(webConfToRead.getMaxSpareThreads());
        }
        if (webConfToRead.getMaxThreads() != null) {
            config.setMaxThreads(webConfToRead.getMaxThreads());
        }
        if (webConfToRead.getMinSpareThreads() != null) {
            config.setMinSpareThreads(webConfToRead.getMinSpareThreads());
        }
        if (webConfToRead.getPort() != null) {
            config.setPort(webConfToRead.getPort());
        }
    }

    private void setSecurityManager(Configuration confToRead) {
        if (this.config.getSecurityManager() == null) {
            this.config.setSecurityManager(new Configuration.SecurityManager());
        }
        if (confToRead.getSecurityManager() != null && confToRead.getSecurityManager().isActivation() != null) {
            this.config.getSecurityManager().setActivation(confToRead.getSecurityManager().isActivation());
        }
    }

    private void setEjbClustering(Configuration confToRead) {
        if (this.config.getEjbClustering() == null) {
            this.config.setEjbClustering(new Configuration.EjbClustering());
        }
        if (confToRead.getEjbClustering() != null) {
            if (confToRead.getEjbClustering().isEjbClusteringActivated() != null) {
                this.config.getEjbClustering().setEjbClusteringActivated(confToRead.getEjbClustering().isEjbClusteringActivated());
            }
            if (confToRead.getEjbClustering().getMulticastAddress() != null) {
                this.config.getEjbClustering().setMulticastAddress(confToRead.getEjbClustering().getMulticastAddress());
            }
            if (confToRead.getEjbClustering().getMulticastPort() != null) {
                this.config.getEjbClustering().setMulticastPort(confToRead.getEjbClustering().getMulticastPort());
            }
        }
    }

    private void setJms(Configuration confToRead) {
        if (this.config.getJms() == null) {
            this.config.setJms(new Configuration.Jms());
        }
        if (confToRead.getJms() != null) {
            if (confToRead.getJms().getPort() != null) {
                this.config.getJms().setPort(confToRead.getJms().getPort());
            }
            if (confToRead.getJms().getQueues() != null) {
                this.config.getJms().setQueues(confToRead.getJms().getQueues());
            }
            if (confToRead.getJms().getTopics() != null) {
                this.config.getJms().setTopics(confToRead.getJms().getTopics());
            }
        }
    }

    private void setJdbc(Configuration confToRead) {
        if (this.config.getJdbc() == null) {
            this.config.setJdbc(new Configuration.Jdbc());
        }
        if (confToRead.getJdbc() != null) {
            if (confToRead.getJdbc().getDrivers() != null) {
                this.config.getJdbc().setDrivers(confToRead.getJdbc().getDrivers());
            }
            if (confToRead.getJdbc().getDsClass() != null) {
                this.config.getJdbc().setDsClass(confToRead.getJdbc().getDsClass());
            }
            if (confToRead.getJdbc().getRaName() != null) {
                this.config.getJdbc().setRaName(confToRead.getJdbc().getRaName());
            }
            if (confToRead.getJdbc().getJdbcCheckLevel() != null) {
                this.config.getJdbc().setJdbcCheckLevel(confToRead.getJdbc().getJdbcCheckLevel());
            }
            if (confToRead.getJdbc().getJdbcTestStatment() != null) {
                this.config.getJdbc().setJdbcTestStatment(confToRead.getJdbc().getJdbcTestStatment());
            }
            if (confToRead.getJdbc().getJndiname() != null) {
                this.config.getJdbc().setJndiname(confToRead.getJdbc().getJndiname());
            }
            if (confToRead.getJdbc().getMappername() != null) {
                this.config.getJdbc().setMappername(confToRead.getJdbc().getMappername());
            }
            if (confToRead.getJdbc().getPassword() != null) {
                this.config.getJdbc().setPassword(confToRead.getJdbc().getPassword());
            }
            if (confToRead.getJdbc().getRarlink() != null) {
                this.config.getJdbc().setRarlink(confToRead.getJdbc().getRarlink());
            }
            if (confToRead.getJdbc().getUrl() != null) {
                this.config.getJdbc().setUrl(confToRead.getJdbc().getUrl());
            }
            if (confToRead.getJdbc().getUser() != null) {
                this.config.getJdbc().setUser(confToRead.getJdbc().getUser());
            }
            if (this.config.getJdbc().getPoolParameters() == null) {
                this.config.getJdbc().setPoolParameters(new Configuration.Jdbc.PoolParameters());
            }
            if (confToRead.getJdbc().getPoolParameters() != null) {
                this.config.getJdbc().getPoolParameters().setPoolInit(confToRead.getJdbc().getPoolParameters().getPoolInit());
                this.config.getJdbc().getPoolParameters().setPoolMax(confToRead.getJdbc().getPoolParameters().getPoolMax());
                this.config.getJdbc().getPoolParameters().setPoolMaxAgeMinutes(confToRead.getJdbc().getPoolParameters().getPoolMaxAgeMinutes());
                this.config.getJdbc().getPoolParameters().setPoolMaxOpentime(confToRead.getJdbc().getPoolParameters().getPoolMaxOpentime());
                this.config.getJdbc().getPoolParameters().setPoolMaxWaiters(confToRead.getJdbc().getPoolParameters().getPoolMaxWaiters());
                this.config.getJdbc().getPoolParameters().setPoolMaxWaittime(confToRead.getJdbc().getPoolParameters().getPoolMaxWaittime());
                this.config.getJdbc().getPoolParameters().setPoolMin(confToRead.getJdbc().getPoolParameters().getPoolMin());
                this.config.getJdbc().getPoolParameters().setPoolSamplingPeriod(confToRead.getJdbc().getPoolParameters().getPoolSamplingPeriod());
                this.config.getJdbc().getPoolParameters().setPstmtMax(confToRead.getJdbc().getPoolParameters().getPstmtMax());
            }
        }
    }
}

