/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ServerDomain.java 2514 2008-10-02 14:46:27Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.deployme.utils;

import org.ow2.jasmine.deployme.generated.Topology.Domains.Domain;
import org.ow2.jasmine.deployme.generated.Topology.Domains.Domain.Servers.Server;

/**
 * Reprensent a server in its domain
 *
 * @author Remy Bresson
 */
public class ServerDomain {

    /**
     * The server
     */
    protected Server server;

    /**
     * The domain who contains the servers
     */
    protected Domain domain;

    /**
     * Default constructor
     */
    public ServerDomain() {
        super();
    }

    /**
     * Constructor
     *
     * @param server The server
     * @param domain The domain
     */
    public ServerDomain(final Server server, final Domain domain) {
        super();
        this.server = server;
        this.domain = domain;
    }

    /**
     * return the server
     *
     * @return the server
     */
    public Server getServer() {
        return server;
    }

    /**
     * Set the server
     *
     * @param server the server to set
     */
    public void setServer(final Server server) {
        this.server = server;
    }

    /**
     * return the domain
     *
     * @return the domain
     */
    public Domain getDomain() {
        return domain;
    }

    /**
     * set the domain
     *
     * @param domain the domain to set
     */
    public void setDomain(final Domain domain) {
        this.domain = domain;
    }

    /**
     * return "domainName.serverName"
     *
     * @return "domainName.serverName"
     */
    @Override
    public String toString() {
        return domain.getName() + "." + server.getName();
    }

}
