/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme;

import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.jasmine.deployme.DeployMe;
import org.ow2.jasmine.deployme.utils.CommandLine;

public class CommandLineParser {
    public static void main(String[] args) {
        try {
            File topologyFile;
            URL urlXML;
            if (args == null || args.length < 1) {
                throw new IllegalArgumentException(CommandLineParser.help());
            }
            CommandLine command = CommandLineParser.parseCommandLine(args);
            if (command.getVerbose()) {
                Logger.getLogger("").setLevel(Level.ALL);
            }
            if ((urlXML = (topologyFile = new File(command.getTopologyFile())).isFile() ? topologyFile.toURI().toURL() : CommandLineParser.class.getClassLoader().getResource(command.getTopologyFile())) == null) {
                System.out.println("The " + urlXML + " is not a local file or resource.");
                System.out.println("JASMINe Deploy ME will download it using Java URLConnections.");
                urlXML = new URL(command.getTopologyFile());
            }
            new DeployMe(urlXML, command.getMachineName(), command.getDomainName(), command.getServerName(), command.getClusterName());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            if (e.getMessage() == null) {
                e.printStackTrace();
            }
            System.exit(-1);
        }
    }

    protected static CommandLine parseCommandLine(String[] args) {
        CommandLine ret = new CommandLine();
        for (String tmp : args) {
            String argEntry = CommandLineParser.checkArgEntry(tmp);
            if (CommandLine.commandLineVerbose.equals(argEntry)) {
                ret.addValue(argEntry, null);
                continue;
            }
            String[] argsSeparated = argEntry.split("=");
            if (argsSeparated.length != 2) {
                throw new IllegalArgumentException("The argument '" + argEntry + "' doesn't have a valid syntax, an argument must contain one and only one '='");
            }
            ret.addValue(argsSeparated[0], argsSeparated[1]);
        }
        ret.checkCommandLine();
        return ret;
    }

    protected static String checkArgEntry(String argEntry) {
        if (argEntry.charAt(0) != '-') {
            throw new IllegalArgumentException("The argument '" + argEntry + "' doesn't have a valid syntax, an argument must start with '-'");
        }
        return argEntry.substring(1);
    }

    private static String help() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n");
        buffer.append("Usage : java -jar deployme.jar -topologyFile=topology_xml (-machineName=host | -domainName=domain [-serverName=server | -clusterName=cluster]) [-verbose]");
        buffer.append("\n\n");
        buffer.append(" -topologyFile=topology_xml : ");
        buffer.append("\n\t");
        buffer.append("This file describes your server infrastructure. You have two ways to create it : ");
        buffer.append("\n\t");
        buffer.append("1. Export a topology file from JASMINe Design. This is the recommended method.");
        buffer.append("\n\t");
        buffer.append("2. Manually create your topology file. Please refer to the JASMINe Deploy ME XSD file and/or the JASMINe Deploy ME samples distribution for details.");
        buffer.append("\n\n");
        buffer.append("-machineName=host : name of a machine in the topology.xml file");
        buffer.append("\n\t");
        buffer.append("Deploy all servers on a given machine");
        buffer.append("\n\n");
        buffer.append("-domainName=domain : A domain name of the topology.xml file.");
        buffer.append("\n");
        buffer.append("-serverName=server : A server name of the topology.xml file.");
        buffer.append("\n\t");
        buffer.append("Deploy the server of the the specified domain.");
        buffer.append("\n");
        buffer.append("-clusterName=cluster : A cluster daemon name of the topology.xml file.");
        buffer.append("\n\t");
        buffer.append("Deploy the cluster daemon of the specified domain.");
        return buffer.toString();
    }
}

