/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ConfigJonasApply.java 5208 2009-09-09 14:35:47Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.deployme.configApply;

import org.ow2.jasmine.deployme.generated.Configuration.Db;
import org.ow2.jasmine.deployme.generated.Configuration.Discovery;
import org.ow2.jasmine.deployme.generated.Configuration.EjbClustering;
import org.ow2.jasmine.deployme.generated.Configuration.GlobalOptions;
import org.ow2.jasmine.deployme.generated.Configuration.Ha;
import org.ow2.jasmine.deployme.generated.Configuration.Jdbc;
import org.ow2.jasmine.deployme.generated.Configuration.Jms;
import org.ow2.jasmine.deployme.generated.Configuration.Mail;
import org.ow2.jasmine.deployme.generated.Configuration.SecurityManager;
import org.ow2.jasmine.deployme.generated.Configuration.Web;
import org.ow2.jasmine.deployme.generated.Configuration.WsdlPublisher;
import org.ow2.jasmine.deployme.generated.Configuration.Jdbc.PoolParameters;
import org.ow2.jasmine.deployme.generated.Configuration.Web.AjpConf;
import org.ow2.jasmine.deployme.generated.Configuration.Web.HttpConf;
import org.ow2.jasmine.deployme.generated.Configuration.Web.HttpReplicationConf;
import org.ow2.jasmine.deployme.generated.Configuration.Web.HttpsConf;
import org.ow2.jonas.tools.configurator.Jonas;
import org.ow2.jonas.tools.configurator.api.JonasConfigurator;

/**
 * Apply a configuration on a Jonas server
 * 
 * @author Remy Bresson
 */
public class ConfigJonasApply {

    /**
     * The jonas configurator
     */
    private JonasConfigurator jonasConf;

    /**
     * Constructor
     */
    public ConfigJonasApply(final String jonasRoot) {
        Jonas jonas = new Jonas(jonasRoot);
        this.jonasConf = jonas.getJonasConfigurator();
    }

    /**
     * Apply the jonas global parameters
     * 
     * @param serverName Server name.
     * @param domainName Domain name.
     * @param globalOptions The global parameters
     */
    public void setGlobalOptions(final String serverName, final String domainName, final GlobalOptions globalOptions) {
        if (globalOptions.getJdk() != null) {
            this.jonasConf.setJdk(globalOptions.getJdk());
        }
        if (globalOptions.getJavaOpts() != null) {
            this.jonasConf.setJavaOpts(globalOptions.getJavaOpts());
        }
        if (globalOptions.getJonasBase() != null) {
            this.jonasConf.setJonasBase(globalOptions.getJonasBase());
        }
        if (globalOptions.getJonasServices() != null) {
            this.jonasConf.setServices(globalOptions.getJonasServices());
        }
        this.jonasConf.setJonasName(serverName);
        this.jonasConf.setJonasDomain(domainName);
        this.jonasConf.setDiscoveryDomainName(domainName);
        if (globalOptions.getHost() != null) {
            this.jonasConf.setHost(globalOptions.getHost());
        }
        if (globalOptions.isJonasDevelopment() != null) {
            this.jonasConf.setJonasDevelopment(globalOptions.isJonasDevelopment());
        }
        if (globalOptions.getIrmiPort() != null) {
            this.jonasConf.setProtocolsIrmiPort(globalOptions.getIrmiPort().toString());
        }
        if (globalOptions.getIiopPort() != null) {
            this.jonasConf.setProtocolsIiopPort(globalOptions.getIiopPort().toString());
        }
        if (globalOptions.getJrmpPort() != null) {
            this.jonasConf.setProtocolsJrmpPort(globalOptions.getJrmpPort().toString());
        }
        if (globalOptions.getCmiPort() != null) {
            this.jonasConf.setProtocolsCmiPort(globalOptions.getCmiPort().toString());
        }
        if (globalOptions.getProtocolsList() != null) {
            this.jonasConf.setProtocolsList(globalOptions.getProtocolsList());
        }
        if (globalOptions.isJndiLocalCallOptimization() != null) {
            this.jonasConf.setProtocolsLocalCallOptimized(globalOptions.isJndiLocalCallOptimization());
        }
    }

    /**
     * Apply the security manager parameters
     * 
     * @param securityManager The security manager parameters
     */
    public void setSecurityManager(final SecurityManager securityManager) {
        if (securityManager.isActivation() != null) {
            this.jonasConf.setSecurityManagerActivated(securityManager.isActivation());
        }
    }

    /**
     * Apply the ejb clustering parameters
     * 
     * @param ejbClustering The ejb clustering parameters
     */
    public void setEjbClusteringConfiguration(final EjbClustering ejbClustering) {
        if (ejbClustering.isEjbClusteringActivated() != null) {
            this.jonasConf.setEjbClusteringActivated(ejbClustering.isEjbClusteringActivated());
        }
        if (ejbClustering.getMulticastAddress() != null) {
            this.jonasConf.setEjbClusteringMulticastAddress(ejbClustering.getMulticastAddress());
        }
        if (ejbClustering.getMulticastPort() != null) {
            this.jonasConf.setEjbClusteringMulticastPort(ejbClustering.getMulticastPort().toString());
        }
    }

    /**
     * Apply the jms parameters
     * 
     * @param jms The jms parameters
     */
    public void setJmsConfiguration(final Jms jms) {
        if (jms.getPort() != null) {
            this.jonasConf.setJmsPort(jms.getPort().toString());
        }
        if (jms.getQueues() != null) {
            this.jonasConf.setJmsQueues(jms.getQueues());
        }
        if (jms.getTopics() != null) {
            this.jonasConf.setJmsTopics(jms.getTopics());
        }
    }

    /**
     * Apply the jdbc parameters
     * 
     * @param jdbc The jdbc parameters
     */
    public void setJdbcConfiguration(final Jdbc jdbc) {
        if (jdbc.getDrivers() != null) {
            this.jonasConf.setJdbcDriverName(jdbc.getDrivers());
        }
        if (jdbc.getDsClass() != null) {
            this.jonasConf.setJdbcDatasourceClass(jdbc.getDsClass());
        }
        if (jdbc.getRaName() != null) {
            this.jonasConf.setJdbcResourceAdapterName(jdbc.getRaName());
        }
        if (jdbc.getJdbcCheckLevel() != null) {
            this.jonasConf.setJdbcCheckLevel(jdbc.getJdbcCheckLevel());
        }
        if (jdbc.getJdbcTestStatment() != null) {
            this.jonasConf.setJdbcTestStatement(jdbc.getJdbcTestStatment());
        }
        if (jdbc.getJndiname() != null) {
            this.jonasConf.setJdbcJndiName(jdbc.getJndiname());
        }
        if (jdbc.getMappername() != null) {
            this.jonasConf.setJdbcMappername(jdbc.getMappername());
        }
        if (jdbc.getPassword() != null) {
            this.jonasConf.setJdbcPassword(jdbc.getPassword());
        }
        if (jdbc.getRarlink() != null) {
            this.jonasConf.setJdbcRarlink(jdbc.getRarlink());
        }
        if (jdbc.getUrl() != null) {
            this.jonasConf.setJdbcUrl(jdbc.getUrl());
        }
        if (jdbc.getUser() != null) {
            this.jonasConf.setJdbcUser(jdbc.getUser());
        }
        if (jdbc.getPoolParameters() != null) {

            this.setJdbcPoolParameters(jdbc.getPoolParameters());
        }
    }

    /**
     * Apply the jdbc pool parameters
     * 
     * @param params The pool parameters
     */
    protected void setJdbcPoolParameters(final PoolParameters params) {
        if (params.getPoolInit() != null) {
            this.jonasConf.setJdbcPoolInitialSize(params.getPoolInit().toString());
        }
        if (params.getPoolMax() != null) {
            this.jonasConf.setJdbcPoolMaximumSize(params.getPoolMax().toString());
        }
        if (params.getPoolMaxAgeMinutes() != null) {
            this.jonasConf.setJdbcPoolMaximumAgeMinutes(params.getPoolMaxAgeMinutes().toString());
        }
        if (params.getPoolMaxOpentime() != null) {
            this.jonasConf.setJdbcPoolMaximumOpenTime(params.getPoolMaxOpentime().toString());
        }
        if (params.getPoolMaxWaiters() != null) {
            this.jonasConf.setJdbcPoolMaximumNumberOfWaiters(params.getPoolMaxWaiters().toString());
        }
        if (params.getPoolMaxWaittime() != null) {
            this.jonasConf.setJdbcPoolMaximumWaitTime(params.getPoolMaxWaittime().toString());
        }
        if (params.getPoolMin() != null) {
            this.jonasConf.setJdbcPoolMinimumSize(params.getPoolMin().toString());
        }
        if (params.getPoolSamplingPeriod() != null) {
            this.jonasConf.setJdbcPoolSamplingPeriod(params.getPoolSamplingPeriod().toString());
        }
        if (params.getPstmtMax() != null) {
            this.jonasConf.setJdbcPoolMaximumNumberOfPreparedStatements(params.getPstmtMax().toString());
        }
    }

    /**
     * Apply the ha service parameters
     * 
     * @param ha The ha service parameters
     */
    public void setServiceHa(final Ha ha) {
        if (ha.isHaActivated() != null) {
            this.jonasConf.setHaActivated(ha.isHaActivated());
        }
        if (ha.getMulticastAddress() != null) {
            this.jonasConf.setHaMulticastAddress(ha.getMulticastAddress());
        }
        if (ha.getMulticastPort() != null) {
            this.jonasConf.setHaMulticastPort(ha.getMulticastPort().toString());
        }
    }

    /**
     * Apply the webservice service parameters
     * 
     * @param ws The webservice service parameters
     */
    public void setServiceWsdlPublisher(final WsdlPublisher ws) {
        if (ws.getWsdlFileDir() != null) {
            this.jonasConf.setWsdlPublisherFileDirectory(ws.getWsdlFileDir());
        }
        if (ws.getWsdlFilename() != null) {
            this.jonasConf.setWsdlPublisherFileName(ws.getWsdlFilename());
        }
    }

    /**
     * Apply the mail service parameters
     * 
     * @param mail The mail service parameters
     */
    public void setServiceMail(final Mail mail) {
        if (mail.getFactoryName() != null) {
            this.jonasConf.setMailFactoryName(mail.getFactoryName());
        }
        if (mail.getFactoryType() != null) {
            this.jonasConf.setMailFactoryType(mail.getFactoryType());
        }
    }

    /**
     * Apply the discovery service parameters
     * 
     * @param discovery The discovery service parameters
     */
    public void setServiceDiscovery(final Discovery discovery) {
        if (discovery.isMasterActivation() != null) {
            this.jonasConf.setDiscoveryMasterActivated(discovery.isMasterActivation());
        }
        if (discovery.getGreetingPort() != null) {
            this.jonasConf.setDiscoveryGreetingPort(discovery.getGreetingPort().toString());
        }
        if (discovery.getMulticastAddress() != null) {
            this.jonasConf.setDiscoveryMulticastAddress(discovery.getMulticastAddress());
        }
        if (discovery.getMulticastPort() != null) {
            this.jonasConf.setDiscoveryMulticastPort(discovery.getMulticastPort().toString());
        }
        if (discovery.getSourcePort() != null) {
            this.jonasConf.setDiscoverySourcePort(discovery.getSourcePort().toString());
        }
        if (discovery.getTtl() != null) {
            this.jonasConf.setDiscoveryTTL(discovery.getTtl());
        }
    }

    /**
     * Apply the db service parameters
     * 
     * @param db The db service parameters
     */
    public void setServiceDb(final Db db) {
        if (db.getPort() != null) {
            this.jonasConf.setDbPort(db.getPort().toString());
        }
    }

    /**
     * Apply the web parameters
     * 
     * @param web The web parameters
     */
    public void setServiceWeb(final Web web) {
        if (web.isAjpActivated() != null) {
            this.jonasConf.setAjpConnectorActivation(web.isAjpActivated());
        }
        if (web.isHttpReplicationActivated() != null) {
            this.jonasConf.setHttpSessionReplicationActivation(web.isHttpReplicationActivated());
        }
        if (web.isHttpsActivated() != null) {
            this.jonasConf.setHttpsConnectorActivation(web.isHttpsActivated());
        }
        if (web.getJvmRoute() != null) {
            this.jonasConf.setJvmRoute(web.getJvmRoute());
        }
        if (web.getAjpConf() != null) {
            this.setAjpConf(web.getAjpConf());
        }
        if (web.getHttpConf() != null) {
            this.setHttpConf(web.getHttpConf());
        }
        if (web.getHttpReplicationConf() != null) {
            this.setHttpReplicationConf(web.getHttpReplicationConf());
        }
        if (web.getHttpsConf() != null) {
            this.setHttpsConf(web.getHttpsConf());
        }
    }

    /**
     * Apply the ajp parameters
     * 
     * @param ajpConf The ajp parameters
     */
    protected void setAjpConf(final AjpConf ajpConf) {
        if (ajpConf.getWebConf().getMaxSpareThreads() != null) {
            this.jonasConf.setAjpMaxSpareThreads(ajpConf.getWebConf().getMaxSpareThreads().toString());
        }
        if (ajpConf.getWebConf().getMaxThreads() != null) {
            this.jonasConf.setAjpMaxThreads(ajpConf.getWebConf().getMaxThreads().toString());
        }
        if (ajpConf.getWebConf().getMinSpareThreads() != null) {
            this.jonasConf.setAjpMinSpareThreads(ajpConf.getWebConf().getMinSpareThreads().toString());
        }
        if (ajpConf.getWebConf().getPort() != null) {
            this.jonasConf.setAjpPort(ajpConf.getWebConf().getPort().toString());
        }
    }

    /**
     * Apply the http parameters
     * 
     * @param httpConf The http parameters
     */
    protected void setHttpConf(final HttpConf httpConf) {
        if (httpConf.getWebConf().getMaxSpareThreads() != null) {
            this.jonasConf.setHttpMaxSpareThreads(httpConf.getWebConf().getMaxSpareThreads().toString());
        }
        if (httpConf.getWebConf().getMaxThreads() != null) {
            this.jonasConf.setHttpMaxThreads(httpConf.getWebConf().getMaxThreads().toString());
        }
        if (httpConf.getWebConf().getMinSpareThreads() != null) {
            this.jonasConf.setHttpMinSpareThreads(httpConf.getWebConf().getMinSpareThreads().toString());
        }
        if (httpConf.getWebConf().getPort() != null) {
            this.jonasConf.setHttpPort(httpConf.getWebConf().getPort().toString());
        }
    }

    /**
     * Apply the http replication parameters
     * 
     * @param httpReplicationConf The http replication parameters
     */
    protected void setHttpReplicationConf(final HttpReplicationConf httpReplicationConf) {
        if (httpReplicationConf.getClusterName() != null) {
            this.jonasConf.setHttpReplicationClusterName(httpReplicationConf.getClusterName());
        }
        if (httpReplicationConf.getListenPort() != null) {
            this.jonasConf.setHttpReplicationListenPort(httpReplicationConf.getListenPort().toString());
        }
        if (httpReplicationConf.getMulticastAddress() != null) {
            this.jonasConf.setHttpReplicationMulticastAddress(httpReplicationConf.getMulticastAddress());
        }
        if (httpReplicationConf.getMulticastPort() != null) {
            this.jonasConf.setHttpReplicationMulticastPort(httpReplicationConf.getMulticastPort().toString());
        }
    }

    /**
     * Apply the https parameters
     * 
     * @param httpsConf The https parameters
     */
    protected void setHttpsConf(final HttpsConf httpsConf) {
        if (httpsConf.getWebConf().getMaxSpareThreads() != null) {
            this.jonasConf.setHttpsMaxSpareThreads(httpsConf.getWebConf().getMaxSpareThreads().toString());
        }
        if (httpsConf.getWebConf().getMaxThreads() != null) {
            this.jonasConf.setHttpsMaxThreads(httpsConf.getWebConf().getMaxThreads().toString());
        }
        if (httpsConf.getWebConf().getMinSpareThreads() != null) {
            this.jonasConf.setHttpsMinSpareThreads(httpsConf.getWebConf().getMinSpareThreads().toString());
        }
        if (httpsConf.getWebConf().getPort() != null) {
            this.jonasConf.setHttpsPort(httpsConf.getWebConf().getPort().toString());
        }
    }

    /**
     * Apply the configuration
     */
    public void execute() {
        this.jonasConf.execute();
    }

}
