/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.ow2.jasmine.deployme.ConfiguratorBuilder;
import org.ow2.jasmine.deployme.api.XmlLoader;
import org.ow2.jasmine.deployme.configApply.Configurator;
import org.ow2.jasmine.deployme.generated.Configuration;
import org.ow2.jasmine.deployme.generated.Topology;
import org.ow2.jasmine.deployme.utils.ServerDomain;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployMe {
    protected Topology topology;
    protected List<ServerDomain> serversDomains;

    protected DeployMe() {
    }

    public DeployMe(URL topologyUrl, String machine, String domain, String server, String cluster) throws SAXException, JAXBException, IOException {
        this.loadTopology(topologyUrl);
        boolean clusterMode = cluster != null;
        Topology.Domains.Domain.ClusterDaemons.ClusterDaemon clusterDaemon = null;
        if (clusterMode && (clusterDaemon = this.getClusterDaemonConf(domain, cluster)) == null) {
            throw new IllegalArgumentException("Cannot find the specified cluster daemon '" + cluster + "' on specified domain '" + domain + "'");
        }
        this.serversDomains = this.buildServerDomainList(machine, domain, server, cluster);
        if (clusterMode) {
            clusterDaemon = this.mergeClusterDaemonAndDomainConf(clusterDaemon, this.serversDomains.get(0).getDomain());
            Configurator.setClusterAConfiguration(this.serversDomains.get(0).getDomain().getName(), clusterDaemon);
        }
        int i = 1;
        for (ServerDomain sd : this.serversDomains) {
            Configuration confToApply = new ConfiguratorBuilder(sd).getConfig();
            if (clusterMode) {
                confToApply.getGlobalOptions().setJonasBase(clusterDaemon.getJonasBasePrefix() + i++);
            }
            Configurator.setAConfiguration(confToApply, sd);
        }
    }

    protected void loadTopology(URL urlTopology) throws SAXException, JAXBException, IOException {
        XmlLoader xmlLoader = new XmlLoader(urlTopology);
        this.topology = xmlLoader.getTopology();
    }

    protected Topology.Domains.Domain.ClusterDaemons.ClusterDaemon getClusterDaemonConf(String domain, String clusterName) {
        Topology.Domains.Domain.ClusterDaemons.ClusterDaemon workingCluster = null;
        for (Topology.Domains.Domain d : this.topology.getDomains().getDomain()) {
            if (!d.getName().equals(domain)) continue;
            for (Topology.Domains.Domain.ClusterDaemons.ClusterDaemon cd : d.getClusterDaemons().getClusterDaemon()) {
                if (!cd.getName().equals(clusterName)) continue;
                workingCluster = cd;
            }
        }
        return workingCluster;
    }

    protected List<ServerDomain> buildServerDomainList(String machine, String domain, String server, String clusterName) {
        List<ServerDomain> ret;
        if (machine != null) {
            ret = this.buildServerListWithHostname(machine);
            if (ret == null || ret.size() < 1) {
                throw new IllegalArgumentException("The machine named '" + machine + "' does not appear in the topology file!");
            }
        } else if (clusterName == null) {
            ret = this.buildServerListWithServer(domain, server);
            if (ret == null || ret.size() < 1) {
                throw new IllegalArgumentException("The server named '" + domain + "." + server + "' does not appear in the topology file!");
            }
        } else {
            ret = this.buildServerListWithCluster(domain, clusterName);
            if (ret == null || ret.size() < 1) {
                throw new IllegalArgumentException("The cluster daemon named '" + domain + "." + clusterName + "' does not appear in the topology file!");
            }
        }
        return ret;
    }

    private List<ServerDomain> buildServerListWithCluster(String domain, String cluster) {
        ArrayList<ServerDomain> ret = new ArrayList<ServerDomain>();
        Topology.Domains.Domain.ClusterDaemons.ClusterDaemon workingCluster = null;
        Topology.Domains.Domain workingDomain = null;
        ArrayList<Topology.Domains.Domain.Servers.Server> servers = new ArrayList<Topology.Domains.Domain.Servers.Server>();
        for (Topology.Domains.Domain d : this.topology.getDomains().getDomain()) {
            if (d.getName().equals(domain)) {
                workingDomain = d;
                for (Topology.Domains.Domain.ClusterDaemons.ClusterDaemon cd : d.getClusterDaemons().getClusterDaemon()) {
                    if (!cd.getName().equals(cluster)) continue;
                    workingCluster = cd;
                    for (String serverName : cd.getServers().getServerName()) {
                        boolean found = false;
                        for (Topology.Domains.Domain.Servers.Server s : workingDomain.getServers().getServer()) {
                            if (!s.getName().equals(serverName)) continue;
                            if (servers.contains(s)) {
                                throw new IllegalArgumentException("Server '" + serverName + "' appears twice in the cluster daemon '" + cluster + "' server list!");
                            }
                            servers.add(s);
                            found = true;
                            break;
                        }
                        if (found) continue;
                        throw new IllegalArgumentException("Server '" + serverName + "' in the cluster daemon '" + cluster + "' server list does not appear in the topology!");
                    }
                }
            }
            if (workingCluster == null) continue;
            break;
        }
        for (Topology.Domains.Domain.Servers.Server s : servers) {
            ret.add(new ServerDomain(s, workingDomain));
        }
        return ret;
    }

    private List<ServerDomain> buildServerListWithServer(String domain, String server) {
        ArrayList<ServerDomain> ret = new ArrayList<ServerDomain>();
        for (Topology.Domains.Domain d : this.topology.getDomains().getDomain()) {
            if (!d.getName().equals(domain)) continue;
            for (Topology.Domains.Domain.Servers.Server s : d.getServers().getServer()) {
                if (!s.getName().equals(server)) continue;
                ret.add(new ServerDomain(s, d));
                break;
            }
            if (ret.isEmpty()) continue;
            break;
        }
        return ret;
    }

    private List<ServerDomain> buildServerListWithHostname(String machine) {
        ArrayList<ServerDomain> ret = new ArrayList<ServerDomain>();
        for (Topology.Domains.Domain d : this.topology.getDomains().getDomain()) {
            for (Topology.Domains.Domain.Servers.Server s : d.getServers().getServer()) {
                if (!s.getMachine().equals(machine)) continue;
                ret.add(new ServerDomain(s, d));
            }
        }
        return ret;
    }

    protected Topology.Domains.Domain.ClusterDaemons.ClusterDaemon mergeClusterDaemonAndDomainConf(Topology.Domains.Domain.ClusterDaemons.ClusterDaemon cd, Topology.Domains.Domain domain) {
        if (cd.getJonasRoot() == null) {
            cd.setJonasRoot(domain.getConfiguration().getGlobalOptions().getJonasRoot());
        }
        if (cd.getJavaHome() == null) {
            cd.setJavaHome(domain.getConfiguration().getGlobalOptions().getJdk());
        }
        return cd;
    }
}

