/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme.configApply;

import org.ow2.jasmine.deployme.generated.Configuration;
import org.ow2.jonas.tools.configurator.Jonas;
import org.ow2.jonas.tools.configurator.api.JonasConfigurator;

public class ConfigJonasApply {
    private JonasConfigurator jonasConf;

    public ConfigJonasApply(String jonasRoot) {
        Jonas jonas = new Jonas(jonasRoot);
        this.jonasConf = jonas.getJonasConfigurator();
    }

    public void setGlobalOptions(String serverName, String domainName, Configuration.GlobalOptions globalOptions) {
        if (globalOptions.getJdk() != null) {
            this.jonasConf.setJdk(globalOptions.getJdk());
        }
        if (globalOptions.getJavaOpts() != null) {
            this.jonasConf.setJavaOpts(globalOptions.getJavaOpts());
        }
        if (globalOptions.getJonasBase() != null) {
            this.jonasConf.setJonasBase(globalOptions.getJonasBase());
        }
        if (globalOptions.getJonasServices() != null) {
            this.jonasConf.setServices(globalOptions.getJonasServices());
        }
        this.jonasConf.setJonasName(serverName);
        this.jonasConf.setJonasDomain(domainName);
        this.jonasConf.setDiscoveryDomainName(domainName);
        if (globalOptions.getHost() != null) {
            this.jonasConf.setHost(globalOptions.getHost());
        }
        if (globalOptions.isJonasDevelopment() != null) {
            this.jonasConf.setJonasDevelopment(globalOptions.isJonasDevelopment());
        }
        if (globalOptions.getIrmiPort() != null) {
            this.jonasConf.setProtocolsIrmiPort(globalOptions.getIrmiPort().toString());
        }
        if (globalOptions.getIiopPort() != null) {
            this.jonasConf.setProtocolsIiopPort(globalOptions.getIiopPort().toString());
        }
        if (globalOptions.getJrmpPort() != null) {
            this.jonasConf.setProtocolsJrmpPort(globalOptions.getJrmpPort().toString());
        }
        if (globalOptions.getCmiPort() != null) {
            this.jonasConf.setProtocolsCmiPort(globalOptions.getCmiPort().toString());
        }
        if (globalOptions.getProtocolsList() != null) {
            this.jonasConf.setProtocolsList(globalOptions.getProtocolsList());
        }
        if (globalOptions.isJndiLocalCallOptimization() != null) {
            this.jonasConf.setProtocolsLocalCallOptimized(globalOptions.isJndiLocalCallOptimization());
        }
    }

    public void setSecurityManager(Configuration.SecurityManager securityManager) {
        if (securityManager.isActivation() != null) {
            this.jonasConf.setSecurityManagerActivated(securityManager.isActivation());
        }
    }

    public void setEjbClusteringConfiguration(Configuration.EjbClustering ejbClustering) {
        if (ejbClustering.isEjbClusteringActivated() != null) {
            this.jonasConf.setEjbClusteringActivated(ejbClustering.isEjbClusteringActivated());
        }
        if (ejbClustering.getMulticastAddress() != null) {
            this.jonasConf.setEjbClusteringMulticastAddress(ejbClustering.getMulticastAddress());
        }
        if (ejbClustering.getMulticastPort() != null) {
            this.jonasConf.setEjbClusteringMulticastPort(ejbClustering.getMulticastPort().toString());
        }
    }

    public void setJmsConfiguration(Configuration.Jms jms) {
        if (jms.getPort() != null) {
            this.jonasConf.setJmsPort(jms.getPort().toString());
        }
        if (jms.getQueues() != null) {
            this.jonasConf.setJmsQueues(jms.getQueues());
        }
        if (jms.getTopics() != null) {
            this.jonasConf.setJmsTopics(jms.getTopics());
        }
    }

    public void setJdbcConfiguration(Configuration.Jdbc jdbc) {
        if (jdbc.getDrivers() != null) {
            this.jonasConf.setJdbcDriverName(jdbc.getDrivers());
        }
        if (jdbc.getDsClass() != null) {
            this.jonasConf.setJdbcDatasourceClass(jdbc.getDsClass());
        }
        if (jdbc.getRaName() != null) {
            this.jonasConf.setJdbcResourceAdapterName(jdbc.getRaName());
        }
        if (jdbc.getJdbcCheckLevel() != null) {
            this.jonasConf.setJdbcCheckLevel(jdbc.getJdbcCheckLevel());
        }
        if (jdbc.getJdbcTestStatment() != null) {
            this.jonasConf.setJdbcTestStatement(jdbc.getJdbcTestStatment());
        }
        if (jdbc.getJndiname() != null) {
            this.jonasConf.setJdbcJndiName(jdbc.getJndiname());
        }
        if (jdbc.getMappername() != null) {
            this.jonasConf.setJdbcMappername(jdbc.getMappername());
        }
        if (jdbc.getPassword() != null) {
            this.jonasConf.setJdbcPassword(jdbc.getPassword());
        }
        if (jdbc.getRarlink() != null) {
            this.jonasConf.setJdbcRarlink(jdbc.getRarlink());
        }
        if (jdbc.getUrl() != null) {
            this.jonasConf.setJdbcUrl(jdbc.getUrl());
        }
        if (jdbc.getUser() != null) {
            this.jonasConf.setJdbcUser(jdbc.getUser());
        }
        if (jdbc.getPoolParameters() != null) {
            this.setJdbcPoolParameters(jdbc.getPoolParameters());
        }
    }

    protected void setJdbcPoolParameters(Configuration.Jdbc.PoolParameters params) {
        if (params.getPoolInit() != null) {
            this.jonasConf.setJdbcPoolInitialSize(params.getPoolInit().toString());
        }
        if (params.getPoolMax() != null) {
            this.jonasConf.setJdbcPoolMaximumSize(params.getPoolMax().toString());
        }
        if (params.getPoolMaxAgeMinutes() != null) {
            this.jonasConf.setJdbcPoolMaximumAgeMinutes(params.getPoolMaxAgeMinutes().toString());
        }
        if (params.getPoolMaxOpentime() != null) {
            this.jonasConf.setJdbcPoolMaximumOpenTime(params.getPoolMaxOpentime().toString());
        }
        if (params.getPoolMaxWaiters() != null) {
            this.jonasConf.setJdbcPoolMaximumNumberOfWaiters(params.getPoolMaxWaiters().toString());
        }
        if (params.getPoolMaxWaittime() != null) {
            this.jonasConf.setJdbcPoolMaximumWaitTime(params.getPoolMaxWaittime().toString());
        }
        if (params.getPoolMin() != null) {
            this.jonasConf.setJdbcPoolMinimumSize(params.getPoolMin().toString());
        }
        if (params.getPoolSamplingPeriod() != null) {
            this.jonasConf.setJdbcPoolSamplingPeriod(params.getPoolSamplingPeriod().toString());
        }
        if (params.getPstmtMax() != null) {
            this.jonasConf.setJdbcPoolMaximumNumberOfPreparedStatements(params.getPstmtMax().toString());
        }
    }

    public void setServiceHa(Configuration.Ha ha) {
        if (ha.isHaActivated() != null) {
            this.jonasConf.setHaActivated(ha.isHaActivated());
        }
        if (ha.getMulticastAddress() != null) {
            this.jonasConf.setHaMulticastAddress(ha.getMulticastAddress());
        }
        if (ha.getMulticastPort() != null) {
            this.jonasConf.setHaMulticastPort(ha.getMulticastPort().toString());
        }
    }

    public void setServiceWsdlPublisher(Configuration.WsdlPublisher ws) {
        if (ws.getWsdlFileDir() != null) {
            this.jonasConf.setWsdlPublisherFileDirectory(ws.getWsdlFileDir());
        }
        if (ws.getWsdlFilename() != null) {
            this.jonasConf.setWsdlPublisherFileName(ws.getWsdlFilename());
        }
    }

    public void setServiceMail(Configuration.Mail mail) {
        if (mail.getFactoryName() != null) {
            this.jonasConf.setMailFactoryName(mail.getFactoryName());
        }
        if (mail.getFactoryType() != null) {
            this.jonasConf.setMailFactoryType(mail.getFactoryType());
        }
    }

    public void setServiceDiscovery(Configuration.Discovery discovery) {
        if (discovery.isMasterActivation() != null) {
            this.jonasConf.setDiscoveryMasterActivated(discovery.isMasterActivation());
        }
        if (discovery.getGreetingPort() != null) {
            this.jonasConf.setDiscoveryGreetingPort(discovery.getGreetingPort().toString());
        }
        if (discovery.getMulticastAddress() != null) {
            this.jonasConf.setDiscoveryMulticastAddress(discovery.getMulticastAddress());
        }
        if (discovery.getMulticastPort() != null) {
            this.jonasConf.setDiscoveryMulticastPort(discovery.getMulticastPort().toString());
        }
        if (discovery.getSourcePort() != null) {
            this.jonasConf.setDiscoverySourcePort(discovery.getSourcePort().toString());
        }
        if (discovery.getTtl() != null) {
            this.jonasConf.setDiscoveryTTL(discovery.getTtl());
        }
    }

    public void setServiceDb(Configuration.Db db) {
        if (db.getPort() != null) {
            this.jonasConf.setDbPort(db.getPort().toString());
        }
    }

    public void setServiceWeb(Configuration.Web web) {
        if (web.isAjpActivated() != null) {
            this.jonasConf.setAjpConnectorActivation(web.isAjpActivated());
        }
        if (web.isHttpReplicationActivated() != null) {
            this.jonasConf.setHttpSessionReplicationActivation(web.isHttpReplicationActivated());
        }
        if (web.isHttpsActivated() != null) {
            this.jonasConf.setHttpsConnectorActivation(web.isHttpsActivated());
        }
        if (web.getJvmRoute() != null) {
            this.jonasConf.setJvmRoute(web.getJvmRoute());
        }
        if (web.getAjpConf() != null) {
            this.setAjpConf(web.getAjpConf());
        }
        if (web.getHttpConf() != null) {
            this.setHttpConf(web.getHttpConf());
        }
        if (web.getHttpReplicationConf() != null) {
            this.setHttpReplicationConf(web.getHttpReplicationConf());
        }
        if (web.getHttpsConf() != null) {
            this.setHttpsConf(web.getHttpsConf());
        }
    }

    protected void setAjpConf(Configuration.Web.AjpConf ajpConf) {
        if (ajpConf.getWebConf().getMaxSpareThreads() != null) {
            this.jonasConf.setAjpMaxSpareThreads(ajpConf.getWebConf().getMaxSpareThreads().toString());
        }
        if (ajpConf.getWebConf().getMaxThreads() != null) {
            this.jonasConf.setAjpMaxThreads(ajpConf.getWebConf().getMaxThreads().toString());
        }
        if (ajpConf.getWebConf().getMinSpareThreads() != null) {
            this.jonasConf.setAjpMinSpareThreads(ajpConf.getWebConf().getMinSpareThreads().toString());
        }
        if (ajpConf.getWebConf().getPort() != null) {
            this.jonasConf.setAjpPort(ajpConf.getWebConf().getPort().toString());
        }
    }

    protected void setHttpConf(Configuration.Web.HttpConf httpConf) {
        if (httpConf.getWebConf().getMaxSpareThreads() != null) {
            this.jonasConf.setHttpMaxSpareThreads(httpConf.getWebConf().getMaxSpareThreads().toString());
        }
        if (httpConf.getWebConf().getMaxThreads() != null) {
            this.jonasConf.setHttpMaxThreads(httpConf.getWebConf().getMaxThreads().toString());
        }
        if (httpConf.getWebConf().getMinSpareThreads() != null) {
            this.jonasConf.setHttpMinSpareThreads(httpConf.getWebConf().getMinSpareThreads().toString());
        }
        if (httpConf.getWebConf().getPort() != null) {
            this.jonasConf.setHttpPort(httpConf.getWebConf().getPort().toString());
        }
    }

    protected void setHttpReplicationConf(Configuration.Web.HttpReplicationConf httpReplicationConf) {
        if (httpReplicationConf.getClusterName() != null) {
            this.jonasConf.setHttpReplicationClusterName(httpReplicationConf.getClusterName());
        }
        if (httpReplicationConf.getListenPort() != null) {
            this.jonasConf.setHttpReplicationListenPort(httpReplicationConf.getListenPort().toString());
        }
        if (httpReplicationConf.getMulticastAddress() != null) {
            this.jonasConf.setHttpReplicationMulticastAddress(httpReplicationConf.getMulticastAddress());
        }
        if (httpReplicationConf.getMulticastPort() != null) {
            this.jonasConf.setHttpReplicationMulticastPort(httpReplicationConf.getMulticastPort().toString());
        }
    }

    protected void setHttpsConf(Configuration.Web.HttpsConf httpsConf) {
        if (httpsConf.getWebConf().getMaxSpareThreads() != null) {
            this.jonasConf.setHttpsMaxSpareThreads(httpsConf.getWebConf().getMaxSpareThreads().toString());
        }
        if (httpsConf.getWebConf().getMaxThreads() != null) {
            this.jonasConf.setHttpsMaxThreads(httpsConf.getWebConf().getMaxThreads().toString());
        }
        if (httpsConf.getWebConf().getMinSpareThreads() != null) {
            this.jonasConf.setHttpsMinSpareThreads(httpsConf.getWebConf().getMinSpareThreads().toString());
        }
        if (httpsConf.getWebConf().getPort() != null) {
            this.jonasConf.setHttpsPort(httpsConf.getWebConf().getPort().toString());
        }
    }

    public void execute() {
        this.jonasConf.execute();
    }
}

