/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme.utils;

public class CommandLine {
    public static String ERROR_TOPOLOGY_NOT_SET = "The 'topologyFile' option is mandatory";
    public static String ERROR_NO_OPTIONS = "No options set. You must set one of the 'machineName', 'domainName', 'clusterName' or 'serverName' options";
    public static String ERROR_SERVER_CLUSTER_DOMAIN = "One of the 'serverName' or 'clusterName' options must be set when the 'domainName' option is set";
    public static String ERROR_DOMAIN_SERVER_CLUSTER = "The 'clusterName' and 'serverName' options require the 'domainName' to be set";
    public static String ERROR_CLUSTER_SERVER = "Only one of the 'clusterName' and 'serverName' options must be set";
    public static String ERROR_MACHINE_DOMAIN_SERVER_CLUSTER = "The 'machineName' option must not be set when one of the 'clusterName', 'domainName' or 'serverName' options are set";
    public static String commandLineVerbose = "verbose";
    public static String commandLineServerName = "serverName";
    public static String commandLineDomainName = "domainName";
    public static String commandLineMachineName = "machineName";
    public static String commandLineClusterName = "clusterName";
    public static String commandLinetopologyFileName = "topologyFile";
    protected boolean verbose = false;
    protected String topologyFile = null;
    protected String serverName = null;
    protected String domainName = null;
    protected String machineName = null;
    protected String clusterName;

    public boolean getVerbose() {
        return this.verbose;
    }

    public String getTopologyFile() {
        return this.topologyFile;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void addValue(String argName, String argValue) {
        if (argName.equals(commandLineVerbose)) {
            this.verbose = true;
        } else if (argName.equals(commandLineServerName)) {
            this.serverName = argValue;
        } else if (argName.equals(commandLineDomainName)) {
            this.domainName = argValue;
        } else if (argName.equals(commandLinetopologyFileName)) {
            this.topologyFile = argValue;
        } else if (argName.equals(commandLineMachineName)) {
            this.machineName = argValue;
        } else if (argName.equals(commandLineClusterName)) {
            this.clusterName = argValue;
        } else {
            throw new IllegalArgumentException("'" + argName + "' is not a valid JASMINe Deploy ME option.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkCommandLine() {
        if (this.topologyFile == null) {
            throw new IllegalArgumentException(ERROR_TOPOLOGY_NOT_SET);
        }
        if (this.domainName != null) {
            if (this.serverName != null) {
                if (this.clusterName != null) {
                    throw new IllegalArgumentException(ERROR_CLUSTER_SERVER);
                }
                if (this.machineName == null) return;
                throw new IllegalArgumentException(ERROR_MACHINE_DOMAIN_SERVER_CLUSTER);
            }
            if (this.clusterName != null) {
                if (this.machineName == null) return;
                throw new IllegalArgumentException(ERROR_MACHINE_DOMAIN_SERVER_CLUSTER);
            }
            if (this.machineName == null) throw new IllegalArgumentException(ERROR_SERVER_CLUSTER_DOMAIN);
            throw new IllegalArgumentException(ERROR_MACHINE_DOMAIN_SERVER_CLUSTER);
        }
        if (this.serverName != null) {
            throw new IllegalArgumentException(ERROR_DOMAIN_SERVER_CLUSTER);
        }
        if (this.clusterName != null) {
            throw new IllegalArgumentException(ERROR_DOMAIN_SERVER_CLUSTER);
        }
        if (this.machineName != null) return;
        throw new IllegalArgumentException(ERROR_NO_OPTIONS);
    }
}

