/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ConfiguratorBuilder.java 6395 2010-04-27 09:44:15Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.deployme;

import org.ow2.jasmine.deployme.generated.Configuration;
import org.ow2.jasmine.deployme.generated.WebConf;
import org.ow2.jasmine.deployme.generated.Configuration.Jdbc.JdbcRa;
import org.ow2.jasmine.deployme.utils.ServerDomain;

/**
 * This class is used to build a config from a server and its domain Server
 * parameter are prioritaty to domain parameters
 * 
 * @author Remy Bresson
 */
public class ConfiguratorBuilder {

    /**
     * The resulting configuration
     */
    protected Configuration config;

    /**
     * Build the configuration
     */
    public ConfiguratorBuilder(final ServerDomain sd) {
        Configuration config_domain = sd.getDomain().getConfiguration();
        Configuration config_server = sd.getServer().getConfiguration();

        this.config = new Configuration();

        this.setAConfig(config_domain);
        this.setAConfig(config_server);
    }

    /**
     * Get the configuration
     * 
     * @return the config
     */
    public Configuration getConfig() {
        return this.config;
    }

    /**
     * Set a configuration from the config<br>
     * TODO: Read existing parameter in ConfiguratorBuilder.config will be
     * replaced
     * 
     * @param confToRead The configuration to assign
     */
    private void setAConfig(final Configuration confToRead) {
        if (confToRead != null) {
            this.setGlobalOptions(confToRead);
            this.setServiceDb(confToRead);
            this.setServiceDiscovery(confToRead);
            this.setServiceHa(confToRead);
            this.setServiceMail(confToRead);
            this.setServiceWeb(confToRead);
            this.setServiceWsdlPublisher(confToRead);
            this.setSecurityManager(confToRead);
            this.setEjbClustering(confToRead);
            this.setJms(confToRead);
            this.setJdbc(confToRead);
        }
    }

    /**
     * Set the global jonas parameters
     * 
     * @param confToRead The configuration to assign
     */
    private void setGlobalOptions(final Configuration confToRead) {
        if (this.config.getGlobalOptions() == null) {
            this.config.setGlobalOptions(new Configuration.GlobalOptions());
        }

        if (confToRead.getGlobalOptions() != null) {
            if (confToRead.getGlobalOptions().getJavaHome() != null) {
                this.config.getGlobalOptions().setJavaHome(confToRead.getGlobalOptions().getJavaHome());
            }
            if (confToRead.getGlobalOptions().getJonasBase() != null) {
                this.config.getGlobalOptions().setJonasBase(confToRead.getGlobalOptions().getJonasBase());
            }
            if (confToRead.getGlobalOptions().getJavaOpts() != null) {
                this.config.getGlobalOptions().setJavaOpts(confToRead.getGlobalOptions().getJavaOpts());
            }
            if (confToRead.getGlobalOptions().getJonasRoot() != null) {
                this.config.getGlobalOptions().setJonasRoot(confToRead.getGlobalOptions().getJonasRoot());
            }
            if (confToRead.getGlobalOptions().getJonasServices() != null) {
                this.config.getGlobalOptions().setJonasServices(confToRead.getGlobalOptions().getJonasServices());
            }
            if (confToRead.getGlobalOptions().isJonasDevelopment() != null) {
                this.config.getGlobalOptions().setJonasDevelopment(confToRead.getGlobalOptions().isJonasDevelopment());
            }
            if (confToRead.getGlobalOptions().getHost() != null) {
                this.config.getGlobalOptions().setHost(confToRead.getGlobalOptions().getHost());
            }
            if (confToRead.getGlobalOptions().isJndiLocalCallOptimization() != null) {
                this.config.getGlobalOptions().setJndiLocalCallOptimization(
                    confToRead.getGlobalOptions().isJndiLocalCallOptimization());
            }
            if (confToRead.getGlobalOptions().getIiopPort() != null) {
                this.config.getGlobalOptions().setIiopPort(confToRead.getGlobalOptions().getIiopPort());
            }
            if (confToRead.getGlobalOptions().getIrmiPort() != null) {
                this.config.getGlobalOptions().setIrmiPort(confToRead.getGlobalOptions().getIrmiPort());
            }
            if (confToRead.getGlobalOptions().getJrmpPort() != null) {
                this.config.getGlobalOptions().setJrmpPort(confToRead.getGlobalOptions().getJrmpPort());
            }
            if (confToRead.getGlobalOptions().getCmiPort() != null) {
                this.config.getGlobalOptions().setCmiPort(confToRead.getGlobalOptions().getCmiPort());
            }
            if (confToRead.getGlobalOptions().getProtocolsList() != null) {
                this.config.getGlobalOptions().setProtocolsList(confToRead.getGlobalOptions().getProtocolsList());
            }
        }
    }

    /**
     * Set the web configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setServiceWeb(final Configuration confToRead) {
        if (this.config.getWeb() == null) {
            this.config.setWeb(new Configuration.Web());
        }

        if (confToRead.getWeb() != null) {
            if (confToRead.getWeb().isAjpActivated() != null) {
                this.config.getWeb().setAjpActivated(confToRead.getWeb().isAjpActivated());
            }
            if (confToRead.getWeb().isHttpReplicationActivated() != null) {
                this.config.getWeb().setHttpReplicationActivated(confToRead.getWeb().isHttpReplicationActivated());
            }
            if (confToRead.getWeb().isHttpsActivated() != null) {
                this.config.getWeb().setHttpsActivated(confToRead.getWeb().isHttpsActivated());
            }
            if (confToRead.getWeb().getJvmRoute() != null) {
                this.config.getWeb().setJvmRoute(confToRead.getWeb().getJvmRoute());
            }

            if (this.config.getWeb().getAjpConf() == null) {
                this.config.getWeb().setAjpConf(new Configuration.Web.AjpConf());
            }
            if (this.config.getWeb().getAjpConf().getWebConf() == null) {
                this.config.getWeb().getAjpConf().setWebConf(new WebConf());
            }
            if (confToRead.getWeb().getAjpConf() != null) {
                if (confToRead.getWeb().getAjpConf().getWebConf() != null) {
                    this.buildWebConf(confToRead.getWeb().getAjpConf().getWebConf(), this.config.getWeb().getAjpConf()
                        .getWebConf());
                }
            }

            if (this.config.getWeb().getHttpsConf() == null) {
                this.config.getWeb().setHttpsConf(new Configuration.Web.HttpsConf());
            }
            if (this.config.getWeb().getHttpsConf().getWebConf() == null) {
                this.config.getWeb().getHttpsConf().setWebConf(new WebConf());
            }
            if (confToRead.getWeb().getHttpsConf() != null) {
                if (confToRead.getWeb().getHttpsConf().getWebConf() != null) {
                    this.buildWebConf(confToRead.getWeb().getHttpsConf().getWebConf(), this.config.getWeb().getHttpsConf()
                        .getWebConf());
                }
            }

            if (this.config.getWeb().getHttpConf() == null) {
                this.config.getWeb().setHttpConf(new Configuration.Web.HttpConf());
            }
            if (this.config.getWeb().getHttpConf().getWebConf() == null) {
                this.config.getWeb().getHttpConf().setWebConf(new WebConf());
            }

            if (confToRead.getWeb().getHttpConf() != null) {
                if (confToRead.getWeb().getHttpConf().getWebConf() != null) {
                    this.buildWebConf(confToRead.getWeb().getHttpConf().getWebConf(), this.config.getWeb().getHttpConf()
                        .getWebConf());
                }
            }

            if (this.config.getWeb().getHttpReplicationConf() == null) {
                this.config.getWeb().setHttpReplicationConf(new Configuration.Web.HttpReplicationConf());
            }

            if (confToRead.getWeb().getHttpReplicationConf() != null) {
                if (confToRead.getWeb().getHttpReplicationConf().getClusterName() != null) {
                    this.config.getWeb().getHttpReplicationConf().setClusterName(
                        confToRead.getWeb().getHttpReplicationConf().getClusterName());
                }
                if (confToRead.getWeb().getHttpReplicationConf().getListenPort() != null) {
                    this.config.getWeb().getHttpReplicationConf().setListenPort(
                        confToRead.getWeb().getHttpReplicationConf().getListenPort());
                }
                if (confToRead.getWeb().getHttpReplicationConf().getMulticastAddress() != null) {
                    this.config.getWeb().getHttpReplicationConf().setMulticastAddress(
                        confToRead.getWeb().getHttpReplicationConf().getMulticastAddress());
                }
                if (confToRead.getWeb().getHttpReplicationConf().getMulticastPort() != null) {
                    this.config.getWeb().getHttpReplicationConf().setMulticastPort(
                        confToRead.getWeb().getHttpReplicationConf().getMulticastPort());
                }
            }
        }
    }

    /**
     * Set the database configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setServiceDb(final Configuration confToRead) {
        if (this.config.getDb() == null) {
            this.config.setDb(new Configuration.Db());
        }

        if (confToRead.getDb() != null) {
            if (confToRead.getDb().getPort() != null) {
                this.config.getDb().setPort(confToRead.getDb().getPort());
            }
            if (confToRead.getDb().getName() != null) {
                this.config.getDb().setName(confToRead.getDb().getName());
            }
            if (confToRead.getDb().getUsers() != null) {
                this.config.getDb().setUsers(confToRead.getDb().getUsers());
            }
        }
    }

    /**
     * Set the discovery service configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setServiceDiscovery(final Configuration confToRead) {
        if (this.config.getDiscovery() == null) {
            this.config.setDiscovery(new Configuration.Discovery());
        }

        if (confToRead.getDiscovery() != null) {
            if (confToRead.getDiscovery().getGreetingPort() != null) {
                this.config.getDiscovery().setGreetingPort(confToRead.getDiscovery().getGreetingPort());
            }
            if (confToRead.getDiscovery().isMasterActivation() != null) {
                this.config.getDiscovery().setMasterActivation(confToRead.getDiscovery().isMasterActivation());
            }
            if (confToRead.getDiscovery().getMulticastAddress() != null) {
                this.config.getDiscovery().setMulticastAddress(confToRead.getDiscovery().getMulticastAddress());
            }
            if (confToRead.getDiscovery().getMulticastPort() != null) {
                this.config.getDiscovery().setMulticastPort(confToRead.getDiscovery().getMulticastPort());
            }
            if (confToRead.getDiscovery().getSourcePort() != null) {
                this.config.getDiscovery().setSourcePort(confToRead.getDiscovery().getSourcePort());
            }
            if (confToRead.getDiscovery().getTtl() != null) {
                this.config.getDiscovery().setTtl(confToRead.getDiscovery().getTtl());
            }
        }
    }

    /**
     * Set the mail service configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setServiceMail(final Configuration confToRead) {
        if (this.config.getMail() == null) {
            this.config.setMail(new Configuration.Mail());
        }

        if (confToRead.getMail() != null) {
            if (confToRead.getMail().getFactoryName() != null) {
                this.config.getMail().setFactoryName(confToRead.getMail().getFactoryName());
            }
            if (confToRead.getMail().getFactoryType() != null) {
                this.config.getMail().setFactoryType(confToRead.getMail().getFactoryType());
            }
        }
    }

    /**
     * Set the wsdl publisher service configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setServiceWsdlPublisher(final Configuration confToRead) {
        if (this.config.getWsdlPublisher() == null) {
            this.config.setWsdlPublisher(new Configuration.WsdlPublisher());
        }

        if (confToRead.getWsdlPublisher() != null) {
            if (confToRead.getWsdlPublisher().getWsdlFileDir() != null) {
                this.config.getWsdlPublisher().setWsdlFileDir(confToRead.getWsdlPublisher().getWsdlFileDir());
            }
            if (confToRead.getWsdlPublisher().getWsdlFilename() != null) {
                this.config.getWsdlPublisher().setWsdlFilename(confToRead.getWsdlPublisher().getWsdlFilename());
            }
        }
    }

    /**
     * Set the ha service configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setServiceHa(final Configuration confToRead) {
        if (this.config.getHa() == null) {
            this.config.setHa(new Configuration.Ha());
        }

        if (confToRead.getHa() != null) {
            if (confToRead.getHa().isHaActivated() != null) {
                this.config.getHa().setHaActivated(confToRead.getHa().isHaActivated());
            }
            if (confToRead.getHa().getMulticastAddress() != null) {
                this.config.getHa().setMulticastAddress(confToRead.getHa().getMulticastAddress());
            }
            if (confToRead.getHa().getMulticastPort() != null) {
                this.config.getHa().setMulticastPort(confToRead.getHa().getMulticastPort());
            }
        }
    }

    /**
     * Set the webconf configuration (http, https, ajp)
     * 
     * @param config The webconf to set
     * @param webConfToRead The web configuration to assign
     */
    private void buildWebConf(final WebConf webConfToRead, final WebConf config) {
        if (webConfToRead.getMaxSpareThreads() != null) {
            config.setMaxSpareThreads(webConfToRead.getMaxSpareThreads());
        }
        if (webConfToRead.getMaxThreads() != null) {
            config.setMaxThreads(webConfToRead.getMaxThreads());
        }
        if (webConfToRead.getMinSpareThreads() != null) {
            config.setMinSpareThreads(webConfToRead.getMinSpareThreads());
        }
        if (webConfToRead.getPort() != null) {
            config.setPort(webConfToRead.getPort());
        }
    }

    /**
     * Set the security manager configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setSecurityManager(final Configuration confToRead) {

        if (this.config.getSecurityManager() == null) {
            this.config.setSecurityManager(new Configuration.SecurityManager());
        }

        if (confToRead.getSecurityManager() != null) {

            if (confToRead.getSecurityManager().isActivation() != null) {
                this.config.getSecurityManager().setActivation(confToRead.getSecurityManager().isActivation());
            }
        }
    }

    /**
     * Set the ejb clustering configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setEjbClustering(final Configuration confToRead) {

        if (this.config.getEjbClustering() == null) {
            this.config.setEjbClustering(new Configuration.EjbClustering());
        }

        if (confToRead.getEjbClustering() != null) {
            if (confToRead.getEjbClustering().isEjbClusteringActivated() != null) {
                this.config.getEjbClustering().setEjbClusteringActivated(
                    confToRead.getEjbClustering().isEjbClusteringActivated());
            }
            if (confToRead.getEjbClustering().getMulticastAddress() != null) {
                this.config.getEjbClustering().setMulticastAddress(confToRead.getEjbClustering().getMulticastAddress());
            }
            if (confToRead.getEjbClustering().getMulticastPort() != null) {
                this.config.getEjbClustering().setMulticastPort(confToRead.getEjbClustering().getMulticastPort());
            }
        }
    }

    /**
     * Set the jms configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setJms(final Configuration confToRead) {

        if (this.config.getJms() == null) {
            this.config.setJms(new Configuration.Jms());
        }

        if (confToRead.getJms() != null) {
            if (confToRead.getJms().getPort() != null) {
                this.config.getJms().setPort(confToRead.getJms().getPort());
            }
            if (confToRead.getJms().getQueues() != null) {
                this.config.getJms().setQueues(confToRead.getJms().getQueues());
            }
            if (confToRead.getJms().getTopics() != null) {
                this.config.getJms().setTopics(confToRead.getJms().getTopics());
            }
        }
    }

    /**
     * Set the jdbc configuration
     * 
     * @param confToRead The configuration to assign
     */
    private void setJdbc(final Configuration confToRead) {

        if (this.config.getJdbc() == null) {
            this.config.setJdbc(new Configuration.Jdbc());
        }

        if (confToRead.getJdbc() != null) {
            for (JdbcRa confToRead_jdbcRa : confToRead.getJdbc().getJdbcRa()) {
                JdbcRa oldJdbcRa = null;
                for (JdbcRa config_jdbcRa : this.config.getJdbc().getJdbcRa()) {
                    if (confToRead_jdbcRa.getRaName().equals(config_jdbcRa.getRaName())) {
                        oldJdbcRa = config_jdbcRa;
                        break;
                    }
                }
                if (oldJdbcRa == null) {
                    oldJdbcRa = new JdbcRa();
                    oldJdbcRa.setRaName(confToRead_jdbcRa.getRaName());
                    this.config.getJdbc().getJdbcRa().add(oldJdbcRa);
                }

                if (confToRead_jdbcRa.getDrivers() != null) {
                    oldJdbcRa.setDrivers(confToRead_jdbcRa.getDrivers());
                }
                if (confToRead_jdbcRa.getDsClass() != null) {
                    oldJdbcRa.setDsClass(confToRead_jdbcRa.getDsClass());
                }
                if (confToRead_jdbcRa.getJdbcCheckLevel() != null) {
                    oldJdbcRa.setJdbcCheckLevel(confToRead_jdbcRa.getJdbcCheckLevel());
                }
                if (confToRead_jdbcRa.getJdbcTestStatment() != null) {
                    oldJdbcRa.setJdbcTestStatment(confToRead_jdbcRa.getJdbcTestStatment());
                }
                if (confToRead_jdbcRa.getJndiname() != null) {
                    oldJdbcRa.setJndiname(confToRead_jdbcRa.getJndiname());
                }
                if (confToRead_jdbcRa.getMappername() != null) {
                    oldJdbcRa.setMappername(confToRead_jdbcRa.getMappername());
                }
                if (confToRead_jdbcRa.getPassword() != null) {
                    oldJdbcRa.setPassword(confToRead_jdbcRa.getPassword());
                }
                if (confToRead_jdbcRa.getRarlink() != null) {
                    oldJdbcRa.setRarlink(confToRead_jdbcRa.getRarlink());
                }
                if (confToRead_jdbcRa.getUrl() != null) {
                    oldJdbcRa.setUrl(confToRead_jdbcRa.getUrl());
                }
                if (confToRead_jdbcRa.getUser() != null) {
                    oldJdbcRa.setUser(confToRead_jdbcRa.getUser());
                }

                if (oldJdbcRa.getPoolParameters() == null) {
                    oldJdbcRa.setPoolParameters(new Configuration.Jdbc.JdbcRa.PoolParameters());
                }
                if (confToRead_jdbcRa.getPoolParameters() != null) {
                    oldJdbcRa.getPoolParameters().setPoolInit(confToRead_jdbcRa.getPoolParameters().getPoolInit());
                    oldJdbcRa.getPoolParameters().setPoolMax(confToRead_jdbcRa.getPoolParameters().getPoolMax());
                    oldJdbcRa.getPoolParameters().setPoolMaxAgeMinutes(
                        confToRead_jdbcRa.getPoolParameters().getPoolMaxAgeMinutes());
                    oldJdbcRa.getPoolParameters()
                        .setPoolMaxOpentime(confToRead_jdbcRa.getPoolParameters().getPoolMaxOpentime());
                    oldJdbcRa.getPoolParameters().setPoolMaxWaiters(confToRead_jdbcRa.getPoolParameters().getPoolMaxWaiters());
                    oldJdbcRa.getPoolParameters()
                        .setPoolMaxWaittime(confToRead_jdbcRa.getPoolParameters().getPoolMaxWaittime());
                    oldJdbcRa.getPoolParameters().setPoolMin(confToRead_jdbcRa.getPoolParameters().getPoolMin());
                    oldJdbcRa.getPoolParameters().setPoolSamplingPeriod(
                        confToRead_jdbcRa.getPoolParameters().getPoolSamplingPeriod());
                    oldJdbcRa.getPoolParameters().setPstmtMax(confToRead_jdbcRa.getPoolParameters().getPstmtMax());
                }
            }
        }
    }
}
