/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CommandLine.java 2789 2008-11-25 14:35:20Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.deployme.utils;

/**
 * Represent the command line arguments
 * 
 * @author Remy Bresson
 */
public class CommandLine {

    public static String ERROR_TOPOLOGY_NOT_SET = "The 'topologyFile' option is mandatory";

    public static String ERROR_NO_OPTIONS = "No options set. You must set one of the 'machineName', 'domainName', 'clusterName'"
        + " or 'serverName' options";

    public static String ERROR_SERVER_CLUSTER_DOMAIN = "One of the 'serverName' or 'clusterName' options must be set when the"
        + " 'domainName' option is set";

    public static String ERROR_DOMAIN_SERVER_CLUSTER = "The 'clusterName' and 'serverName' options require the 'domainName' "
        + "to be set";

    public static String ERROR_CLUSTER_SERVER = "Only one of the 'clusterName' and 'serverName' options must be set";

    public static String ERROR_MACHINE_DOMAIN_SERVER_CLUSTER = "The 'machineName' option must not be set when one of the "
        + "'clusterName', 'domainName' or 'serverName' options are set";

    /**
     * key word to define verbose mode on the command line. Use associated with
     * addValue()
     */
    public static String commandLineVerbose = "verbose";

    /**
     * key word to define server name on the command line. Use associated with
     * addValue()
     */
    public static String commandLineServerName = "serverName";

    /**
     * key word to define domain name on the command line. Use associated with
     * addValue()
     */
    public static String commandLineDomainName = "domainName";

    /**
     * key word to define machine name on the command line. Use associated with
     * addValue()
     */
    public static String commandLineMachineName = "machineName";

    /**
     * key word to define cluster name on the command line. Use associated with
     * addValue()
     */
    public static String commandLineClusterName = "clusterName";

    /**
     * key word to define topology file name on the command line. Use associated
     * with addValue()
     */
    public static String commandLinetopologyFileName = "topologyFile";

    /**
     * Verbose?
     */
    protected boolean verbose;

    /**
     * Toplogy file path
     */
    protected String topologyFile;

    /**
     * Server name
     */
    protected String serverName;

    /**
     * Domain name
     */
    protected String domainName;

    /**
     * Host name
     */
    protected String machineName;

    /**
     * Cluster name
     */
    protected String clusterName;

    /**
     * Default constructor
     */
    public CommandLine() {
        this.verbose = false;
        this.topologyFile = null;
        this.serverName = null;
        this.domainName = null;
        this.machineName = null;
    }

    /**
     * return if verbose
     * 
     * @return if verbose
     */
    public boolean getVerbose() {
        return this.verbose;
    }

    /**
     * return the topologyFile
     * 
     * @return the topologyFile
     */
    public String getTopologyFile() {
        return this.topologyFile;
    }

    /**
     * return the serverName
     * 
     * @return the serverName
     */
    public String getServerName() {
        return this.serverName;
    }

    /**
     * return the domainName
     * 
     * @return the domainName
     */
    public String getDomainName() {
        return this.domainName;
    }

    /**
     * return the machineName
     * 
     * @return the machineName
     */
    public String getMachineName() {
        return this.machineName;
    }

    /**
     * @return the clusterName
     */
    public String getClusterName() {
        return this.clusterName;
    }

    /**
     * Record a value of the command line.
     * 
     * @param argName Name of the value to record
     * @param argValue Value to record
     */
    public void addValue(final String argName, final String argValue) {
        if (argName.equals(CommandLine.commandLineVerbose)) {
            this.verbose = true;
        } else if (argName.equals(CommandLine.commandLineServerName)) {
            this.serverName = argValue;
        } else if (argName.equals(CommandLine.commandLineDomainName)) {
            this.domainName = argValue;
        } else if (argName.equals(CommandLine.commandLinetopologyFileName)) {
            this.topologyFile = argValue;
        } else if (argName.equals(CommandLine.commandLineMachineName)) {
            this.machineName = argValue;
        } else if (argName.equals(CommandLine.commandLineClusterName)) {
            this.clusterName = argValue;
        } else {
            throw new IllegalArgumentException("'" + argName + "' is not a valid JASMINe Deploy ME option.");
        }
    }

    /**
     * Check if the command line contains all what we need
     */
    public void checkCommandLine() {
        if (this.topologyFile == null) {
            throw new IllegalArgumentException(ERROR_TOPOLOGY_NOT_SET);
        }

        if (this.domainName != null) {
            if (this.serverName != null) {
                if (this.clusterName != null) {
                    throw new IllegalArgumentException(ERROR_CLUSTER_SERVER);
                } else { // cluster == null
                    if (this.machineName != null) {
                        throw new IllegalArgumentException(ERROR_MACHINE_DOMAIN_SERVER_CLUSTER);
                    } else {
                        // OK : usage domain.server
                    }
                }
            } else { // server == null
                if (this.clusterName != null) {
                    if (this.machineName != null) {
                        throw new IllegalArgumentException(ERROR_MACHINE_DOMAIN_SERVER_CLUSTER);
                    } else {
                        // OK : usage domain.cluster
                    }
                } else {
                    if (this.machineName != null) {
                        throw new IllegalArgumentException(ERROR_MACHINE_DOMAIN_SERVER_CLUSTER);
                    } else {
                        throw new IllegalArgumentException(ERROR_SERVER_CLUSTER_DOMAIN);
                    }
                }
            }
        } else { // domain == null
            if (this.serverName != null) {
                throw new IllegalArgumentException(ERROR_DOMAIN_SERVER_CLUSTER);
            } else { // server == null
                if (this.clusterName != null) {
                    throw new IllegalArgumentException(ERROR_DOMAIN_SERVER_CLUSTER);
                } else {
                    if (this.machineName != null) {
                        // OK : usage machine
                    } else {
                        throw new IllegalArgumentException(ERROR_NO_OPTIONS);
                    }
                }
            }
        }
    }
}
