/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme.configApply;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;
import org.ow2.jasmine.deployme.configApply.ConfigClusterApply;
import org.ow2.jasmine.deployme.configApply.ConfigJonasApply;
import org.ow2.jasmine.deployme.generated.Configuration;
import org.ow2.jasmine.deployme.generated.Topology;
import org.ow2.jasmine.deployme.utils.ServerDomain;

public class Configurator {
    protected static Logger logger = Logger.getLogger(Configurator.class.getName());

    public static void rmdir(File directory) {
        if (directory != null) {
            if (directory.isDirectory()) {
                for (File element : directory.listFiles()) {
                    if (element.isDirectory()) {
                        Configurator.rmdir(element);
                        continue;
                    }
                    element.delete();
                }
            }
            directory.delete();
        }
    }

    public static void setClusterAConfiguration(String domainName, Topology.Domains.Domain.ClusterDaemons.ClusterDaemon cluster, String jonasRoot) {
        logger.info("Starting configuration set up for cluster " + cluster.getName() + " in directory " + cluster.getJonasBasePrefix());
        if (cluster.getJonasBasePrefix() != null) {
            File prefix = new File(cluster.getJonasBasePrefix());
            Configurator.rmdir(prefix);
            cluster.setJonasBasePrefix(prefix.getAbsolutePath());
        }
        cluster.setJonasRoot(jonasRoot);
        ConfigClusterApply apply = new ConfigClusterApply(jonasRoot);
        apply.setClusterConf(domainName, cluster);
        apply.execute();
        Configurator.createScripts(cluster.getJavaHome(), null, cluster.getJonasRoot(), cluster.getJonasBasePrefix(), domainName, cluster.getName());
        logger.info("Cluster " + cluster.getName() + " configured successfully");
    }

    public static void setClusterAConfiguration(String domainName, Topology.Domains.Domain.ClusterDaemons.ClusterDaemon cluster) {
        if (cluster.getJonasRoot() == null) {
            throw new IllegalArgumentException("The topology file doesn't define any JONAS_ROOT");
        }
        Configurator.setClusterAConfiguration(domainName, cluster, cluster.getJonasRoot());
    }

    public static void setAConfiguration(Configuration config, ServerDomain sd, String jonasRoot) {
        logger.info("Starting configuration set up for server " + sd + " in directory " + config.getGlobalOptions().getJonasBase());
        if (config.getGlobalOptions() != null) {
            config.getGlobalOptions().setJonasRoot(jonasRoot);
            if (config.getGlobalOptions().getJonasBase() != null) {
                if (config.getGlobalOptions().getJonasBase().equals(config.getGlobalOptions().getJonasRoot())) {
                    throw new IllegalArgumentException("JONAS_BASE must be different from JONAS_ROOT for server " + sd);
                }
                File jonasBase = new File(config.getGlobalOptions().getJonasBase());
                Configurator.rmdir(jonasBase);
                config.getGlobalOptions().setJonasBase(jonasBase.getAbsolutePath());
            }
        }
        ConfigJonasApply apply = new ConfigJonasApply(jonasRoot);
        apply.setGlobalOptions(sd.getServer().getName(), sd.getDomain().getName(), config.getGlobalOptions());
        apply.setServiceDb(config.getDb());
        apply.setServiceDiscovery(config.getDiscovery());
        apply.setServiceHa(config.getHa());
        apply.setServiceMail(config.getMail());
        apply.setServiceWeb(config.getWeb());
        apply.setServiceWsdlPublisher(config.getWsdlPublisher());
        apply.setSecurityManager(config.getSecurityManager());
        apply.setEjbClusteringConfiguration(config.getEjbClustering());
        apply.setJmsConfiguration(config.getJms());
        apply.setJdbcConfiguration(config.getJdbc());
        apply.execute();
        Configurator.createScripts(config.getGlobalOptions().getJavaHome(), config.getGlobalOptions().getJavaOpts(), config.getGlobalOptions().getJonasRoot(), config.getGlobalOptions().getJonasBase(), sd.getDomain().getName(), sd.getServer().getName());
        logger.info("Server " + sd + " configured successfully");
    }

    public static void setAConfiguration(Configuration config, ServerDomain sd) {
        if (config.getGlobalOptions() == null || config.getGlobalOptions().getJonasRoot() == null) {
            throw new IllegalArgumentException("The topology file doesn't define any JONAS_ROOT");
        }
        Configurator.setAConfiguration(config, sd, config.getGlobalOptions().getJonasRoot());
    }

    private static void createScripts(String javaHome, String javaOpts, String jonasRoot, String jonasBase, String jonasDomain, String jonasName) {
        if (javaOpts == null) {
            javaOpts = "";
        }
        if (jonasName == null) {
            jonasName = "jonas";
        }
        if (jonasDomain == null) {
            jonasDomain = "jonas";
        }
        try {
            File f = new File(jonasBase, "setenv.bat");
            FileWriter fw = new FileWriter(f, false);
            if (javaHome != null) {
                fw.write("SET JAVA_HOME=" + javaHome + "\r\n");
            }
            fw.write("SET JAVA_OPTS=%JAVA_OPTS% " + javaOpts + "\r\n\r\n");
            fw.write("SET JONAS_ROOT=" + jonasRoot + "\r\n");
            fw.write("SET JONAS_BASE=" + jonasBase + "\r\n");
            fw.write("SET JONAS_OPTS=%JONAS_OPTS% -Djonas.name=" + jonasName + " -Ddomain.name=" + jonasDomain + "\r\n");
            fw.write("SET PATH=%JONAS_ROOT%\\bin;%JONAS_ROOT%\\bin\\nt;%PATH%\r\n");
            fw.close();
            f = new File(jonasBase, "setenv");
            fw = new FileWriter(f, false);
            fw.write("#!/bin/sh\n");
            if (javaHome != null) {
                fw.write("JAVA_HOME=" + javaHome.replace(" ", "\\ ") + "\n");
                fw.write("export JAVA_HOME\n");
            }
            fw.write("JAVA_OPTS=$JAVA_OPTS\\ " + javaOpts.replace(" ", "\\ ") + "\n");
            fw.write("export JAVA_OPTS\n\n");
            fw.write("JONAS_ROOT=" + jonasRoot.replace(" ", "\\ ") + "\n");
            fw.write("export JONAS_ROOT\n");
            fw.write("JONAS_BASE=" + jonasBase.replace(" ", "\\ ") + "\n");
            fw.write("export JONAS_BASE\n");
            fw.write("JONAS_OPTS=$JONAS_OPTS\\ -Djonas.name=" + jonasName + "\\ -Ddomain.name=" + jonasDomain + "\n");
            fw.write("export JONAS_OPTS\n");
            fw.write("PATH=$JONAS_ROOT/bin:$JONAS_ROOT/bin/unix:$PATH\n");
            fw.write("export PATH\n");
            fw.close();
            try {
                Process p = Runtime.getRuntime().exec("chmod a+x " + f.getAbsolutePath());
                p.waitFor();
            }
            catch (IOException ignored) {}
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot write the scripts", e);
        }
    }
}

