/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2012 Bull S.A.S.
 * Copyright (C) 2012 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DeploymeMojo.java 9991 2012-04-25 09:15:50Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.deployme.mojo;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.ow2.jasmine.deployme.DeployMeService;
import org.ow2.jasmine.deployme.extensions.web.tomcat.tomcat7.Tomcat7Extension;
import org.ow2.jasmine.deployme.module.audit.Audit;
import org.ow2.jasmine.deployme.module.bootstrap.Bootstrap;
import org.ow2.jasmine.deployme.module.carol.Carol;
import org.ow2.jasmine.deployme.module.cdi.Cdi;
import org.ow2.jasmine.deployme.module.cmi.Cmi;
import org.ow2.jasmine.deployme.module.db.Db;
import org.ow2.jasmine.deployme.module.depmonitor.Depmonitor;
import org.ow2.jasmine.deployme.module.discovery.Discovery;
import org.ow2.jasmine.deployme.module.ear.Ear;
import org.ow2.jasmine.deployme.module.ejb.Ejb;
import org.ow2.jasmine.deployme.module.ha.Ha;
import org.ow2.jasmine.deployme.module.jaxrpc.Jaxrpc;
import org.ow2.jasmine.deployme.module.jaxrs.Jaxrs;
import org.ow2.jasmine.deployme.module.jaxws.Jaxws;
import org.ow2.jasmine.deployme.module.jms.Jms;
import org.ow2.jasmine.deployme.module.jndi.Jndi;
import org.ow2.jasmine.deployme.module.jsf.Jsf;
import org.ow2.jasmine.deployme.module.jtm.Jtm;
import org.ow2.jasmine.deployme.module.mail.Mail;
import org.ow2.jasmine.deployme.module.resourcemonitor.ResourceMonitor;
import org.ow2.jasmine.deployme.module.resources.Resources;
import org.ow2.jasmine.deployme.module.security.Security;
import org.ow2.jasmine.deployme.module.smartclient.Smartclient;
import org.ow2.jasmine.deployme.module.validation.Validation;
import org.ow2.jasmine.deployme.module.versioning.Versioning;
import org.ow2.jasmine.deployme.module.wc.Wc;
import org.ow2.jasmine.deployme.module.web.Web;
import org.ow2.jasmine.deployme.module.wm.Wm;
import org.ow2.jasmine.deployme.module.wrapper.Wrapper;
import org.ow2.jasmine.deployme.module.wsdl.Wsdl;
import org.ow2.jasmine.shelbie.command.DeployMeCommand;

/** *
 * DeployMe Mojo
 * @goal generate
 * @requiresProject
 * @author Jeremy Cazaux
 */
public class DeploymeMojo extends AbstractMojo {

    /**
     * Path to the topology file
     * @parameter
     * @required
     */
    private String topologyFile;

    /**
     * Name of a machine in the topology file
     * @parameter
     */
    private String machineName;

    /**
     * A domain name of the topology file.
     * @parameter
     */
    private String domainName;

    /**
     * A server name of the topology file
     * @parameter
     */
    private String serverName;

    /**
     * A cluster name of the topology file
     * @parameter
     */
    private String clusterName;

    /**
     * {@inheritDoc}
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        DeployMeService deploymeService = new DeployMeService();
        deploymeService.bindDeploymeModule(new Audit());
        deploymeService.bindDeploymeModule(new Bootstrap());
        deploymeService.bindDeploymeModule(new Carol());
        deploymeService.bindDeploymeModule(new Cdi());
        deploymeService.bindDeploymeModule(new Cmi());
        deploymeService.bindDeploymeModule(new Db());
        deploymeService.bindDeploymeModule(new Depmonitor());
        deploymeService.bindDeploymeModule(new Discovery());
        deploymeService.bindDeploymeModule(new Ear());
        deploymeService.bindDeploymeModule(new Ejb());
        deploymeService.bindDeploymeModule(new Ha());
        deploymeService.bindDeploymeModule(new Jaxrpc());
        deploymeService.bindDeploymeModule(new Jaxrs());
        deploymeService.bindDeploymeModule(new Jaxws());
        deploymeService.bindDeploymeModule(new Jms());
        deploymeService.bindDeploymeModule(new Jndi());
        deploymeService.bindDeploymeModule(new Jsf());
        deploymeService.bindDeploymeModule(new Jtm());
        deploymeService.bindDeploymeModule(new Mail());
        deploymeService.bindDeploymeModule(new ResourceMonitor());
        deploymeService.bindDeploymeModule(new Resources());
        deploymeService.bindDeploymeModule(new Security());
        deploymeService.bindDeploymeModule(new Smartclient());
        deploymeService.bindDeploymeModule(new Validation());
        deploymeService.bindDeploymeModule(new Versioning());
        deploymeService.bindDeploymeModule(new Wc());
        deploymeService.bindDeploymeModule(new Web());
        deploymeService.bindDeploymeModule(new Wm());
        deploymeService.bindDeploymeModule(new Wrapper());
        deploymeService.bindDeploymeModule(new Wsdl());
        deploymeService.bindDeploymeExtension(new Tomcat7Extension());
        
        DeployMeCommand deployMeCommand = new DeployMeCommand();
        deployMeCommand.setDeploymeManager(deploymeService);
        deployMeCommand.setTopologyFilePath(this.topologyFile);
        if (this.machineName != null) {
            deployMeCommand.setMachineName(this.machineName);
        }
        if (this.domainName != null) {
            deployMeCommand.setDomainName(this.domainName);
        }
        if (this.serverName != null) {
            deployMeCommand.setServerName(this.serverName);
        }
        if (this.clusterName != null) {
            deployMeCommand.setClusterName(this.clusterName);
        }
        try {
            deployMeCommand.execute(null);
        } catch (Exception e) {
            throw new MojoExecutionException("Cannot deploy DeployME topology " + this.topologyFile, e);
        }
    }

    /**
     * @param topologyFile The topology file to set
     */
    public void setTopologyFile(String topologyFile) {
        this.topologyFile = topologyFile;
    }

    /**
     * @param machineName The name of the machine to set
     */
    public void setMachineName(String machineName) {
        this.machineName = machineName;
    }

    /**
     * @param serverName The server name to set
     */
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    /**
     * @param clusterName The cluster name to set
     */
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    /**
     * @param domainName The domain name to set
     */
    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }
}
