/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2012 Bull S.A.S.
 * Copyright (C) 2012 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Carol.java 10000 2012-05-02 14:52:40Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.deployme.module.carol;

import org.ow2.jasmine.deployme.module.AbstractDeploymeModule;
import org.ow2.jasmine.deployme.api.modules.UnsupportDeploymeModuleException;
import org.ow2.jonas.tools.configurator.api.JonasConfigurator;
import org.ow2.jasmine.deployme.v2.generated.CarolType;
import org.ow2.jasmine.deployme.v2.generated.JrmpType;
import org.ow2.jasmine.deployme.v2.generated.IiopType;
import org.ow2.jasmine.deployme.v2.generated.IrmiType;

/**
 * Carol Module
 */
public class Carol extends AbstractDeploymeModule  {

    /**
     * {@inheritDoc}
     */
    public boolean isSupport(final Object configuration) {
        return CarolType.class.isInstance(configuration);
    }

    /**
     * {@inheritDoc}
     */
    public void applyConfiguration(final JonasConfigurator configurator, final Object object) throws UnsupportDeploymeModuleException {
        if (isSupport(object)) {
            CarolType configuration = CarolType.class.cast(object);
            if (configuration != null) {
                StringBuilder stringBuilder = new StringBuilder();

                final String carolHost = configuration.getHost();
                if (carolHost != null) {
                    configurator.setCarolHost(carolHost);
                }
                final JrmpType jrmp = configuration.getJrmp();
                if (jrmp != null) {
                    final String jrmpPort = String.valueOf(jrmp.getPort());
                    if (jrmpPort != null) {
                        configurator.setProtocolsJrmpPort(jrmpPort);
                    }
                    final Boolean jrmpLocalRegistry = jrmp.isLocalRegistry();
                    if (jrmpLocalRegistry != null) {
                        configurator.setProtocolsJrmLocalRegistry(jrmpLocalRegistry);
                    }
                    final Boolean jrmpLocalOptimization = jrmp.isJndiLocalCallOptimisation();
                    if (jrmpLocalOptimization != null) {
                        configurator.setProtocolsLocalCallOptimized(jrmpLocalOptimization);
                    }
                    stringBuilder.append("jrmp,");
                }
                final IiopType iiop = configuration.getIiop();
                if (iiop != null) {
                    final String iiopPort = String.valueOf(iiop.getPort());
                    if (iiopPort != null) {
                        configurator.setProtocolsIiopPort(iiopPort);
                    }
                    stringBuilder.append("iiop,");
                }
                final IrmiType irmi = configuration.getIrmi();
                if (irmi != null) {
                    String irmiPort = String.valueOf(irmi.getPort());
                    if (irmiPort != null) {
                        configurator.setProtocolsIrmiPort(irmiPort);
                    }
                    stringBuilder.append("irmi,");
                }

                String protocols = stringBuilder.toString();
                if (protocols.length() > 0) {
                    protocols = protocols.substring(0, protocols.length() - 1);
                }
                if (protocols != null) {
                    configurator.setProtocolsList(protocols);
                }
            }
        } else {
            throw new UnsupportDeploymeModuleException("Object " + object.getClass().getName() + " is not support.");
        }
    }

    /**
     * {@inheritDoc}
     */
    public String getJOnASService() {
        return null;
    }
}
