/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2012 Bull S.A.S.
 * Copyright (C) 2012 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Cmi.java 10000 2012-05-02 14:52:40Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.deployme.module.cmi;

import org.ow2.jasmine.deployme.module.AbstractDeploymeModule;
import org.ow2.jasmine.deployme.api.modules.UnsupportDeploymeModuleException;
import org.ow2.jonas.tools.configurator.api.JonasConfigurator;
import org.ow2.jasmine.deployme.v2.generated.CmiType;

/**
 * CMI module
 */
public class Cmi extends AbstractDeploymeModule  {

    /**
     * JOnAS service
     */
    public static String JONAS_SERVICE = "cmi";

    /**
     * {@inheritDoc}
     */
    public boolean isSupport(final Object configuration) {
        return CmiType.class.isInstance(configuration);
    }

    /**
     * {@inheritDoc}
     */
    public void applyConfiguration(final JonasConfigurator configurator, final Object object) throws UnsupportDeploymeModuleException {
        if (isSupport(object)) {
            CmiType configuration = CmiType.class.cast(object);
            if (configuration != null) {
                configurator.setEjbClusteringActivated(true);
                String multicastAdress = configuration.getMulticastAddress();
                if (multicastAdress != null) {
                    configurator.setEjbClusteringMulticastAddress(multicastAdress);
                }
                String multicastPort = String.valueOf(configuration.getMulticastPort());
                if (multicastPort != null) {
                    configurator.setEjbClusteringMulticastPort(multicastPort);
                }
                Boolean isReplicationEnable = configuration.isReplicationEnabled();
                if (isReplicationEnable != null) {
                    configurator.setEjbClusteringReplicationEnable(isReplicationEnable);
                }
            }
        } else {
            throw new UnsupportDeploymeModuleException("Object " + object.getClass().getName() + " is not support");
        }
    }

    /**
     * {@inheritDoc}
     */
    public String getJOnASService() {
        return JONAS_SERVICE;
    }
}
