/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2012 Bull S.A.S.
 * Copyright (C) 2012 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Db.java 10000 2012-05-02 14:52:40Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.deployme.module.db;

import org.ow2.jasmine.deployme.api.modules.UnsupportDeploymeModuleException;
import org.ow2.jonas.tools.configurator.api.JonasConfigurator;
import org.ow2.jasmine.deployme.v2.generated.DbType;
import org.ow2.jasmine.deployme.v2.generated.DbUsersType;
import org.ow2.jasmine.deployme.v2.generated.DbUserType;
import org.ow2.jasmine.deployme.module.AbstractDeploymeModule;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * DB module
 */
public class Db extends AbstractDeploymeModule {

    /**
     * JOnAS service
     */
    public static String JONAS_SERVICE = "db";

    /**
     * {@inheritDoc}
     */
    public boolean isSupport(final Object configuration) {
        return DbType.class.isInstance(configuration);
    }

    /**
     * {@inheritDoc}
     */
    public void applyConfiguration(final JonasConfigurator configurator, final Object object) throws UnsupportDeploymeModuleException {
        if (isSupport(object)) {
            DbType configuration = DbType.class.cast(object);
            if (configuration != null) {
                final String dbPort = String.valueOf(configuration.getPort());
                if (dbPort != null) {
                    configurator.setDbPort(dbPort);
                }
                final String dbName = String.valueOf(configuration.getDbName());
                if (dbName != null) {
                    configurator.setDbName(dbName);
                }
                final DbUsersType dbUsers = configuration.getUsers();
                if (dbUsers != null) {
                    final List<DbUserType> users = dbUsers.getUser();
                    if (users != null && !users.isEmpty()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (DbUserType user: users) {
                            stringBuilder.append(user.getUsername());
                            stringBuilder.append(":");
                            stringBuilder.append(user.getPassword());
                            stringBuilder.append(",");
                        }
                        String usersAsString = stringBuilder.toString();
                        configurator.setDbUsers(usersAsString.substring(0, usersAsString.length() - 1));
                    }
                }
            }
        } else {
            throw new UnsupportDeploymeModuleException("Object " + object.getClass().getName() + " is not support");
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Map<Class, Field> getClassIdField() {
        Map<Class, Field> classIdField = new HashMap<Class, Field>();
        Class clazz = DbUserType.class;
        Field field = getField(clazz, "username");
        if (field != null) {
            classIdField.put(clazz, field);
        }
        return classIdField;
    }

    /**
     * {@inheritDoc}
     */
    public String getJOnASService() {
        return JONAS_SERVICE;
    }
}
