/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2012 Bull S.A.S.
 * Copyright (C) 2012 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Mail.java 10000 2012-05-02 14:52:40Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.deployme.module.mail;

import org.ow2.jasmine.deployme.module.AbstractDeploymeModule;
import org.ow2.jasmine.deployme.api.modules.UnsupportDeploymeModuleException;
import org.ow2.jasmine.deployme.v2.generated.MailType;
import org.ow2.jonas.tools.configurator.api.JonasConfigurator;
import org.ow2.jasmine.deployme.v2.generated.MailSessionType;
import org.ow2.jasmine.deployme.v2.generated.MailMimeType;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Mail module
 */
public class Mail extends AbstractDeploymeModule{

    /**
     * JOnAS service
     */
    public static final String JONAS_SERVICE = "mail";

    /**
     * {@inheritDoc}
     */
    public boolean isSupport(final Object configuration) {
        return MailType.class.isInstance(configuration);
    }

    /**
     * {@inheritDoc}
     */
    public void applyConfiguration(final JonasConfigurator configurator, final Object object) throws UnsupportDeploymeModuleException {
        if (isSupport(object)) {
            MailType configuration = MailType.class.cast(object);
            if (configuration != null) {
                final List<MailSessionType> mailSessions = configuration.getMailSession();
                if (mailSessions != null && !mailSessions.isEmpty()) {
                    for (MailSessionType mailSession: mailSessions) {
                        final String name = mailSession.getName();
                        if (name != null) {
                            configurator.addMailSession(name);
                        }
                    }
                }
                final List<MailMimeType> mailMimes = configuration.getMailMimePartDataSource();
                if (mailMimes != null && !mailMimes.isEmpty()) {
                    for (MailMimeType mailMime: mailMimes) {
                        final String name = mailMime.getName();
                        final String host = mailMime.getHost();
                        final String mailto = mailMime.getMailTo();
                        final String subject = mailMime.getSubject();
                        if (name != null && host != null && mailto != null && subject != null) {
                            configurator.addMailMimme(name, host, mailto, subject);
                        }
                    }
                }
            }
        } else {
            throw new UnsupportDeploymeModuleException("Object " + object.getClass().getName() + " is not support");
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Map<Class, Field> getClassIdField() {
        Map<Class, Field> classIdField = new HashMap<Class, Field>();
        Class clazz = MailSessionType.class;
        Field field = getField(clazz, "name");
        if (field != null) {
            classIdField.put(clazz, field);
        }
        clazz = MailMimeType.class;
        field = getField(clazz, "name");
        if (field != null) {
            classIdField.put(clazz, field);
        }
        return classIdField;
    }

    public String getJOnASService() {
        return JONAS_SERVICE;
    }
}
