/**
 * JASMINe Deploy ME [Managed Element]
 * Copyright (C) 2012 Bull S.A.S.
 * Copyright (C) 2012 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Resources.java 10000 2012-05-02 14:52:40Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.deployme.module.resources;

import org.ow2.jasmine.deployme.module.AbstractDeploymeModule;
import org.ow2.jasmine.deployme.api.modules.UnsupportDeploymeModuleException;
import org.ow2.jonas.tools.configurator.api.JdbcXMLConfiguration;
import org.ow2.jonas.tools.configurator.api.JonasConfigurator;
import org.ow2.jasmine.deployme.v2.generated.ResourcesType;
import org.ow2.jasmine.deployme.v2.generated.ResourceJdbcType;
import org.ow2.jasmine.deployme.v2.generated.PoolParametersType;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Resources module
 */
public class Resources extends AbstractDeploymeModule {

    /**
     * JOnAS Service
     */
    public static final String JONAS_SERVICE = "resource";

    /**
     * {@inheritDoc}
     */
    public boolean isSupport(final Object configuration) {
        return ResourcesType.class.isInstance(configuration);
    }

    /**
     * {@inheritDoc}
     */
    public void applyConfiguration(final JonasConfigurator configurator, final Object object) throws UnsupportDeploymeModuleException {
        if (isSupport(object)) {
            ResourcesType configuration = ResourcesType.class.cast(object);
            if (configuration != null) {
                List<ResourceJdbcType> resourcesJdbc = configuration.getResourceJdbc();
                if (resourcesJdbc != null) {
                    for (ResourceJdbcType resourceJdbc: resourcesJdbc) {

                        final JdbcXMLConfiguration jdbcXMLConfiguration = new JdbcXMLConfiguration();

                        final String resourceName = resourceJdbc.getResourceName();
                        if (resourceName != null) {
                            jdbcXMLConfiguration.name = resourceName;
                        }
                        final String className = resourceJdbc.getClassName();
                        if (className != null) {
                            jdbcXMLConfiguration.classname = className;
                        }
                        final String mapper = resourceJdbc.getMapperName();
                        if (mapper != null) {
                            jdbcXMLConfiguration.mapper = mapper;
                        }
                        final String url = resourceJdbc.getUrl();
                        if (url != null) {
                            jdbcXMLConfiguration.url = url;
                        }
                        final String user = resourceJdbc.getUser();
                        if (user != null) {
                            jdbcXMLConfiguration.username = user;
                        }
                        final String password = resourceJdbc.getPassword();
                        if (password != null) {
                            jdbcXMLConfiguration.password = password;
                        }
                        final String jdbcCheckLevel = resourceJdbc.getJdbcCheckLevel();
                        if (jdbcCheckLevel != null) {
                            jdbcXMLConfiguration.conCheckLevel = jdbcCheckLevel;
                        }
                        final String jdbcTestStatment = resourceJdbc.getJdbcTestStatment();
                        if (jdbcTestStatment != null) {
                            jdbcXMLConfiguration.conTestStmt = jdbcTestStatment;
                        }
                        final PoolParametersType poolParameters = resourceJdbc.getPoolParameters();
                        if (poolParameters != null) {
                            final String poolInit = String.valueOf(poolParameters.getPoolInit());
                            if (poolInit != null) {
                                jdbcXMLConfiguration.initConPool = poolInit;
                            }
                            final String poolMax = String.valueOf(poolParameters.getPoolMax());
                            if (poolMax != null) {
                                jdbcXMLConfiguration.maxConPool = poolMax;
                            }
                            final String poolMaxAge = String.valueOf(poolParameters.getPoolMaxAge());
                            if (poolMaxAge != null) {
                                jdbcXMLConfiguration.connMaxAge = poolMaxAge;
                            }
                            final String maxOpenTime = String.valueOf(poolParameters.getPoolMaxOpenTime());
                            if (maxOpenTime != null) {
                                jdbcXMLConfiguration.maxOpenTime = maxOpenTime;
                            }
                            final String maxWaiters = String.valueOf(poolParameters.getPoolMaxWaiters());
                            if (maxWaiters != null) {
                                jdbcXMLConfiguration.maxWaiters = maxWaiters;
                            }
                            final String maxWaitingTime = String.valueOf(poolParameters.getPoolMaxWaitingTime());
                            if (maxWaitingTime != null) {
                                jdbcXMLConfiguration.maxWaitTime = maxWaitingTime;
                            }
                            final String poolMin = String.valueOf(poolParameters.getPoolMin());
                            if (poolMin != null) {
                                jdbcXMLConfiguration.minConPool = poolMin;
                            }
                            final String poolSamplingPeriod = String.valueOf(poolParameters.getPoolSamplingPeriod());
                            if (poolSamplingPeriod != null) {
                                jdbcXMLConfiguration.samplingPeriod = poolSamplingPeriod;
                            }
                            final String pstmtCachePolicy = poolParameters.getPstmtCachePolicy();
                            if (pstmtCachePolicy != null) {
                                jdbcXMLConfiguration.pstmtCachePolicy = pstmtCachePolicy;
                            }
                            final String pstmtMax = String.valueOf(poolParameters.getPstmtMax());
                            if (pstmtMax != null) {
                                jdbcXMLConfiguration.pstmtMax = pstmtMax;
                            }
                        }

                        final String ref = resourceJdbc.getDbServiceRef();
                        if (ref == null) {
                            configurator.addJdbcResource(jdbcXMLConfiguration);
                        } else {
                            configurator.addJdbcResource(ref, jdbcXMLConfiguration);
                        }
                    }
                }
            }
        } else {
            throw new UnsupportDeploymeModuleException("Object " + object.getClass().getName() + " is not support");
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Map<Class, Field> getClassIdField() {
        Map<Class, Field> classIdField = new HashMap<Class, Field>();
        Class clazz = ResourceJdbcType.class;
        Field field = getField(clazz, "resourceName");
        if (field != null) {
            classIdField.put(clazz, field);
        }
        return classIdField;
    }

    /**
     * {@inheritDoc}
     */
    public String getJOnASService() {
        return JONAS_SERVICE;
    }
}
