/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.fdf.ejb.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.ow2.jasmine.fdf.JASMINeNodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FdfGenerator {
    protected VelocityContext context = null;
    static final String JADENODE_VM = "JadeNode.vm";
    static final String FDF_EXTENSION = ".fdf";

    public static void main(String[] args) {
        try {
            String tmp;
            VelocityEngine velocity = new VelocityEngine();
            velocity.setProperty("resource.loader", (Object)"class");
            velocity.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            velocity.init();
            VelocityContext context = new VelocityContext();
            List<String> argsList = Arrays.asList(args);
            String fdfName = tmp = FdfGenerator.getPropValue("-fdf", argsList);
            if (tmp != null) {
                context.put("fileName", (Object)tmp.replace(FDF_EXTENSION, ""));
                tmp = null;
            }
            if ((tmp = FdfGenerator.getPropValue("-registryhost", argsList)) != null) {
                context.put("jadebootHost", (Object)tmp);
                tmp = null;
            } else {
                context.put("jadebootHost", (Object)"");
            }
            tmp = FdfGenerator.getPropValue("-host", argsList);
            if (tmp != null) {
                context.put("host", (Object)tmp);
                tmp = null;
            } else {
                context.put("host", (Object)"");
            }
            tmp = FdfGenerator.getPropValue("-user", argsList);
            if (tmp != null) {
                context.put("user", (Object)tmp);
                tmp = null;
            } else {
                context.put("user", (Object)"");
            }
            tmp = FdfGenerator.getPropValue("-password", argsList);
            if (tmp != null) {
                context.put("password", (Object)tmp);
                tmp = null;
            } else {
                context.put("password", (Object)"");
            }
            tmp = FdfGenerator.getPropValue("-sshkey", argsList);
            if (tmp != null) {
                context.put("sshKey", (Object)tmp);
                tmp = null;
            } else {
                context.put("sshKey", (Object)"");
            }
            tmp = FdfGenerator.getPropValue("-jre", argsList);
            if (tmp != null) {
                context.put("jreHome", (Object)tmp);
                tmp = null;
            } else {
                context.put("jreHome", (Object)"");
            }
            tmp = FdfGenerator.getPropValue("-installdir", argsList);
            if (tmp != null) {
                context.put("installDir", (Object)tmp);
                tmp = null;
            } else {
                context.put("installDir", (Object)"");
            }
            tmp = FdfGenerator.getPropValue("-resourcedir", argsList);
            if (tmp != null) {
                context.put("resourcesDir", (Object)tmp);
                tmp = null;
            } else {
                context.put("resourcesDir", (Object)"");
            }
            tmp = FdfGenerator.getPropValue("-felixprofile", argsList);
            if (tmp != null) {
                context.put("felixProfile", (Object)tmp);
                tmp = null;
            }
            if ((tmp = FdfGenerator.getPropValue("-registryport", argsList)) != null) {
                context.put("registryPort", (Object)tmp);
                tmp = null;
            }
            if ((tmp = FdfGenerator.getPropValue("-discoveryport", argsList)) != null) {
                context.put("discoveryPort", (Object)tmp);
                tmp = null;
            }
            if ((tmp = FdfGenerator.getPropValue("-obrUrl", argsList)) != null) {
                context.put("obrRepositoryURL", (Object)tmp);
                tmp = null;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("file:bundles/org.apache.felix.shell-1.1.0-SNAPSHOT.jar ");
            buffer.append("file:bundles/org.apache.felix.bundlerepository-1.1.0-JADE-SNAPSHOT.jar ");
            buffer.append("file:bundles/org.apache.felix.configadmin-0.9.0-SNAPSHOT.jar ");
            buffer.append("file:bundles/org.apache.felix.log-0.9.0-SNAPSHOT.jar ");
            buffer.append("file:bundles/jadenode.jar ");
            context.put("autoStart", (Object)buffer.toString());
            Template template = velocity.getTemplate(JADENODE_VM);
            StringWriter writer = new StringWriter();
            if (template != null) {
                template.merge((Context)context, (Writer)writer);
            }
            File file = new File(System.getProperty("java.io.tmpdir") + File.separator + fdfName);
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter out = new BufferedWriter(fileWriter);
            out.write(writer.getBuffer().toString());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File generate(JASMINeNodeImpl jasmineNode) throws Exception {
        try {
            String fdfName = new Timestamp(System.currentTimeMillis()).toString().replace(" ", "_") + FDF_EXTENSION;
            VelocityEngine velocity = new VelocityEngine();
            velocity.setProperty("resource.loader", (Object)"class");
            velocity.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            velocity.init();
            VelocityContext context = new VelocityContext();
            context.put("jadebootHost", (Object)jasmineNode.getRegistryHost());
            context.put("host", (Object)jasmineNode.getHost());
            context.put("user", (Object)jasmineNode.getUser());
            context.put("password", (Object)jasmineNode.getPassword());
            context.put("sshKey", (Object)jasmineNode.getSshKey());
            context.put("jreHome", (Object)System.getProperty("java.home"));
            context.put("installDir", (Object)jasmineNode.getInstallDir());
            context.put("felixProfile", (Object)jasmineNode.getFelixProfile());
            context.put("registryPort", (Object)jasmineNode.getRegistryPort());
            context.put("discoveryPort", (Object)jasmineNode.getDiscoveryPort());
            Template template = velocity.getTemplate(JADENODE_VM);
            StringWriter writer = new StringWriter();
            if (template != null) {
                template.merge((Context)context, (Writer)writer);
            }
            File file = new File(System.getProperty("java.io.tmpdir") + File.separator + fdfName);
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter out = new BufferedWriter(fileWriter);
            out.write(writer.getBuffer().toString());
            out.close();
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private static String getPropValue(String propName, List<String> list) {
        int idx;
        String v;
        if (list.contains(propName) && !(v = list.get((idx = list.indexOf(propName)) + 1)).startsWith("-")) {
            return v;
        }
        return null;
    }
}

