/**
 * JASMINe
 * Copyright (C) 2006-2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:$
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.fdf.ejb;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionFactory;

import org.ow2.jasmine.fdf.JASMINeNodeImpl;
import org.ow2.jasmine.fdf.ra.api.FdfConnection;
import org.ow2.jasmine.fdf.ejb.util.FdfGenerator;

/**
 * Implementation of {@link org.ow2.jasmine.fdf.ejb.FdfEjb}.
 *
 * @author Julien Legrand
 *
 */
@Stateless(mappedName = "JASMINe/FDF/bean")
@Remote(FdfEjb.class)
@DeclareRoles({ "jasmine" })
public class FDFEjbImpl implements FdfEjb {

    /**
     *
     */
    @Resource(mappedName = "JASMINe/FDF/ConnectionFactory")
    private ConnectionFactory mcfFdf;

    /**
     *
     */
    private FdfConnection fdf = null;

    /**
     *
     */
    private static Logger logger = Logger.getLogger(FDFEjbImpl.class.getName());

    // ------------------------------------------------------------------------
    // Implementation of the FdfEjb interface
    // ------------------------------------------------------------------------

    /*
     * (non-Javadoc)
     *
     * @see org.ow2.jasmine.fdf.ejb.FdfEjb#install(org.ow2.jasmine.fdf.JASMINeNodeImpl)
     */
    @RolesAllowed({ "jasmine" })
    public final Integer install(final JASMINeNodeImpl jasmineNode)
            throws Exception {

        if (fdf == null) {
            getConnection();
        }
        // fdf.install(generateFdfFile(jasmineNode));
        fdf.install(jasmineNode);

        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see org.ow2.jasmine.fdf.ejb.FdfEjb#start(org.ow2.jasmine.fdf.JASMINeNodeImpl)
     */
    @RolesAllowed({ "jasmine" })
    public final Integer start(final JASMINeNodeImpl jasmineNode)
            throws Exception {

        if (fdf == null) {
            getConnection();
        }
        // fdf.start(generateFdfFile(jasmineNode));
        fdf.start(jasmineNode);

        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see org.ow2.jasmine.fdf.ejb.FdfEjb#stop(org.ow2.jasmine.fdf.JASMINeNodeImpl)
     */
    @RolesAllowed({ "jasmine" })
    public final Integer stop(final JASMINeNodeImpl jasmineNode)
            throws Exception {

        if (fdf == null) {
            getConnection();
        }
        // fdf.stop(generateFdfFile(jasmineNode));
        fdf.stop(jasmineNode);

        return null;
    }

    // ------------------------------------------------------------------------
    // Private methods
    // ------------------------------------------------------------------------

    /**
     * @throws NamingException
     * @throws ResourceException
     */
    private void getConnection() throws NamingException, ResourceException {

        if (mcfFdf == null) {

            logger.log(Level.SEVERE,
                    "javax.cci.ConnectionFactory not injected.");
            Context initialContext = new InitialContext();
            mcfFdf = (ConnectionFactory) initialContext
                    .lookup("JASMINe/FDF/ConnectionFactory");

        }

        fdf = (FdfConnection) mcfFdf.getConnection();

    }

    /**
     * @param jasmineNode
     * @return
     * @throws Exception
     */
    private File generateFdfFile(JASMINeNodeImpl jasmineNode) throws Exception {

        return FdfGenerator.generate(jasmineNode);

    }
}
