/**
 * JASMINe
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:$
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.fdf.ejb.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;

import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.ow2.jasmine.fdf.JASMINeNodeImpl;

/**
 * @author Julien Legrand
 *
 */
public class FdfGenerator {

    /**
     *
     */
    protected VelocityContext context = null;
    /**
     *
     */
    static final String JADENODE_VM = "JadeNode.vm";
    /**
     *
     */
    static final String FDF_EXTENSION = ".fdf";

    /**
     *
     */
    // private static Logger logger = Logger.getLogger(FdfGenerator.class
    // .getName());
    // ------------------------------------------------------------------------
    // Main methods
    // ------------------------------------------------------------------------
    /**
     * @param args
     *            list of arguments
     */
    public static void main(final String[] args) {

        try {

            VelocityEngine velocity = new VelocityEngine();

            velocity.setProperty("resource.loader", "class");
            velocity
                    .setProperty("class.resource.loader.class",
                            "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");

            velocity.init();

            VelocityContext context = new VelocityContext();

            List<String> argsList = Arrays.asList(args);

            String tmp = getPropValue("-fdf", argsList);
            String fdfName = tmp;
            if (tmp != null) {
                context.put("fileName", tmp.replace(".fdf", ""));
                tmp = null;
            }

            tmp = getPropValue("-registryhost", argsList);
            if (tmp != null) {
                context.put("jadebootHost", tmp);
                tmp = null;
            } else {
                context.put("jadebootHost", "");
            }

            tmp = getPropValue("-host", argsList);
            if (tmp != null) {
                context.put("host", tmp);
                tmp = null;
            } else {
                context.put("host", "");
            }

            tmp = getPropValue("-user", argsList);
            if (tmp != null) {
                context.put("user", tmp);
                tmp = null;
            } else {
                context.put("user", "");
            }

            tmp = getPropValue("-password", argsList);
            if (tmp != null) {
                context.put("password", tmp);
                tmp = null;
            } else {
                context.put("password", "");
            }

            tmp = getPropValue("-sshkey", argsList);
            if (tmp != null) {
                context.put("sshKey", tmp);
                tmp = null;
            } else {
                context.put("sshKey", "");
            }

            tmp = getPropValue("-jre", argsList);
            if (tmp != null) {
                context.put("jreHome", tmp);
                tmp = null;
            } else {
                context.put("jreHome", "");
            }

            tmp = getPropValue("-installdir", argsList);
            if (tmp != null) {
                context.put("installDir", tmp);
                tmp = null;
            } else {
                context.put("installDir", "");
            }

            tmp = getPropValue("-resourcedir", argsList);
            if (tmp != null) {
                context.put("resourcesDir", tmp);
                tmp = null;
            } else {
                context.put("resourcesDir", "");
            }

            tmp = getPropValue("-felixprofile", argsList);
            if (tmp != null) {
                context.put("felixProfile", tmp);
                tmp = null;
            }

            tmp = getPropValue("-registryport", argsList);
            if (tmp != null) {
                context.put("registryPort", tmp);
                tmp = null;
            }

            tmp = getPropValue("-discoveryport", argsList);
            if (tmp != null) {
                context.put("discoveryPort", tmp);
                tmp = null;
            }

            tmp = getPropValue("-obrUrl", argsList);
            if (tmp != null) {
                context.put("obrRepositoryURL", tmp);
                tmp = null;
            }

            StringBuffer buffer = new StringBuffer();
            buffer
                    .append("file:bundles/org.apache.felix.shell-1.1.0-SNAPSHOT.jar ");
            // buffer.append("file:bundles/org.apache.felix.shell.tui-1.1.0-SNAPSHOT.jar
            // ");
            buffer
                    .append("file:bundles/org.apache.felix.bundlerepository-1.1.0-JADE-SNAPSHOT.jar ");
            buffer
                    .append("file:bundles/org.apache.felix.configadmin-0.9.0-SNAPSHOT.jar ");
            buffer
                    .append("file:bundles/org.apache.felix.log-0.9.0-SNAPSHOT.jar ");
            buffer.append("file:bundles/jadenode.jar ");
            // buffer.append("file:./bundles/org.apache.felix.mosgi.console.ifc-0.9.0-SNAPSHOT.jar
            // ");
            // buffer.append("file:./bundles/org.apache.felix.mosgi.jmx.agent-0.9.0-SNAPSHOT.jar
            // ");
            // buffer.append("file:./bundles/org.apache.felix.mosgi.jmx.registry-0.9.0-SNAPSHOT.jar
            // ");
            // buffer.append("file:./bundles/org.apache.felix.mosgi.jmx.rmiconnector-0.9.0-SNAPSHOT.jar
            // ");
            // buffer.append("file:./bundles/org.apache.felix.mosgi.jmx.httpconnector-0.9.0-SNAPSHOT.jar
            // ");
            // buffer.append("file:./bundles/org.apache.felix.mosgi.jmx.remotelogger-0.9.0-SNAPSHOT.jar
            // ");
            // buffer.append("file:./bundles/org.apache.felix.mosgi.managedelements.osgiprobes-0.9.0-SNAPSHOT.jar
            // ");
            // buffer.append("file:./bundles/org.apache.felix.mosgi.managedelements.obrprobe-0.9.0-SNAPSHOT.jar
            // ");
            // buffer.append("file:./bundles/org.apache.felix.mosgi.managedelements.bundlesprobes-0.9.0-SNAPSHOT.jar
            // ");
            // buffer.append("file:./bundles/org.apache.felix.mosgi.managedelements.memoryprobe-0.9.0-SNAPSHOT.jar
            // ");

            context.put("autoStart", buffer.toString());

            Template template = velocity.getTemplate(JADENODE_VM);

            StringWriter writer = new StringWriter();

            if (template != null) {
                template.merge(context, writer);
            }

            File file = new File(System.getProperty("java.io.tmpdir")
                    + File.separator + fdfName);
            FileWriter fileWriter = new FileWriter(file);

            BufferedWriter out = new BufferedWriter(fileWriter);

            out.write(writer.getBuffer().toString());
            out.close();

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    // ------------------------------------------------------------------------
    // Static methods
    // ------------------------------------------------------------------------

    /**
     * @param jasmineNode
     * @return
     * @throws Exception
     */
    public static File generate(JASMINeNodeImpl jasmineNode) throws Exception {

        try {

            String fdfName = new Timestamp(System.currentTimeMillis())
                    .toString().replace(" ", "_")
                    + FDF_EXTENSION;

            VelocityEngine velocity = new VelocityEngine();

            velocity.setProperty("resource.loader", "class");
            velocity
                    .setProperty("class.resource.loader.class",
                            "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");

            velocity.init();

            VelocityContext context = new VelocityContext();
            context.put("jadebootHost", jasmineNode.getRegistryHost());
            context.put("host", jasmineNode.getHost());
            context.put("user", jasmineNode.getUser());
            context.put("password", jasmineNode.getPassword());
            context.put("sshKey", jasmineNode.getSshKey());
            context.put("jreHome", System.getProperty("java.home"));
            context.put("installDir", jasmineNode.getInstallDir());
            context.put("felixProfile", jasmineNode.getFelixProfile());
            context.put("registryPort", jasmineNode.getRegistryPort());
            context.put("discoveryPort", jasmineNode.getDiscoveryPort());

            Template template = velocity.getTemplate(JADENODE_VM);

            StringWriter writer = new StringWriter();

            if (template != null) {
                template.merge(context, writer);
            }

            File file = new File(System.getProperty("java.io.tmpdir")
                    + File.separator + fdfName);
            FileWriter fileWriter = new FileWriter(file);

            BufferedWriter out = new BufferedWriter(fileWriter);

            out.write(writer.getBuffer().toString());
            out.close();

            return file;

        } catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    // ------------------------------------------------------------------------
    // Private methods
    // ------------------------------------------------------------------------

    private static String getPropValue(String propName, List<String> list) {

        if (list.contains(propName)) {
            int idx = list.indexOf(propName);

            String v = list.get(idx + 1);
            if (!v.startsWith("-")) {
                return v;
            }
        }
        return null;

    }

}
