/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.fdf.ejb;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionFactory;
import org.ow2.jasmine.fdf.JASMINeNodeImpl;
import org.ow2.jasmine.fdf.ejb.FdfEjb;
import org.ow2.jasmine.fdf.ejb.util.FdfGenerator;
import org.ow2.jasmine.fdf.ra.api.FdfConnection;

@Stateless(mappedName="JASMINe/FDF/bean")
@Remote(value={FdfEjb.class})
@DeclareRoles(value={"jasmine"})
public class FDFEjbImpl
implements FdfEjb {
    @Resource(mappedName="JASMINe/FDF/ConnectionFactory")
    private ConnectionFactory mcfFdf;
    private FdfConnection fdf = null;
    private static Logger logger = Logger.getLogger(FDFEjbImpl.class.getName());

    @RolesAllowed(value={"jasmine"})
    public final Integer install(JASMINeNodeImpl jasmineNode) throws Exception {
        if (this.fdf == null) {
            this.getConnection();
        }
        this.fdf.install(jasmineNode);
        return null;
    }

    @RolesAllowed(value={"jasmine"})
    public final Integer start(JASMINeNodeImpl jasmineNode) throws Exception {
        if (this.fdf == null) {
            this.getConnection();
        }
        this.fdf.start(jasmineNode);
        return null;
    }

    @RolesAllowed(value={"jasmine"})
    public final Integer stop(JASMINeNodeImpl jasmineNode) throws Exception {
        if (this.fdf == null) {
            this.getConnection();
        }
        this.fdf.stop(jasmineNode);
        return null;
    }

    private void getConnection() throws NamingException, ResourceException {
        if (this.mcfFdf == null) {
            logger.log(Level.SEVERE, "javax.cci.ConnectionFactory not injected.");
            InitialContext initialContext = new InitialContext();
            this.mcfFdf = (ConnectionFactory)initialContext.lookup("JASMINe/FDF/ConnectionFactory");
        }
        this.fdf = (FdfConnection)this.mcfFdf.getConnection();
    }

    private File generateFdfFile(JASMINeNodeImpl jasmineNode) throws Exception {
        return FdfGenerator.generate(jasmineNode);
    }
}

